/*
 * Decompiled with CFR 0.152.
 */
package com.pivotallabs.robolectricgem.matchers;

import android.app.Dialog;
import com.pivotallabs.greatexpectations.GreatExpectations;
import com.pivotallabs.robolectricgem.expect.Expect;
import com.pivotallabs.robolectricgem.matchers.DialogMatcher;
import com.xtremelabs.robolectric.RobolectricTestRunner;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=RobolectricTestRunner.class)
public class DialogMatcherTest {
    private Dialog dialog;
    private DialogMatcher<Dialog, ?> matcher;

    @Before
    public void setUp() throws Exception {
        this.dialog = new Dialog(null);
        this.matcher = this.newDialogMatcher(this.dialog);
    }

    @Test
    public void test_toHaveTitle() throws Exception {
        this.dialog.setTitle(null);
        Expect.expect(this.matcher.toHaveTitle(null)).toBeTrue();
        this.dialog.setTitle((CharSequence)"the title");
        Expect.expect(this.matcher.toHaveTitle("the title")).toBeTrue();
        Expect.expect(this.matcher.toHaveTitle("other title")).toBeFalse();
    }

    @Test
    public void test_toHaveTitle_failureMessages() throws Exception {
        this.dialog.setTitle((CharSequence)"the title");
        this.matcher.toHaveTitle("the title");
        Expect.expect(this.matcher.getDescriptionOfActual()).toEqual((Object)"Dialog[title=the title]");
        this.matcher.toHaveTitle("not the same title");
        Expect.expect(this.matcher.getDescriptionOfActual()).toEqual((Object)"Dialog[title=the title]");
    }

    @Test
    public void test_toBeShowing() throws Exception {
        Expect.expect(this.matcher.toBeShowing()).toBeFalse();
        this.dialog.show();
        Expect.expect(this.matcher.toBeShowing()).toBeTrue();
        this.dialog.dismiss();
        Expect.expect(this.matcher.toBeShowing()).toBeFalse();
    }

    @Test
    public void test_toBeDismissed() throws Exception {
        Expect.expect(this.matcher.toBeDismissed()).toBeFalse();
        this.dialog.show();
        Expect.expect(this.matcher.toBeDismissed()).toBeFalse();
        this.dialog.dismiss();
        Expect.expect(this.matcher.toBeDismissed()).toBeTrue();
    }

    private <T extends Dialog> DialogMatcher<T, ?> newDialogMatcher(T value) {
        DialogMatcher matcher = new DialogMatcher();
        GreatExpectations.setActual(matcher, value);
        return matcher;
    }
}

