/*
 * Decompiled with CFR 0.152.
 */
package com.pivotallabs.robolectricgem.matchers;

import android.app.AlertDialog;
import android.content.DialogInterface;
import com.pivotallabs.greatexpectations.GreatExpectations;
import com.pivotallabs.robolectricgem.expect.Expect;
import com.pivotallabs.robolectricgem.matchers.AlertDialogMatcher;
import com.xtremelabs.robolectric.RobolectricTestRunner;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=RobolectricTestRunner.class)
public class AlertDialogMatcherTest {
    private AlertDialogMatcher<AlertDialog, ?> matcher;
    private AlertDialog.Builder builder;

    @Before
    public void setup() throws Exception {
        this.builder = new AlertDialog.Builder(null);
    }

    @Test
    public void test_toHaveMessage() throws Exception {
        this.createDialog(this.builder);
        Expect.expect(this.matcher.toHaveMessage(null)).toBeTrue();
        this.builder.setMessage((CharSequence)"the message");
        this.createDialog(this.builder);
        Expect.expect(this.matcher.toHaveMessage("the message")).toBeTrue();
        Expect.expect(this.matcher.toHaveMessage("other message")).toBeFalse();
    }

    @Test
    public void test_toHaveMessage_failureMessages() throws Exception {
        this.builder.setMessage((CharSequence)"the message");
        this.createDialog(this.builder);
        this.matcher.toHaveMessage("the message");
        Expect.expect(this.matcher.getDescriptionOfActual()).toEqual((Object)"AlertDialog[message=the message]");
        this.matcher.toHaveMessage("not the same message");
        Expect.expect(this.matcher.getDescriptionOfActual()).toEqual((Object)"AlertDialog[message=the message]");
    }

    @Test
    public void test_toHavePositiveButtonText() throws Exception {
        this.builder.setPositiveButton(null, null);
        this.createDialog(this.builder);
        Expect.expect(this.matcher.toHavePositiveButtonText("")).toBeFalse();
        this.builder.setPositiveButton(null, (DialogInterface.OnClickListener)new NoOpClickListener());
        this.createDialog(this.builder);
        Expect.expect(this.matcher.toHavePositiveButtonText("")).toBeTrue();
        this.builder.setPositiveButton((CharSequence)"button text", null);
        this.createDialog(this.builder);
        Expect.expect(this.matcher.toHavePositiveButtonText("button text")).toBeTrue();
        Expect.expect(this.matcher.toHavePositiveButtonText("other text")).toBeFalse();
    }

    @Test
    public void test_toHavePositiveButtonText_failureMessages() throws Exception {
        this.builder.setPositiveButton(null, null);
        this.createDialog(this.builder);
        this.matcher.toHavePositiveButtonText("anything");
        Expect.expect(this.matcher.getDescriptionOfActual()).toEqual((Object)"AlertDialog[positiveButton=null]");
        this.builder.setPositiveButton((CharSequence)"button text", null);
        this.createDialog(this.builder);
        this.matcher.toHavePositiveButtonText("button text");
        Expect.expect(this.matcher.getDescriptionOfActual()).toEqual((Object)"AlertDialog[positiveButtonText=button text]");
        this.matcher.toHavePositiveButtonText("not the same text");
        Expect.expect(this.matcher.getDescriptionOfActual()).toEqual((Object)"AlertDialog[positiveButtonText=button text]");
    }

    @Test
    public void test_toHaveNegativeButtonText() throws Exception {
        this.builder.setNegativeButton(null, (DialogInterface.OnClickListener)new NoOpClickListener());
        this.createDialog(this.builder);
        Expect.expect(this.matcher.toHaveNegativeButtonText("")).toBeTrue();
        this.builder.setNegativeButton((CharSequence)"button text", null);
        this.createDialog(this.builder);
        Expect.expect(this.matcher.toHaveNegativeButtonText("button text")).toBeTrue();
        Expect.expect(this.matcher.toHaveNegativeButtonText("other text")).toBeFalse();
    }

    @Test
    public void test_toHaveNegativeButtonText_failureMessages() throws Exception {
        this.builder.setNegativeButton((CharSequence)"button text", null);
        this.createDialog(this.builder);
        this.matcher.toHaveNegativeButtonText("button text");
        Expect.expect(this.matcher.getDescriptionOfActual()).toEqual((Object)"AlertDialog[negativeButtonText=button text]");
        this.matcher.toHaveNegativeButtonText("not the same text");
        Expect.expect(this.matcher.getDescriptionOfActual()).toEqual((Object)"AlertDialog[negativeButtonText=button text]");
    }

    @Test
    public void test_toHaveNeutralButtonText() throws Exception {
        this.builder.setNeutralButton(null, (DialogInterface.OnClickListener)new NoOpClickListener());
        this.createDialog(this.builder);
        Expect.expect(this.matcher.toHaveNeutralButtonText("")).toBeTrue();
        this.builder.setNeutralButton((CharSequence)"button text", null);
        this.createDialog(this.builder);
        Expect.expect(this.matcher.toHaveNeutralButtonText("button text")).toBeTrue();
        Expect.expect(this.matcher.toHaveNeutralButtonText("other text")).toBeFalse();
    }

    @Test
    public void test_toHaveNeutralButtonText_failureMessages() throws Exception {
        this.builder.setNeutralButton((CharSequence)"button text", null);
        this.createDialog(this.builder);
        this.matcher.toHaveNeutralButtonText("button text");
        Expect.expect(this.matcher.getDescriptionOfActual()).toEqual((Object)"AlertDialog[neutralButtonText=button text]");
        this.matcher.toHaveNeutralButtonText("not the same text");
        Expect.expect(this.matcher.getDescriptionOfActual()).toEqual((Object)"AlertDialog[neutralButtonText=button text]");
    }

    private void createDialog(AlertDialog.Builder builder) {
        AlertDialog dialog = builder.create();
        this.matcher = this.newAlertDialogMatcher(dialog);
    }

    private <T extends AlertDialog> AlertDialogMatcher<T, ?> newAlertDialogMatcher(T value) {
        AlertDialogMatcher matcher = new AlertDialogMatcher();
        GreatExpectations.setActual(matcher, value);
        return matcher;
    }

    private static class NoOpClickListener
    implements DialogInterface.OnClickListener {
        private NoOpClickListener() {
        }

        public void onClick(DialogInterface dialog, int which) {
        }
    }
}

