/*
 * Decompiled with CFR 0.152.
 */
package com.pivotallabs.robolectricgem.matchers;

import android.app.AlertDialog;
import android.widget.Button;
import com.pivotallabs.greatexpectations.MatcherOf;
import com.pivotallabs.robolectricgem.matchers.DialogMatcher;
import com.xtremelabs.robolectric.Robolectric;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MatcherOf(value={AlertDialog.class})
public class AlertDialogMatcher<T extends AlertDialog, M extends AlertDialogMatcher<T, M>>
extends DialogMatcher<T, M> {
    public boolean toHaveMessage(CharSequence expectedMessage) {
        String actualMessage = Robolectric.shadowOf((AlertDialog)((AlertDialog)this.actual)).getMessage();
        this.setDescriptionOfActual("message", actualMessage);
        return this.equalsAllowingNull(actualMessage, expectedMessage);
    }

    public boolean toHavePositiveButtonText(CharSequence expectedButtonText) {
        return this.hasButtonText(expectedButtonText, -1, "positiveButton");
    }

    public boolean toHaveNegativeButtonText(CharSequence expectedButtonText) {
        return this.hasButtonText(expectedButtonText, -2, "negativeButton");
    }

    public boolean toHaveNeutralButtonText(CharSequence expectedButtonText) {
        return this.hasButtonText(expectedButtonText, -3, "neutralButton");
    }

    private boolean hasButtonText(CharSequence expectedButtonText, int button, String propertyName) {
        Button actualButton = ((AlertDialog)this.actual).getButton(button);
        if (actualButton == null) {
            this.setDescriptionOfActual(propertyName, null);
            return false;
        }
        CharSequence actualButtonText = actualButton.getText();
        this.setDescriptionOfActual(propertyName + "Text", actualButtonText);
        return actualButtonText.equals(expectedButtonText);
    }
}

