/*
 * Decompiled with CFR 0.152.
 */
package tv.ouya.console.api.store;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AppDetails
implements Parcelable {
    public static final Parcelable.Creator<AppDetails> CREATOR = new Parcelable.Creator<AppDetails>(){

        public AppDetails createFromParcel(Parcel parcel) {
            String title = parcel.readString();
            String description = parcel.readString();
            String mainImageFullUrl = parcel.readString();
            String uuid = parcel.readString();
            Long apkFileSize = parcel.readLong();
            String versionNumber = parcel.readString();
            String publishedAt = parcel.readString();
            ArrayList<String> imageUrls = new ArrayList<String>();
            parcel.readStringList(imageUrls);
            Long likeCount = parcel.readLong();
            String overview = parcel.readString();
            String rating = parcel.readString();
            String versionUuid = parcel.readString();
            return new AppDetails(title, description, mainImageFullUrl, uuid, apkFileSize, versionNumber, publishedAt, imageUrls, likeCount, overview, rating, versionUuid);
        }

        public AppDetails[] newArray(int size) {
            return new AppDetails[size];
        }
    };
    public String title;
    public String description;
    public String mainImageFullUrl;
    public String uuid;
    public Long apkFileSize;
    public String versionNumber;
    public String publishedAt;
    public List<String> imageUrls;
    public Long likeCount;
    public String overview;
    public String rating;
    public String latestVersion;

    public AppDetails() {
        this.imageUrls = new ArrayList<String>();
    }

    public AppDetails(JSONObject object) throws JSONException {
        this.readFromJSON(object);
    }

    public AppDetails(String title, String description, String mainImageFullUrl, String uuid, Long apkFileSize, String versionNumber, String publishedAt, List<String> imageUrls, Long likeCount, String overview, String rating, String latestVersion) {
        this.title = title;
        this.description = description;
        this.mainImageFullUrl = mainImageFullUrl;
        this.uuid = uuid;
        this.apkFileSize = apkFileSize;
        this.versionNumber = versionNumber;
        this.publishedAt = publishedAt;
        this.imageUrls = imageUrls;
        this.likeCount = likeCount;
        this.overview = overview;
        this.rating = rating;
        this.latestVersion = latestVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AppDetails)) {
            return false;
        }
        AppDetails that = (AppDetails)o;
        if (!this.description.equals(that.description)) {
            return false;
        }
        if (!this.mainImageFullUrl.equals(that.mainImageFullUrl)) {
            return false;
        }
        if (!this.title.equals(that.title)) {
            return false;
        }
        if (!this.uuid.equals(that.uuid)) {
            return false;
        }
        if (!this.apkFileSize.equals(that.apkFileSize)) {
            return false;
        }
        if (!this.versionNumber.equals(that.versionNumber)) {
            return false;
        }
        if (!this.publishedAt.equals(that.publishedAt)) {
            return false;
        }
        if (!this.likeCount.equals(that.likeCount)) {
            return false;
        }
        if (!this.overview.equals(that.overview)) {
            return false;
        }
        if (!this.rating.equals(that.rating)) {
            return false;
        }
        return this.latestVersion.equals(that.latestVersion);
    }

    public int hashCode() {
        int result = this.title.hashCode();
        result = 31 * result + this.description.hashCode();
        result = 31 * result + this.mainImageFullUrl.hashCode();
        result = 31 * result + this.uuid.hashCode();
        return result;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeString(this.title);
        parcel.writeString(this.description);
        parcel.writeString(this.mainImageFullUrl);
        parcel.writeString(this.uuid);
        parcel.writeLong(this.apkFileSize.longValue());
        parcel.writeString(this.versionNumber);
        parcel.writeString(this.publishedAt);
        parcel.writeStringList(this.imageUrls);
        parcel.writeLong(this.likeCount.longValue());
        parcel.writeString(this.overview);
        parcel.writeString(this.rating);
        parcel.writeString(this.latestVersion);
    }

    public void readFromJSON(JSONObject object) throws JSONException {
        this.title = object.optString("title");
        this.description = object.optString("description");
        this.mainImageFullUrl = object.optString("mainImageFullUrl");
        this.uuid = object.optString("uuid");
        this.apkFileSize = object.optLong("apkFileSize");
        this.versionNumber = object.optString("versionNumber");
        this.publishedAt = object.optString("publishedAt");
        this.rating = object.optString("contentRating");
        this.latestVersion = object.optString("latestVersion");
        this.imageUrls = new ArrayList<String>();
        JSONArray a = object.optJSONArray("filepickerScreenshots");
        if (a == null || a.length() == 0) {
            a = object.optJSONArray("screenshots");
        }
        if (a != null) {
            for (int i = 0; i < a.length(); ++i) {
                this.imageUrls.add(a.getString(i));
            }
        }
        this.likeCount = object.optLong("likeCount");
        this.overview = object.optString("overview");
    }
}

