
.equ	screen1	$1800
.equ	screen2	$1b00



.org	$1f00
screen:	.ds	4


.orgfill 0x2100
.db	"MN"

.orgfill 0x2102
	jmp	start
.orgfill 0x2108
	jmp	uirq
.orgfill 0x210E
	jmp	uirq
.orgfill 0x2114
	jmp	uirq
.orgfill 0x211A
	jmp	uirq
.orgfill 0x2120
	jmp	uirq
.orgfill 0x2126
	jmp	uirq
.orgfill 0x212C
	jmp	uirq
.orgfill 0x2132
	jmp	uirq
.orgfill 0x2138
	jmp	uirq
.orgfill 0x213E
	jmp	uirq
.orgfill 0x2144
	jmp	uirq
.orgfill 0x214A
	jmp	uirq
.orgfill 0x2150
	jmp	uirq
.orgfill 0x2156
	jmp	uirq
.orgfill 0x215C
	jmp	uirq
.orgfill 0x2162
	jmp	uirq
.orgfill 0x2168
	jmp	uirq
.orgfill 0x216E
	jmp	uirq
.orgfill 0x2174
	jmp	uirq
.orgfill 0x217A
	jmp	uirq
.orgfill 0x2180
	jmp	uirq
.orgfill 0x2186
	jmp	uirq
.orgfill 0x218C
	jmp	uirq
.orgfill 0x2192
	jmp	uirq
.orgfill 0x2198
	jmp	uirq
.orgfill 0x219E
	jmp	uirq
    

.orgfill 0x21A4 
.db	"NINTENDO"
.db	"P0P!"
.db	"INDESTRUCTBL"
.orgfill 0x21Bc
.db	"2P"              


.orgfill 0x21D0
uirq:	reti				# unhandled interrupt






start:	mov	sp,$2000
	movw	nn,$2000


	movb	[nn+$80],8+2		# set tiled mode 12x8, non-inverted
	movb	[nn+$81],9		# enable video (fast)
	call	vidlin			# mode linear

	mov	x1,screen1
	mov	[screen],x1
	mov	x1,screen2
	mov	[screen+2],x1


cycle:	mov	x2,indexes	
anim:	mov	x1,[x2]
	mov	a,[x2+2]
	cmpb	a,$ff
	jz	cycle
	movx	x1,a
	addw	x2,3

	push	x2

	call	vsync

	mov	x2,[screen]
	mov	hl,[screen+2]
	mov	[$2082],hl
	mov	[screen],hl
	mov	[screen+2],x2

	call	unmip

	mov	x2,$2000		# slow it down
sl2:	dec	x2
	jnz	sl2

	pop	x2

	test	[nn+$52],$80		# Power key
	jnz	anim

	cint	$24			# bye bye




#unmip routine - accepts x1=source address,x2=destination address

unmip:	movb	a,[x1]			# =flag byte
	mov	hl,$300
	
mip_l1:	inc	x1
	movb	b,[x1]
	cmp	a,b			# found flag ?
	jz	mip_j1
	
	movb	[x2],b
	inc	x2
	dec	hl			# end reached ?
	jnz	mip_l1
mipend:	ret
	
mip_j1:	inc	x1
	movb	b,[x1]
	incb	b
	inc	x1
mip_l2:	movb	[x2],[x1]
	inc	x2
	movb	[x2],[x1+1]
	inc	x2
	dec	hl
	dec	hl
	jdbnz	mip_l2

	cmp	hl,0
	jz	mipend
	inc	x1
	jmp	mip_l1
	


vsync:	test	[nn+$8A],$10
	jnz	vsync
vsync2:	test	[nn+$8A],$10
	jz	vsync2
	ret

  

vidlin:	mov	x2,$1360
	mov	l,0
vidini:	mov	a,l
	mov	[x2+l],a
	inc	l    
	cmp	l,$60
	jnz	vidini
	ret


indexes:
.incbin indexs.mip
.orgfill 0x4000
.incbin images.mip

