;-----------------------------------------------------------------------------
; hello.s
; Hello world example for Pokemon Mini
; Made by Rafael Vuijk (aka DarkFader)
; http://darkfader.net/pm/
;-----------------------------------------------------------------------------

;-----------------------------------------------------------------------------
; BIOS
;-----------------------------------------------------------------------------

	.org		0
	.incbin		../bios.min		; don't need this for real PM

;-----------------------------------------------------------------------------
; Memory addresses
;-----------------------------------------------------------------------------

	.equ		tilemap			$1360	; default location for tilemap?

	.equ		BIOS_SIZE		$1000
	.equ		RAM_SIZE		$1000
	.equ		IO_SIZE			$0100
	.equ		ROM_SIZE		$80000

	.reloc
BIOS_BEGIN:		.ds		BIOS_SIZE
BIOS_END:
RAM_BEGIN:		.ds		RAM_SIZE
RAM_END:
IO_BEGIN:		.ds		IO_SIZE
IO_END:
USER_BEGIN:
	.endreloc

	.equ		NN				IO_BEGIN		; you can use [NN+...] instead of [nn+...] when required

;-----------------------------------------------------------------------------
; I/O address offsets
;-----------------------------------------------------------------------------

	.equ		BUTTONS			$52


	.equ		VIDEO_0			$80
	.equ		VIDEO_1			$81
	.equ		VIDEO_TILEDATA	$82		; word

	.equ		COUNTER2		$08

	.equ		CPU0			$00
	.equ		CPU2			$02

;-----------------------------------------------------------------------------
; I/O bits
;-----------------------------------------------------------------------------

	.equ		BUTTON_A		$01
	.equ		BUTTON_B		$02
	.equ		BUTTON_C		$04
	.equ		BUTTON_UP		$08
	.equ		BUTTON_DOWN		$10
	.equ		BUTTON_LEFT		$20
	.equ		BUTTON_RIGHT	$40
	.equ		BUTTON_POWER	$80

	.equ		CPU2_SPEED		$08

	.equ		COUNTER2_START	$01
	.equ		COUNTER2_RESET	$02
	
	.equ		VIDEO_0_INVERT	$01
	.equ		VIDEO_0_TILED	$02
	.equ		VIDEO_0_ENABLE0	$08
	.equ		VIDEO_0_TSIZE0	$10
	.equ		VIDEO_0_TSIZE1	$20

	.equ		VIDEO_1_ENABLE1	$01
	.equ		VIDEO_1_SLOW0	$02
	.equ		VIDEO_1_SLOW1	$04

;-----------------------------------------------------------------------------
; Interrupt numbers
;-----------------------------------------------------------------------------

	.equ	IntSuspend		0x21
	.equ	IntShutdown		0x24

;-----------------------------------------------------------------------------
; Header
;-----------------------------------------------------------------------------

	.org 0x2100
	.db		"MN"			; cam be anything except 0xBF,0xD9
	jmp		start

	.org 0x2108
	; interrupt handlers come here


	.org	0x21A4
	.db		"NINTENDO"		; magic string
	.db		"__________"	; name
	.db		"____"			; 4-character gamecode
	.db		"__"			; ?

;-----------------------------------------------------------------------------
; Start
;-----------------------------------------------------------------------------

start:
	call	Init

	; set tile data address
	mov		x1, font8x8
	movw	[NN+VIDEO_TILEDATA], x1

MainLoop:

	mov		x1, HelloWorld1
	call	CopyTileMap

	call	Delay

	mov		x1, HelloWorld2
	call	CopyTileMap

	call	Delay

	jmp		MainLoop

;-----------------------------------------------------------------------------
; Delay
;-----------------------------------------------------------------------------

Delay:
	push	x1
	mov		x1, 0
_loop:

	test	[nn+BUTTONS], BUTTON_POWER
	jnz		_dont_suspend
	int		IntSuspend
_dont_suspend:

	dec		x1
	jnz		_loop
	pop		x1
	ret

;-----------------------------------------------------------------------------
; Init
; init display to tilemode
;-----------------------------------------------------------------------------

Init:
	movw	nn, IO_BEGIN

	movb	[nn+VIDEO_0], $02+$08	# set tiled mode 12x8, non-inverted
	movb	[nn+VIDEO_1], $01+$08	# enable video

	ret

;-----------------------------------------------------------------------------
; CopyTileMap
; show tilemap @ x1
;-----------------------------------------------------------------------------

CopyTileMap:
	mov		x2, tilemap
	mov		l, 0			; index from -128 to 127 !
	mov		b, 12*8
_loop:
	mov		a, [x1+l]
	mov		[x2+l], a
	inc		l
	jdbnz	_loop
	ret

;-----------------------------------------------------------------------------
; Data
;-----------------------------------------------------------------------------

HelloWorld1:
	.db		"Hello world!"
	.db		"!Hello world"
	.db		"d!Hello worl"
	.db		"ld!Hello wor"
	.db		"rld!Hello wo"
	.db		"orld!Hello w"
	.db		"world!Hello "
	.db		" world!Hello"

HelloWorld2:
	.db		"           d"
	.db		"          l "
	.db		"         r  "
	.db		"    o   o   "
	.db		"   l   W    "
	.db		"  l         "
	.db		" e          "
	.db		"H           "

	.align	8
font8x8:
	.incbin font8x8.bin

;-----------------------------------------------------------------------------
; End
;-----------------------------------------------------------------------------

	.end
