;-----------------------------------------------------------------------------
; Game of Life for Pokemon Mini
; by Rafael Vuijk (aka DarkFader)
;-----------------------------------------------------------------------------

	.include pm.s

	.org	0
bios:
	.incbin bios.min

;-----------------------------------------------------------------------------

.org 0x1000

source:			.ds	0x300

.org 0x1300

destination:	.ds	0x300
currentlife:	.ds 2

;-----------------------------------------------------------------------------

.org 0x2100
	.db "MN"

.org 0x2102
    jmp start
.org 0x2108
    reti
.org 0x210E
    reti
.org 0x2114
    reti
.org 0x211A
    reti
.org 0x2120
    reti
.org 0x2126
    reti
.org 0x212C
    reti

.org 0x2132
    reti
.org 0x2138
    reti
.org 0x213E
    reti
.org 0x2144
    reti
.org 0x214A
    reti
.org 0x2150
    reti
.org 0x2156
    reti
.org 0x215C
    reti

.org 0x2162
    reti
.org 0x2168
    reti
.org 0x216E
    reti
.org 0x2174
    reti
.org 0x217A
    reti
.org 0x2180
    reti
.org 0x2186
    reti
.org 0x218C
    reti

.org 0x2192
    reti
.org 0x2198
    reti
.org 0x219E
    reti

;-----------------------------------------------------------------------------

	.org	0x21A4
	.db	"NINTENDO"
	.db	"__________"
	.db	"____"
	.db	"2P"
	.org	0x21D0

;-----------------------------------------------------------------------------

start:
	mov		sp, RAM_END
	call	Init

	mov		hl, life00
	mov		x1, currentlife
	movw	[x1], hl

SelectLife:

	mov		x2, currentlife
	movw	x1, [x2]
    mov		x2, source
    call	CopyScreen

	test	[nn+BUTTONS], BUTTON_RIGHT
	jnz		_notleft
	mov		x1, currentlife
	movw	x2, [x1]
	cmp		x2, lastlife
	jz		waitup
	add		x2, 0x300
	movw	[x1], x2
	jmp		waitup
_notleft:

	test	[nn+BUTTONS], BUTTON_LEFT
	jnz		_notright
	mov		x1, currentlife
	movw	x2, [x1]
	cmp		x2, life00
	jz		waitup
	sub		x2, 0x300
	movw	[x1], x2
	jmp		waitup
_notright:

	test	[nn+BUTTONS], BUTTON_POWER
	jnz		_notpower
	;int		$21			; standby
	int		$24			; shutdown
_notpower:

	test	[nn+BUTTONS], BUTTON_A
	jnz		SelectLife

;-----------------------------------------------------------------------------

	; destination pixels might remain the same
	mov		x1, source
	mov		x2, destination
	call	CopyScreen

RunLife:

	mov		hl, source
	call	Life

	call	CopyBackToSource

	test	[nn+BUTTONS], BUTTON_B
	jz		waitup

	test	[nn+BUTTONS], BUTTON_POWER
	jnz		_notpower
	int		$21			; standby
	;int		$24			; shutdown
_notpower:

	jmp		RunLife

;-----------------------------------------------------------------------------

waitup:
	mov		[nn+$FE], $A7
	mov		a, [nn+BUTTONS]
	cmp		a, 0xFF
	jnz		waitup
	mov		[nn+$FE], $A6
	jmp		SelectLife

;-----------------------------------------------------------------------------

CopyBackToSource:
	mov		x1, destination
	mov		x2, source
CopyScreen:
	add		x1, 0x80
	add		x2, 0x80
	mov		l, -0x80
	mov		b, 0
	call	_loop
	call	_loop
	call	_loop
	ret

_loop:
	mov		a, [x1+l]
	mov		[x2+l], a
	inc		l
	jdbnz	_loop
	add		x1, 0x100
	add		x2, 0x100
	ret

;-----------------------------------------------------------------------------

Delay:
	push	x1
	mov		x1, 10
_loop:
	dec		x1
	jnz		_loop
	pop		x1
	ret

;-----------------------------------------------------------------------------

	.include	generated.s

;-----------------------------------------------------------------------------

Init:
	movx	hl, 0
	movw	nn, IO_BEGIN

	movb	[nn+VIDEO_0], VIDEO_0_ENABLE0

	ret

;-----------------------------------------------------------------------------

.align	8
life00: .incbin life00.bin
life01: .incbin life01.bin
life02: .incbin life02.bin
life03: .incbin life03.bin
life04: .incbin life04.bin
life05: .incbin life05.bin
life06: .incbin life06.bin
life07: .incbin life07.bin
life08: .incbin life08.bin
life09: .incbin life09.bin
life10: .incbin life10.bin
life11: .incbin life11.bin
life12: .incbin life12.bin
life13: .incbin life13.bin
life14: .incbin life14.bin

.equ	lastlife	life14
