/*
 * generate.cpp
 */

/*
 * Includes
 */
#include <math.h>
#include <string.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>

//int mx,my,mb;

//unsigned char pm_tilemap[12*8];

FILE *generate;
//int count;			// a register


#define	TX		12
#define TY		8

int offset;


struct Code
{
	char *prefix;
	char *buffers[1000];
	char buffer[1000];

	void fprintf(const char *fmt, ...)
	{
		char s[1024];
		va_list marker;
		va_start(marker, fmt);
		int r = vsprintf(s, fmt, marker);
		va_end(marker);
		strcat(buffer, s);
	}
	
	Code(char *prefix)
	{
		this->prefix = strdup(prefix);
		memset(buffers, 0, sizeof(buffers));
	}
	
	~Code()
	{
		for (int i=0; buffers[i]; i++)
		{
			free(buffers[i]);
		}
		free(prefix);
	}

	void begin()
	{
		strcpy(buffer, "");
	}
	
	int end(Code *code = 0)
	{
		bool found = false;
		int i;
		for (i=0; buffers[i]; i++)
		{
			if (!strcmp(buffer, buffers[i])) { found = true; break; }
		}
		if (!found) buffers[i] = strdup(buffer);

		if (code)
			code->fprintf("	call	%s_%d\n", prefix, i);
		else
			::fprintf(generate, "	call	%s_%d\n", prefix, i);
		return i;
	}
	
	void write(FILE *f)
	{
		for (int i=0; buffers[i]; i++)
		{
			::fprintf(f, "%s_%d:\n", prefix, i);
			fputs(buffers[i], f);
			::fprintf(f, "	ret\n", i);
		}
	}
};

/*
 *
 */
void code_SetOffset(Code *code, int newoffset)
{
	if (newoffset == offset)
	{
	}
	else if (newoffset == offset + 1)
	{
		code->fprintf("	incw	hl\n");
	}
	else if (newoffset == offset - 1)
	{
		code->fprintf("	decw	hl\n");
	}
	else
	{
		code->fprintf("	addw	hl,%d\n", newoffset - offset);
	}
	offset = newoffset;
}

/*
 *
 */
int Offset(int tx, int ty, int mx)
{
	return ((ty)*12 + (tx))*8 + (mx);
}

/*
 *
 */
void LookupFlags(Code *code1, Code *code2, int tx, int ty, int mx, int my)
{
	if (mx < 0) { mx += 8; tx -= 1; }
	if (mx >= 8) { mx -= 8; tx += 1; }
	if (tx < 0) { tx += TX; }
	if (tx >= TX) { tx -= TX; }
	if (my < 0) { my += 8; ty -= 1; }
	if (my >= 8) { my -= 8; ty += 1; }
	if (ty < 0) { ty += TY; }
	if (ty >= TY) { ty -= TY; }

	/*code2->begin();
	code_SetOffset(code2, Offset(tx,ty,mx));
	code2->fprintf("	test	[hl], $%02X\n", 1<<my);
	code2->fprintf("	jz		ret\n");
	code2->fprintf("	inc		a\n");
	int i = code2->end(code1);*/

	code_SetOffset(code1, Offset(tx,ty,mx));
	code1->fprintf("	test	[hl], $%02X\n", 1<<my);
	code1->fprintf("	jzb		_nope%d%d\n", mx, my);
	code1->fprintf("	inc		b\n");
	code1->fprintf("_nope%d%d:\n", mx, my);
}

/*
 *
 */
void GenerateLife()
{
	generate = fopen("generated.s", "wt");

	Code *code1 = new Code("code1");
	Code *code2 = new Code("code2");
	Code *code3 = new Code("code3");

	fprintf(generate, "Life:\n");
	fprintf(generate, "	mov		b, 0\n");

	offset = 0;

    for (unsigned int ty=0; ty<8; ty++)
    {
    	for (unsigned int my=0; my<8; my++)
    	{
		    for (unsigned int tx=0; tx<12; tx++)
		    {
		    	for (unsigned int mx=0; mx<8; mx++)
		    	{
					code1->begin();

		    		//code_SetOffset(code1, Offset(tx,ty,mx));

#define LF(ix,iy)	LookupFlags(code1, code2, tx,ty,mx+ix,my+iy)

					LF(-1,-1);
					LF(-1, 0);
					LF(-1,+1);

					LF( 0,-1);
					LF( 0,+1);

					LF(+1,-1);
					LF(+1, 0);
					LF(+1,+1);

		    		code_SetOffset(code1, Offset(tx,ty,mx) + 0x300);		// destination

					code3->begin();
		    		code3->fprintf(
						"	cmpb	b, 3\n"	// birth
						"	jzb		_set\n"
						"	cmpb	b, 2\n"	// survival
						"	jzb		_ret\n"
						"	andb	[hl], $%02X\n"
						"	mov		b,0\n"
						"	ret\n"
						"_set:\n"
						"	orb		[hl], $%02X\n"
						"_ret:\n"
						"	mov		b,0\n",
						(unsigned char)~(1<<my), 1<<my
					);
					int j = code3->end(code1);

					int i = code1->end();
	   			}
    		}
    	}
    }

	fprintf(generate, "ret:	ret\n");
	fprintf(generate, "	ret\n");

	code1->write(generate);
	code2->write(generate);
	code3->write(generate);

	fclose(generate);
    generate = 0;
}

/*
 *
 */
int main(int argc, char *argv[])
{
	GenerateLife();

	return 0;
}
