#############################
# G A L A C T I X ## Lupin ##
#############################
# This is the very long and #
# very slopy source code :) #
#############################

.include	"pmio.asm" #IO defines
.orgfill 0x1460
#RAM

tiles:
.ds 8*5

#tune data (music)
tune:
.dw			0 ##pointer to current tune
csp:
.db			0

#effect data (sound effect)
effect:
.dw			0
effect_end:
.dw			0
effect_csp:
.db			0


#flags if cheats are activated :)
cheats:
.db	0

.equ	CHEAT_AUTOFIRE	1<<0
.equ	CHEAT_GODMODE	1<<1
.equ	CHEAT_BOMBGOD	1<<2
.equ	CHEAT_FASTBOMB	1<<3

cheatreset:
.db	0

cheatshift:
.db	0

cheatcode:
.db	0

.equ	CODE_UP			0
.equ	CODE_DOWN		1
.equ	CODE_LEFT		2
.equ	CODE_RIGHT		3

.equ	CODE_AUTOFIRE	((CODE_RIGHT<<6) | (CODE_LEFT<<4) | (CODE_DOWN<<2) | CODE_UP)
.equ	CODE_GODMODE	((CODE_LEFT<<6) | (CODE_UP<<4) | (CODE_RIGHT<<2) | CODE_DOWN)
.equ	CODE_BOMBGOD	((CODE_RIGHT<<6) | (CODE_DOWN<<4) | (CODE_UP<<2) | CODE_LEFT)
.equ	CODE_FASTBOMB	((CODE_LEFT<<6) | (CODE_RIGHT<<4) | (CODE_UP<<2) | CODE_DOWN)


#counter for "shock"
nshock:
.db	0

rumble:
.db	0

invert:
.db	0

invert2:
.db	0

fctr:
.db	0

ffctr:
.db	0

scrl:
.db	0

scrr:
.db	0

shipx:
.db	0

scrolly:
.dw	0

score:
.dw	0

curlvl:
.db	0

temp1:
.db 0

vblank:
.dw	0

keyregold:
.db	0

pmovepath:
.dw 0

shootdelay:
.dw	0

lvlend:
.db 123,0,0,0,0,0,0,0,0,0,0,0
.db 123,0,0,0,0,0,0,0,0,0,0,0
.db 123,0,0,0,0,0,0,0,0,0,0,0
.db 123,0,0,0,0,0,0,0,0,0,0,0
.db 123,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0
level:
.ds	12*64
level_end:

rndseed:
.db	0



.orgfill 0x2100
.db "MN" #ROM ID

### interrupt vector table
#INT #0
.orgfill 0x2102   #GAME START
    jmp start
#INT #1    
.orgfill 0x2108   #V-BLANK
	push	HL
	mov		HL, [vblank]
    jmp 	HL
#INT #2
.orgfill 0x210E   #V-DRAW
    jmp unhandled_interrupt
#INT #3
.orgfill 0x2114   #TIMER 2 OVERFLOW
    jmp dosound
#INT #4
.orgfill 0x211A   # 
    jmp unhandled_interrupt
#INT #5
.orgfill 0x2120   #TIMER 1 OVERFLOW
    jmp unhandled_interrupt
#INT #6
.orgfill 0x2126   # 
    jmp unhandled_interrupt
#INT #7
.orgfill 0x212C   #TIMER 3 OVERFLOW
    jmp unhandled_interrupt
#INT #8
.orgfill 0x2132   #TIMER 3 OVERFLOW
    jmp unhandled_interrupt
#INT #9
.orgfill 0x2138   # 
    jmp unhandled_interrupt
#INT #10
.orgfill 0x213E   # 
    jmp unhandled_interrupt
#INT #11
.orgfill 0x2144   # 
    jmp unhandled_interrupt
#INT #12
.orgfill 0x214A   # 
    jmp unhandled_interrupt
#INT #13
.orgfill 0x2150   #IR RECEIVE LOW TO HIGH
    jmp unhandled_interrupt
#INT #14
.orgfill 0x2156   #SHOCK DETECTOR
    jmp do_shock
#INT #15
.orgfill 0x215C   #KEY PRESS: POWER BUTTON
    jmp int_power_key
#INT #16
.orgfill 0x2162   #KEY PRESS: D-PAD RIGHT
    jmp pad_right
#INT #17
.orgfill 0x2168   #KEY PRESS: D-PAD LEFT
    jmp pad_left
#INT #18
.orgfill 0x216E   #KEY PRESS: D-PAD DOWN
    jmp pad_down
#INT #19
.orgfill 0x2174   #KEY PRESS: D-PAD UP
    jmp pad_up
#INT #20
.orgfill 0x217A   #KEY PRESS: C KEY
    jmp fastbomb
#INT #21
.orgfill 0x2180   #KEY PRESS: B KEY
    jmp unhandled_interrupt
#INT #22
.orgfill 0x2186   #KEY PRESS: A KEY
    jmp	unhandled_interrupt
#INT #23
.orgfill 0x218C   # 
    jmp unhandled_interrupt
#INT #24
.orgfill 0x2192   # 
    jmp unhandled_interrupt
#INT #25
.orgfill 0x2198   # 
    jmp unhandled_interrupt
    
.orgfill 0x219E   
.orgfill 0x21A4 
.db "NINTENDO"         # magic signature checked by the BIOS
.db "PoKe"             # game code - 4 byte
.db "GALACTIX PM "     # name of rom, 12 chars max
.orgfill 0x21Bc
.db "2P"

# end of rom header, start of program code
.orgfill 0x21D0

unhandled_interrupt:
    reti   #reti - return from interrupt
    
    
####   ###   ###   ###   ####
# SOUND EFFECT HANDLER      #
####   ###   ###   ###   ####
dosound:
	push	n
	push	x1
	push	BA
	pushxxx
	
	
	movw	nn, REG_BASE
	movx	x1, 1  #sound page	
	
	# do rumble!
	
	mov		a, [rumble]
	cmp		a, 0
	jz		_norumble
	dec		a
	mov		[rumble], a
	mov		[nn+$61],$10
	jmp		_dorumble
_norumble:
	mov		[nn+$61],$0
_dorumble:
		
	
	# increment wait-variables and pointers for music and effect
	movw	x1, [tune]
	movb	a, [x1]
	shl		a
	shl		a
	
	movb	b, [csp]
	cmp		a, b #check if matches with first byte
	jnc		songwait
	
	#increment music pointer
	add		x1, 5
	movw	[tune], x1
	#reset csp
	mov		a, 0
	mov		[csp], a

	#check if music has ended
	cmp		x1, music_e
	jnz		noreset1
	#repeat tune
	movw	x1, music
	movw	[tune], x1
noreset1:

	jmp		music_done


songwait:
	inc		b
	movb	[csp], b
music_done:
	
	
	
	
	#increment effect variables
	movw	x1, [effect]
	cmp		x1, 0xffff   #0xffff means that there is no effect played
	jz		noeffect
	movb	a, [x1]
	
	movb	b, [effect_csp]
	cmp		a, b
	jnc		effectwait
	
	#increment effect pointer
	add		x1, 5
	movw	[effect], x1
	#reset csp
	mov		a, 0
	mov		[effect_csp], a


	#check if effect has ended
	mov		BA, [effect_end]
	cmp		BA, x1
	jnz		noreset2
	#stop playing
	movw	x1, 0xffff
	movw	[effect], x1
noreset2:

	jmp		noeffect

	
effectwait:
	inc		b
	movb	[effect_csp], b
noeffect:


	cmp		x1, 0xffff
	jz		playmusic
	#effect is played	
	
	inc		x1
	jmp		loadnote
	
playmusic:
	#no effect is played - play music instead
	mov		x1, [tune]
	inc		x1


loadnote:
	movw	BA, [x1]
	movw	[REG_BASE+REG_TIMER3_PRESET], BA
	add		x1, 2
	
	movw	BA, [x1]
	movw	[REG_BASE+REG_TIMER3_PIVOT], BA





	movb	[nn+REG_INT_FLAG1], IF_TIMER2OVERFLOW
	
	popxxx
	pop		BA
	pop		x1
	pop		n


	reti


########################
# power button handler #
########################
int_power_key:
    movb	[nn+REG_INT_FLAG2],IF_KEY_POWER
    test	[nn+REG_KEYPAD],KEY_POWER
    jnz		noturnoff
    cint	$24
noturnoff:
    reti


pad_up:
	push	BA
	movb	a, CODE_UP
	movb	[nn+REG_INT_FLAG2],IF_KEY_UP
	jmp		docheatcode
pad_down:
	push	BA
	movb	a, CODE_DOWN
	movb	[nn+REG_INT_FLAG2],IF_KEY_DOWN
	jmp		docheatcode
pad_left:
	push	BA
	movb	a, CODE_LEFT
	movb	[nn+REG_INT_FLAG2],IF_KEY_LEFT
	jmp		docheatcode
pad_right:
	push	BA
	movb	a, CODE_RIGHT
	movb	[nn+REG_INT_FLAG2],IF_KEY_RIGHT
	

docheatcode:
	
	movb	b, 0
    movb	b, [cheatreset]
    
    movb	b, [cheatshift]
    
    cmp		b, 0
    jz		_nonshifted
_shiftme:
    
    shl		a
    
    jdbnz	_shiftme
_nonshifted:
	
	movb	b, [cheatcode]
	orb		a, b
	movb	[cheatcode], a    


	movb	a, [cheatshift]
	add		a, 2
	cmp		a, 10
	jnz		_nooverflow
	movb	a, 0
	movb	[cheatcode], a
_nooverflow:
	movb	[cheatshift], a
    
    pop		BA
    reti



###########################
# shock interrupt handler #
###########################
do_shock:
	push	x1
	push	BA
	push	n
	
	mov		nn, REG_BASE
	movb	[nn+REG_INT_FLAG3],IF_SHOCK

	#check if we still have bombs
	mov		nn, OAM 
	movb	a, [OAM+6]
	andb	a, 127
    cmpb	a, 1      #if 1 then no more bombs!
    jz		_nobomb


	mov		a, [nshock]
	inc		a
	mov		[nshock], a
	cmp		a, 13
	jnz		_nobomb

	#reset nshock first
	mov		a, 64
	mov		[nshock], a
	    
	movb	a, [cheats]
	test	a, CHEAT_BOMBGOD
	jnz		_stillbomb
	    
	movb	a, [nn+6]
    inc		a
    movb	[nn+6], a 
    andb	a, 127
	cmp		a, 33
	jnz		_stillbomb
	movb	[nn+6], 1
_stillbomb:
	
	
	
	movb	a, 32
	movb	[rumble], a
	movb	a, 20
	movb	[invert], a
	
	call	ignite_bomb	
	call	remove_lasers

	
_nobomb:

	pop		n
	pop		BA
	pop		x1
	reti



fastbomb:
	push	x1
	push	n
	
	mov		nn, REG_BASE
	movb	[nn+REG_INT_FLAG2],IF_KEY_C


	movb	a, 32
	movb	[rumble], a
	movb	a, 20
	movb	[invert], a
	
	call	ignite_bomb	
	call	remove_lasers


	pop		n
	pop		x1
	reti

#####################################
# FINISH SCREEN VBLANK IRQ FUNCTION #
#####################################
vblfinish:
	mov		nn, REG_BASE
    movb	[nn+REG_INT_FLAG1],IF_VBLANK

	mov		a, [fctr]
	inc		a
	mov		[fctr], a
	test	a, 1
	jnz		_fs1

    mov		x1, finish2
    jmp		_fs2
_fs1:
    mov		x1, finish1
_fs2:

	mov		[REG_BASE+REG_LCD_TILEBGMEM], x1

	test	[nn+REG_KEYPAD],KEY_A
	jnz		_nomenu
 	mov		a, [keyregold]
 	test	a, KEY_A
 	jz		_nomenu
 	
	call	init_titlescreen
    mov		x1, titlescreen
    mov		[vblank], x1
    
    jmp		_nomenu
_nomenu:


	mov		a, [nn+REG_KEYPAD]
	mov		[keyregold], a

	pop		HL
    reti

########################################
# GAME OVER SCREEN VBLANK IRQ FUNCTION #
########################################
gameover:
	mov		nn, REG_BASE
    movb	[nn+REG_INT_FLAG1],IF_VBLANK

	mov		a, [fctr]
	inc		a
	mov		[fctr], a
	test	a, 1
	jnz		_fs1

    mov		x1, goscreen2
    jmp		_fs2
_fs1:
    mov		x1, goscreen1
_fs2:

	mov		[REG_BASE+REG_LCD_TILEBGMEM], x1

	test	[nn+REG_KEYPAD],KEY_A
	jnz		_nogame
 	mov		a, [keyregold]
 	test	a, KEY_A
 	jz		_nogame
 	
    call	initgame
    call	newgame
    
    mov		x1, game
    mov		[vblank], x1
    jmp		_nomenu
_nogame:

    test	[nn+REG_KEYPAD],KEY_B
    jnz		_nomenu
    call	init_titlescreen
    mov		x1, titlescreen
    mov		[vblank], x1
_nomenu:

	mov		a, [nn+REG_KEYPAD]
	mov		[keyregold], a

	pop		HL
    reti

####################################
# TITLE SCREEN VBLANK IRQ FUNCTION #
####################################
titlescreen:
    movb	[nn+REG_INT_FLAG1],IF_VBLANK
   
   	# do invert (for cheats)
	mov		a, [invert]
	cmp		a, 0
	jz		_noinvert
	dec		a
	mov		[invert], a
	orb		[nn+REG_LCD_CNT0],LCD0_INVERT
	call	invert_sprites
	jmp		_doinvert
_noinvert:
	andb	[nn+REG_LCD_CNT0],~LCD0_INVERT
	call	ninvert_sprites
_doinvert:

    
    
    movb	a, [cheatcode]
    
    #check for AUTOFIRE
    cmpb	a, CODE_AUTOFIRE
    jnz		_nocheat1
    
    movb	b, CHEAT_AUTOFIRE
    jmp		_gotcheat
_nocheat1:    

	#check for GODMODE
    cmpb	a, CODE_GODMODE
    jnz		_nocheat2
    
    movb	b, CHEAT_GODMODE
    jmp		_gotcheat
_nocheat2:

	#cheack for BOMBGOD
    cmpb	a, CODE_BOMBGOD
    jnz		_nocheat3
    
    movb	b, CHEAT_BOMBGOD
    jmp		_gotcheat
_nocheat3:

	#cheack for BOMBGOD
    cmpb	a, CODE_FASTBOMB
    jnz		_nocheat4
    
    movb	b, CHEAT_FASTBOMB
    jmp		_gotcheat
_nocheat4:


	jmp		_nocheat

_gotcheat:
    movb	a, [cheats]
    orb		a, b
    movb	[cheats], a
	movb	a, 0
    movb	[cheatcode], a
    movb	[cheatshift], a
    movb	a, 40
    movb	[invert], a
_nocheat:



	movb	a, [OAM+34]
    add		a, 128
    movb	[OAM+34], a
    
    movb	a, [OAM+38]
    add		a, 128
    movb	[OAM+38], a
    
    movb	a, [OAM+42]
    add		a, 128
    movb	[OAM+42], a
	
	mov		nn, OAM
	
	mov		b, 0
	mov		a, [fctr]
	and 	a, 0x7F
	mov		x1, titlesin
	add		x1, BA


	mov		a, [scrr]
	inc		a
	jnz		_nostop2
	
	
	
    movb	a, [OAM+2]
    add		a, 128
    movb	[OAM+2], a
    
    movb	a, [nn+6]
    add		a, 128
    movb	[nn+6], a
    
    movb	a, [nn+10]
    add		a, 128
    movb	[nn+10], a
    
    
    movb	a, [nn+14]
    add		a, 128
    movb	[nn+14], a
    
    movb	a, [nn+18]
    add		a, 128
    movb	[nn+18], a
    
    movb	a, [nn+22]
    add		a, 128
    movb	[nn+22], a
    
    movb	a, [nn+26]
    add		a, 128
    movb	[nn+26], a
    
    movb	a, [nn+30]
    add		a, 128
    movb	[nn+30], a   
    
	mov		a, 255
	
_nostop2:
	mov		[scrr],a
	add		a, 16+1

	cmp		a, 16
	jnz		_anim

	#new
    movb	[nn+32], 20
    movb	[nn+33], 68
    orb 	[nn+35], OAM_ENABLE

    #game
    movb	[nn+36], 36
    movb	[nn+37], 68
    orb 	[nn+39], OAM_ENABLE

	# A
    movb	[nn+40], 52
    movb	[nn+41], 68
    orb 	[nn+43], OAM_ENABLE
    

_anim:
    
	# G
	movb	[nn+0], a
	movb	[nn+1], [x1]
	cmp	a, 96+16
	jnc	_disable_g
	orb 	[nn+3], OAM_ENABLE
	jmp	_enable_g
_disable_g:
	andb	[nn+3], ~OAM_ENABLE
_enable_g:
	add		x1, 12
	add		a, 12

    # A
    movb	[nn+4], a
    movb	[nn+5], [x1]
	cmp	a, 96+16
	jnc	_disable_a1
	orb 	[nn+7], OAM_ENABLE
	jmp	_enable_a1
_disable_a1:
	andb	[nn+7], ~OAM_ENABLE
_enable_a1:
    add		x1, 12
    add		a, 12

    # L
    movb	[nn+8], a
    movb	[nn+9], [x1]
	cmp	a, 96+16
	jnc	_disable_l
	orb 	[nn+11], OAM_ENABLE
	jmp	_enable_l
_disable_l:
	andb	[nn+11], ~OAM_ENABLE
_enable_l:
    add		x1, 12
    add		a, 12

    # A
    movb	[nn+12], a
    movb	[nn+13], [x1]
	cmp	a, 96+16
	jnc	_disable_a2
	orb 	[nn+15], OAM_ENABLE
	jmp	_enable_a2
_disable_a2:
	andb	[nn+15], ~OAM_ENABLE
_enable_a2:
    add		x1, 12
    add		a, 12

	mov		a, [scrl]
	dec		a
	jnz		_nostop1
	mov		a, 1
_nostop1:
	mov		[scrl],a
	add		a, 16+48-1

    # C
    movb	[nn+16], a
    movb	[nn+17], [x1]
	cmp	a, 96+16
	jnc	_disable_c
	orb 	[nn+19], OAM_ENABLE
	jmp	_enable_c
_disable_c:
	andb	[nn+19], ~OAM_ENABLE
_enable_c:
    add		x1, 12
    add		a, 12

    # T
    movb	[nn+20], a
    movb	[nn+21], [x1]
	cmp	a, 96+16
	jnc	_disable_t
	orb 	[nn+23], OAM_ENABLE
	jmp	_enable_t
_disable_t:
	andb	[nn+23], ~OAM_ENABLE
_enable_t:
	add		x1, 12
	add		a, 12
	
    # I
    movb	[nn+24], a
    movb	[nn+25], [x1]
	cmp	a, 96+16
	jnc	_disable_i
	orb		[nn+27], OAM_ENABLE
	jmp	_enable_i
_disable_i:
	andb	[nn+27], ~OAM_ENABLE
_enable_i:
	add		x1, 12
	add		a, 12
	
	# X
    movb	[nn+28], a
    movb	[nn+29], [x1]
	cmp	a, 96+16
	jnc	_disable_x
	orb 	[nn+31], OAM_ENABLE
	jmp	_enable_x
_disable_x:
	andb	[nn+31], ~OAM_ENABLE
_enable_x:


    

	
	
	mov		nn, REG_BASE
	
	mov		a, [cheatreset]
	inc		a
	mov		[cheatreset], a
	cmp		a, 128
	jnz		_noreset

	movb	a, 0
	mov		[cheatreset], a
    movb	[cheatcode], a
    movb	[cheatshift], a
	
_noreset:

	mov		a, [fctr]
	inc		a
	mov		[fctr], a
	test	a, 1
	jnz		_spl2
    mov		x1, splash1
    mov		x2, sprites1
    jmp		_spl1
_spl2:
    mov		x1, splash2
   # mov		x2, sprites2
_spl1:

	mov		x2, sprites1
	mov		[REG_BASE+REG_LCD_SPRITEMEM], x2
	mov		[REG_BASE+REG_LCD_TILEBGMEM], x1
    
   	test	[nn+REG_KEYPAD],KEY_A
	jnz		_nogame
 	mov		a, [keyregold]
 	test	a, KEY_A
 	jz		_nogame
 	
    call	initgame
	call	newgame

    mov		x1, game
    mov		[vblank], x1
_nogame:

	mov		a, [nn+REG_KEYPAD]
	mov		[keyregold], a

    
    pop		HL
    reti


#################################
# MAIN GAME VBLANK IRQ FUNCTION #
#################################
game:
    movb	[nn+REG_INT_FLAG1],IF_VBLANK

	#decrement shock counter
	movb	a, [nshock]
	cmp		a, 0
	jz		_nodec
	dec		a
	movb	[nshock], a
_nodec:

	# do invert!
	mov		a, [invert]
	cmp		a, 0
	jz		_noinvert
	dec		a
	mov		[invert], a
	andb	[nn+REG_LCD_CNT0],~LCD0_INVERT
	call	invert_sprites
	jmp		_doinvert
_noinvert:
	orb		[nn+REG_LCD_CNT0],LCD0_INVERT
	call	ninvert_sprites
_doinvert:

	# do invert #2

	movb	a, [invert2]
	cmp		a, 0
	jz		_doinvert22
	
	dec		a
	movb	[invert2], a
	
	#dont show player
	andb	b, ~OAM_ENABLE
	movb	[OAM+3], b

	#reset player pos
	mov		b, (48+9)*2
	mov		[shipx], b
    shr		b
    mov		[OAM+0], b
	
	test	a, 8
	jz		_noinvert22
	andb	[nn+REG_LCD_CNT0],~LCD0_INVERT
	call	invert_sprites
	jmp		_invertdone
_noinvert22:
	orb		[nn+REG_LCD_CNT0],LCD0_INVERT
	call	ninvert_sprites
	jmp		_invertdone
_doinvert22:

	#show player again
	movb	a, [OAM+3]
	orb		a, OAM_ENABLE
	movb	[OAM+3], a

_invertdone:


    mov		nn, OAM

###############################
# check if we are still alive #
###############################

	mov		a,[nn+7]
	cmp		a, OAM_DISABLE
	jnz		_not_dead
	call	init_gameover #no more lives
	pop		HL
	reti
_not_dead:

###############################
# check if laser 1 is enabled #
###############################
laser1:
    movb	a, [nn+47]
    cmp		a, OAM_ENABLE
    jnz		_inactive
	

    mov		BA, 0

    #get y value
    movb	a, [nn+45]
    dec		a
    cmp		a, 15
    jnc		_active #if greater than 16 laser is still enabled
    # lower than 16 - disable laser
    movb	a, OAM_DISABLE
    movb	[nn+47], a
    jmp		_inactive
_active:
    #store decremented laser y value
    movb	[nn+45], a

    mov		b, [REG_BASE+REG_BGMOV_V]
    add		a, b
    sub		a, 16
    #y/2 = hheneinheiten
    shr		a
    and         a, 0b11111100

    #(y/2*3) = hheneinheiten * breite
    # = (y/8*12)
    mov		b, a
    add		a, b
    add		a, b
    mov		b, 0


    mov		x1, [scrolly]
    add         x1, BA

    mov		a, [REG_BASE+REG_BGMOV_H]
    sub		a, 16
    mov		b, [nn+44]
    add		a, b
    add		a, 2
    
    shr		a #/2
    shr		a #/4
    shr		a #/8
    mov		b, 0
    add		x1, BA


    mov		a, [x1]
    cmp		a, 1
    jnz		_nocollision

    mov		[x1], 0
    #increment score
    mov		x1, [score]
    add		x1, 5
    mov		[score], x1
    #deactivate laser
    movb	[nn+47], 0
    
    call	playboom
    jmp		_inactive
    
_nocollision:
	cmp		a, 3
	jnz		_nocollision2
	
	mov		[x1], 2
	#deactivate laser
    movb	[nn+47], 0
    
	jmp		_inactive
	
_nocollision2:
	cmp		a, 2
	jnz		_inactive

    mov		[x1], 0
    #increment score
    mov		x1, [score]
    add		x1, 10
    mov		[score], x1
    #deactivate laser
    movb	[nn+47], 0
    
    call	playboom

_inactive:



	
###############################
# check if laser 2 is enabled #
###############################
laser2:
    movb	a, [nn+51]
    cmp		a, OAM_ENABLE
    jnz		_inactive
	
    mov		BA, 0
    
    #load y value of laser
    movb	a, [nn+49]
    dec		a
    cmp		a, 15
    jnc		_active
    movb	a, OAM_DISABLE
    movb	[nn+51], a
    jmp		_inactive
_active:
    #store y value of laser
    movb	[nn+49], a


    mov		b, [REG_BASE+REG_BGMOV_V]
    add		a, b
    sub		a, 16
    #y/2 = hheneinheiten
    shr		a
    and         a, 0b11111100

    #(y/2*3) = hheneinheiten * breite
    # = (y/8*12)
    mov		b, a
    add		a, b
    add		a, b
    mov		b, 0


    mov		x1, [scrolly]
    add         x1, BA

    mov		a, [REG_BASE+REG_BGMOV_H]
    sub		a, 16
    mov		b, [nn+48]
    add		a, b
    add		a, 2
    
    shr		a #/2
    shr		a #/4
    shr		a #/8
    mov		b, 0
    add		x1, BA


	mov		a, [x1]
    cmp		a, 1
    jnz		_nocollision

    mov		[x1], 0
    #increment score
    mov		x1, [score]
    add		x1, 5
    mov		[score], x1
    #deactivate laser
    movb	[nn+51], 0
    
    call	playboom
    jmp		_inactive
    
_nocollision:
	cmp		a, 3
	jnz		_nocollision2
	
	mov		[x1], 2
	#deactivate laser
    movb	[nn+51], 0
    
	jmp		_inactive
	
_nocollision2:
	cmp		a, 2
	jnz		_inactive

    mov		[x1], 0
    #increment score
    mov		x1, [score]
    add		x1, 10
    mov		[score], x1
    #deactivate laser
    movb	[nn+51], 0
    
    call	playboom

_inactive:

###############################
# check if laser 3 is enabled #
###############################
laser3:
    movb	a, [nn+55]
    cmp		a, OAM_ENABLE
    jnz		_inactive
	
    mov		BA, 0

    #load y value, decrement and check
    movb	a, [nn+53]
    dec		a
    cmp		a, 15
    jnc		_active
    movb	a, OAM_DISABLE
    movb	[nn+55], a
    jmp		_inactive
_active:
    #store y value
    movb	[nn+53], a

    mov		b, [REG_BASE+REG_BGMOV_V]
    add		a, b
    sub		a, 16
    #y/2 = hheneinheiten
    shr		a
    and         a, 0b11111100

    #(y/2*3) = hheneinheiten * breite
    # = (y/8*12)
    mov		b, a
    add		a, b
    add		a, b
    mov		b, 0


    mov		x1, [scrolly]
    add         x1, BA

    mov		a, [REG_BASE+REG_BGMOV_H]
    sub		a, 16
    mov		b, [nn+52]
    add		a, b
    add		a, 2
    
    shr		a #/2
    shr		a #/4
    shr		a #/8
    mov		b, 0
    add		x1, BA


	mov		a, [x1]
    cmp		a, 1
    jnz		_nocollision

    mov		[x1], 0
    #increment score
    mov		x1, [score]
    add		x1, 5
    mov		[score], x1
    #deactivate laser
    movb	[nn+55], 0
    
    call	playboom
    jmp		_inactive
    
_nocollision:
	cmp		a, 3
	jnz		_nocollision2
	
	mov		[x1], 2
	#deactivate laser
    movb	[nn+55], 0
    
	jmp		_inactive
	
_nocollision2:
	cmp		a, 2
	jnz		_inactive

    mov		[x1], 0
    #increment score
    mov		x1, [score]
    add		x1, 10
    mov		[score], x1
    #deactivate laser
    movb	[nn+55], 0
    
    call	playboom

_inactive:



###############################################
# enemy lasers movement & collision detection #
###############################################
	
	mov		a, [scrl]
	inc		a
	mov		[scrl],a
	test	a, 1
	jz		nolaserhandling
	
	
	mov		x2, OAM+61 #first laser y value
	mov		b, 10
laser_loop:
	mov		a, [x2+2]
	cmp		a, OAM_ENABLE
	jnz		nopenalty

	#mov		a, [x2+1]
	#add		a, 128
	#mov		[x2+1], a

    # increment y value
	mov		a, [x2]
	inc		a
	mov		[x2], a
	
	cmp		a, (64+16)
	jc		_lower
	
	# deactivate the laser
	add		x2, 2
	mov		[x2], 0
	sub		x2, 2
	
_lower:
	
	push	BA
	push	x2
	
	# check for collision
	mov		h, 0
	
	# push x first
	dec		x2
	mov		l, [x2]
	push	HL
	# then push y
	inc		x2
	mov		l, [x2]
	push	HL
	
	#push ship position
	mov		l, [nn+0] #x
	push	HL
	mov		l, [nn+1] #y
	push	HL
	
	
	call	chkcol
	pop		x2
	pop		BA
	
	jnz		nopenalty
	
	# deactivate the laser
	add		x2, 2
	mov		[x2], 0
	sub		x2, 2
	
	call	playhit
	
	mov		a, [OAM+58]
	and		a,0x7F
	dec		a
	cmp		a, 24
	jnz		_notdeath
	
	call	lostlife #we lost a life! :(
	mov		a, 25+3
	
	
	
_notdeath:
	
	mov		[OAM+58], a
	
nopenalty:
	
	add		x2, 4
	
	jdbnz	laser_loop
   

nolaserhandling:



###################################
# score display                   #
# this could be done with BCD (?) #
###################################
    mov		BA, [score]
	
    mov		l, 0
checkdiv1:
    cmp		BA, 10000
    jl		nosub1
	
    sub		BA, 10000
    inc		l
    jmp		checkdiv1
nosub1:
    add		HL, 4
	mov		[nn+26], l

    mov		l, 0	
checkdiv2:
    cmp		BA, 1000
    jl		nosub2
	
    sub		BA, 1000
    inc		l
    jmp		checkdiv2
nosub2:
    add		HL, 4
    mov		[nn+30], l	
	
	
    mov		l, 0	
checkdiv3:
    cmp		BA, 100
    jl		nosub3
	
    sub		BA, 100
    inc		l
    jmp		checkdiv3
nosub3:
    add		HL, 4
    mov		[nn+34], l
		
		
    mov		l, 0	
checkdiv4:
    cmp		BA, 10
    jl		nosub4
	
    sub		BA, 10
    inc		l
    jmp		checkdiv4
nosub4:
    add		HL, 4
    mov		[nn+38], l
		
		
    add		a, 4
    mov		[nn+42], a
	
    mov		nn, REG_BASE

################
# swap sprites #
################

	#score
	mov		a, [OAM+18]
	add		a, 128
	mov		[OAM+18], a
	
	mov		a, [OAM+22]
	add		a, 128
	mov		[OAM+22], a

	mov		a, [ffctr]
	inc		a
	mov		[ffctr], a
	test	a, 1
	jnz		nonumswp
	
	mov		a, [OAM+26]
	add		a, 128
	mov		[OAM+26], a
	
	mov		a, [OAM+30]
	add		a, 128
	mov		[OAM+30], a

	mov		a, [OAM+34]
	add		a, 128
	mov		[OAM+34], a

	mov		a, [OAM+38]
	add		a, 128
	mov		[OAM+38], a

	mov		a, [OAM+42]
	add		a, 128
	mov		[OAM+42], a
nonumswp:

	mov		a, [OAM+6]
	add		a, 128
	mov		[OAM+6], a

	mov		a, [OAM+10]
	add		a, 128
	mov		[OAM+10], a
	
	mov		a, [OAM+14]
	add		a, 128
	mov		[OAM+14], a
	
	mov		a, [OAM+58]
	add		a, 128
	mov		[OAM+58], a

####################
# KEY CONTROLS     #
####################
	mov		a, [OAM+2]
	add		a, 128
	mov		[OAM+2], a
	

    test	[nn+REG_KEYPAD],KEY_LEFT
    jnz		left_not_pressed
    mov		a, [shipx]
    cmp		a, 32
    jz      left_not_pressed
    dec		a
    mov		[shipx], a
    shr		a
 

    mov		[OAM+0], a
_fliped:

   
left_not_pressed:

    test	[nn+REG_KEYPAD],KEY_RIGHT
    jnz		right_not_pressed
    mov		a, [shipx]
    cmp		a, 200
    jz      right_not_pressed
    inc		a
    mov		[shipx], a
    shr		a
 
    
    mov		[OAM+0], a
_fliped:
  	
    
right_not_pressed:


####################################
# ENEMY<->SHIP COLLISION DETECTION #
####################################

	mov		a, [nn+REG_BGMOV_H]
	sub		a, 16
	mov		b, [OAM+0]
	add		a, b

	shr		a  #/2
	shr		a  #/4
	shr		a  #/8
	mov		b, 0
	
	mov		x1, [scrolly]
	add		x1, BA
	add		x1, 12*6

	#check first block (top left)
	mov		a, [x1]
	cmp		a, 1
	jz		collision

	#check second block (top right)
	mov		a, [x1+1]
	cmp		a, 1
	jz		collision

	#check third block (bottom left)
	mov		a, [x1+12]
	cmp		a, 1
	jz		collision

	#check fourth block (bottom right)
	mov		a, [x1+13]
	cmp		a, 1
	jz		collision

	jmp		nocollision

collision:
	mov		a, 0
	mov		[x1], a
	mov		[x1+1], a
	mov		[x1+12], a
	mov		[x1+13], a
	
	call	lostlife
	mov		a, 25+3
    movb	[OAM+58], a
	call	playhit

nocollision:




	call	player_shoot



####################################
# bg scrolling                     #
####################################
    movw	x1, [scrolly] #used later...

    mov		a, [temp1]
    dec		a
    mov		[temp1], a
    cmp		a, 8
    jz		sinmove
    cmp		a, 0
    jnz		noscroll

	mov		a, [fctr]
	inc		a
	mov		[fctr], a
	

    mov		a, 12  #scroll delay
    mov         [temp1], a


    #scroll vertical (top-down)
    mov		a, [nn+REG_BGMOV_V]
    dec		a
    jnz		_nomapinc       #if 8 pixels scrolled then scroll by 1 row
    mov		a, 8
    sub		x1, 12          #sub 1 row (we scroll up a row)
    movw	[scrolly], x1
_nomapinc:
    mov		[nn+REG_BGMOV_V], a



    #scroll sinus (left-right)
sinmove:        
    mov		x2, [pmovepath] #get pointer to movepath table
    mov		b, [x2]
    inc		x2
    cmp		x2, movepath+24 #compare with end of array
    jnz		noclamp
    mov		x2, movepath    #we reached the end, start from beginning
noclamp:
    mov		a, [x2]         #get current x-move
    cmp		a, b
    jz		has_not_moved
	mov		b, [fctr]
	inc		b
	mov		[fctr], b
has_not_moved:
    mov		[pmovepath],x2
    mov		[REG_BASE+REG_BGMOV_H], a
noscroll:
	
    #load value at first block (top left corner)
    #this block is used to check if level has ended
    mov		a, [x1]
    cmp		a, 123
    jnz		notdead
    ###############################################################
##########################################
    # LEVEL HAS ENDED - DO SOMETHING!!!
###################

	call	initgame

	mov		a, [curlvl]
	inc		a
	mov		[curlvl], a
	
	cmp		a, 1
	jnz		_notlvl2
    mov		x2, level2
    jmp		_loadlvl
_notlvl2:
	cmp		a, 2
	jnz		_notlvl3
    mov		x2, level3
    jmp		_loadlvl
_notlvl3:

	## finished!
	
	call	init_finish
	pop		HL
	reti
	

_loadlvl:
    call	loadlevel
	pop		HL
    reti        #return from interrupt
notdead:
	
	
	
	
	######### do tile fliping & copying
	mov		a, [fctr]
	inc		a
	mov		[fctr], a
	
	test	a, 1	
	jnz		_blah1
	mov		x2, bgtiles1
	jmp		_blah2
_blah1:
	mov		x2, bgtiles2
_blah2:
	mov		x1, tiles


	mov		b, 8*4 #copy void+enemy1+enemy2*2
_copyloop1:
	mov		a, [x2]
	mov		[x1], a
	inc		x1
	inc		x2
	jdbnz	_copyloop1


	#copy star
	mov		a, [REG_BASE+REG_BGMOV_H]
	#add		a, 4
	shl		a
	shl		a
	shl		a
	mov		b, 0
	add		x2, BA
	#sub		x2, 8*4
	
	mov		b, 8
_copyy:
	mov		a, [x2]
	mov		[x1], a
	inc		x2
	inc		x1
	jdbnz	_copyy
	
	

	call	enemy_lasers

	call	set_tiles

	pop		HL
	reti



#########################
# GAME ENTRY            #
#########################
start:
    ### set up sp and nn registers
    # set SP to end of general purpose RAM (stack grows downwards)
    movw	sp, REG_BASE
    # NN register points to hardware registers
    movw	nn, REG_BASE
    
    movb	[nn+REG_TIMER256_CNT], 1
    mov		a, 0xAB
    movb	[rndseed], a
	

	mov		[nn+$FE], $81
	mov		[nn+$FF], $1E
	
	
	movb	a, 0
	movb	[csp], a

	movw	x1, music
	movw	[tune], x1
	movw	x1, 0xffff
	movw	[effect], x1
	
    ### niederiger wert = schneller
    movw	x1, 617  #1850
	movw	[REG_BASE+REG_TIMER2_PRESET], x1

    ## no output
	movw	x1, 0
	movw	[REG_BASE+REG_TIMER3_PRESET], x1
	movw	[REG_BASE+REG_TIMER3_PIVOT], x1


	mov		[nn+REG_TIMER_CONTROL], TIMERS_ON
	mov		[nn+REG_TIMER2_PRESCALE], PRESCALE_ENABLE | PRESCALE_FREQ_31250HZ
	mov		[nn+REG_TIMER3_PRESCALE], PRESCALE_ENABLE | PRESCALE_FREQ_2MHZ
			
	mov		[nn+REG_TIMER2_CNT1], 2 | TIMER_ENABLE | TIMER_PRESET
	mov		[nn+REG_TIMER2_CNT2], 2

	mov		[nn+REG_TIMER3_CNT1], TIMER_ENABLE | TIMER_PRESET
	mov		[nn+REG_TIMER3_CNT2], 0

	mov		[nn+REG_VOLUME], 3


	call	init_titlescreen
	
	mov		[nn+REG_EVENT1S],INT1S_VBLANK|INT1S_TIMER2OVERFLOW
    mov		[nn+REG_EVENT1P],INT1P_V|INT1P_TIMER2OVERFLOW

	mov		flags, 0

    ### endless loop
game_end:
    jmp		game_end


    
##################################
# BG LINEAR # PSEUDO LINEAR MODE #
##################################
bglinear:
	push	HL
	push	b
	
	movb	b, 95
	movw	HL, TILEMAP+95
_bgloop:
	movb	[HL], b
	dec	HL
	jdbnz   _bgloop
	movb	[HL], b
    
	pop	b
	pop	HL

	ret


##########################################
# load level function                    #
# x2 : new level
##########################################
loadlevel:
	push		x1
	mov		x1, level
	
_copyloop:
	mov		BA, [x2]
	mov		[x1], BA
	add		x1, 2
	add		x2, 2
	
	cmp		x1, level_end
	jnz		_copyloop
	
	mov		a, 123
	mov		[lvlend+24], a
	mov		[lvlend+25], a
	mov		[lvlend+12], a
	mov		[lvlend+13], a
	mov		[lvlend], a
	
	pop		x1
	ret


####################################
# collision check function         #
# checks a position (enemy laser)  #
# against an 11x11 box (player)    #
# arg: x1, y1, bx2, by2            #
# trashes: BA, x2, HL              #
####################################
chkcol:
	mov		BA, [SP+3]
	mov		x2, [SP+7]
	
	sub		x2, BA
	js		_retfalse
	cmp		x2, 11
	jge		_retfalse
	
	mov		BA, [SP+5]
	mov		x2, [SP+9]

	sub		x2, BA
	js		_retfalse
	cmp		x2, 11
	jge		_retfalse
	
_rettrue:
	mov		HL, [SP+0]
	add		SP, 3+4*2
	orb		flags, 0b00000001
	jmp		HL
_retfalse:
	mov		HL, [SP+0]
	add		SP, 3+4*2
	and		flags, 0b11111110

	jmp		HL

############################
# sets up the title screen #
############################
init_titlescreen:
    push	n
	push	x1
	push	a

	mov		nn, OAM

	movb	[nn+REG_EVENT3P], 0
	movb	[nn+REG_EVENT3S], 0

	movb	[nn+34], 15
    movb	[nn+38], 16
    movb	[nn+42], 17
	movb	[nn+2], 18
    movb	[nn+6], 19
    movb	[nn+10], 20
    movb	[nn+14], 19
    movb	[nn+18], 21
    movb	[nn+22], 22
    movb	[nn+26], 23
    movb	[nn+30], 24

	mov		nn, REG_BASE

	mov		x1,OAM
	mov		b, 96
deloam:
	mov		[x1], 0
	inc		x1
	jdbnz	deloam

	#display mode	
	movb	[nn+REG_LCD_CNT0],LCD0_RENDER|LCD0_TILEBG|LCD0_MAP12x16|LCD0_SPRITES
	movb	[nn+REG_LCD_CNT1], LCD1_ENABLE|LCD1_REFRESH1
	mov		[nn+REG_BGMOV_V],0
	mov		[nn+REG_BGMOV_H],0

	
	mov		a, -(96*2)
	mov		[scrl], a
	
	mov		a, (96*2)
	mov		[scrr], a

    call	bglinear

	mov		nn, OAM
	movb	[nn+34], 15
    movb	[nn+38], 16
    movb	[nn+42], 17
	movb	[nn+2], 18
    movb	[nn+6], 19
    movb	[nn+10], 20
    movb	[nn+14], 19
    movb	[nn+18], 21
    movb	[nn+22], 22
    movb	[nn+26], 23
    movb	[nn+30], 24	
	mov		nn, REG_BASE
   
    movb	[nn+REG_EVENT2P],INT2P_KEYPAD
    movb	[nn+REG_EVENT2S],INT2S_KEY_POWER|INT2S_KEY_A|INT2S_KEY_LEFT|INT2S_KEY_RIGHT|INT2S_KEY_UP|INT2S_KEY_DOWN
    
    mov		x1, titlescreen
    mov		[vblank], x1
    
    pop		a
    pop		x1
    pop		n
    ret

################################
# sets up the game over screen #
################################
init_gameover:
	push	n
	push	x1
	
	mov		nn, REG_BASE

	movb	[nn+REG_EVENT3P], 0
	movb	[nn+REG_EVENT3S], 0

	#setup the display
	movb	[nn+REG_LCD_CNT0],LCD0_RENDER|LCD0_TILEBG|LCD0_MAP12x16
	movb	[nn+REG_LCD_CNT1], LCD1_ENABLE|LCD1_REFRESH1
	mov		[nn+REG_BGMOV_V],0
	mov		[nn+REG_BGMOV_H],0
	
	call	bglinear
	mov		x1, gameover
	mov		[vblank], x1
	movb	[nn+REG_EVENT2S],INT2S_KEY_POWER|INT2S_KEY_A
	
	pop		x1
	pop		n
	ret


#############################
# sets up the finish screen #
#############################
init_finish:
	push	n
	push	x1
	
	mov		nn, REG_BASE


	movb	[nn+REG_EVENT3P], 0
	movb	[nn+REG_EVENT3S], 0

	#setup the display
	movb	[nn+REG_LCD_CNT0],LCD0_RENDER|LCD0_TILEBG|LCD0_MAP12x16
	movb	[nn+REG_LCD_CNT1], LCD1_ENABLE|LCD1_REFRESH1
	mov		[nn+REG_BGMOV_V],0
	mov		[nn+REG_BGMOV_H],0
	
	call	bglinear
	mov		x1, vblfinish
	mov		[vblank], x1
	movb	[nn+REG_EVENT2S],INT2S_KEY_POWER|INT2S_KEY_A
	
	pop		x1
	pop		n
	ret

##############################
# called when a life is lost #
##############################
lostlife:
	push	n
	push	a

	movb	a, [cheats]
	test	a, CHEAT_GODMODE
	jnz		_godmode
	
	mov		nn, OAM
	mov		a,[OAM+15]
	cmp		a, OAM_ENABLE
	jnz		_life3_taken
	
	mov		[nn+15], OAM_DISABLE #we lost a life
	jmp		_still_alive         #but we are still alive :)
	
_life3_taken:

	mov		a,[OAM+11]
	cmp		a, OAM_ENABLE
	jnz		_life2_taken
	
	mov		[nn+11], OAM_DISABLE
	jmp		_still_alive
	
_life2_taken:

	mov		a,[OAM+7]
	cmp		a, OAM_ENABLE
	jnz		_life1_taken
	
	mov		[nn+7], OAM_DISABLE
	
_life1_taken:

_still_alive:

	movb	a, 32
	movb	[invert2], a
	
	
	call	ignite_bomb
	call	remove_lasers
_godmode:
	pop		a
	pop		n
	ret

###################################
# SOUND: BOOM                     #
###################################
playboom:
	push	x1
	push	BA

	movw	x1, explode
	movw	[effect], x1				#point cursor to effect
	
	mov		x1, explode_e
	mov		[effect_end], x1		#save current effect end position
	
	mov		a, [x1]					#load wait var from tune
	mov		[effect_csp], a

	mov		a, 3					#rumble effect
	mov		[rumble], a

	pop		BA
	pop		x1
	ret

###################################
# SOUND: HIT                      #
###################################
playhit:
	push	x1
	push	BA
	
	movw	x1, hit
	movw	[effect], x1				#point cursor to effect
	
	mov		x1, hit_e
	mov		[effect_end], x1		#save current effect end position
	
	mov		a, [x1]					#load wait var from tune
	mov		[effect_csp], a

	mov		a, 8					#rumble effect
	mov		[rumble], a

	mov		a, 3					#invert effect
	mov		[invert], a

	pop		BA
	pop		x1
	ret

###################################
# SOUND: LASER                    #
###################################
playlaser:
	push	x1
	push	BA
	
	movw	x1, laser
	movw	[effect], x1				#point cursor to effect
	
	mov		x1, laser_e
	mov		[effect_end], x1		#save current effect end position
	
	mov		a, [x1]					#load wait var from tune
	mov		[effect_csp], a

	pop		BA
	pop		x1
	ret


####################################
# ingite the bomb! clean playfield #
####################################
ignite_bomb:
	push	BA
	push	x1
	push	x2
	
	movw	x1, [scrolly]
	movb	b, 12*8
_looper:

	mov		a, [x1]
	test	a, 0x3
	jz		_noenemy
	mov		[x1], 0
	mov		x2, [score]
    add		x2, 5
    mov		[score], x2
_noenemy:

	inc		x1
	jdbnz	_looper
	
	pop		x2
	pop		x1
	pop		BA
	ret

#####################
# cast enemy lasers #
#####################
enemy_lasers:
	#first generate a random number - this is to reduce the amount of lasers
	mov		a, [REG_BASE+REG_TIMER256_COUNT]
	mov		b, [rndseed]
	add		a, b
	rol		a
	mov		[rndseed], a
	and		a, 0b01111111
	cmp		a, 85
	jc		_no_sprites


	### first look for a free sprite
	mov		x2, OAM+63 #first enable/disable
_find_laser:
	mov		a, [x2]
	cmp		a, OAM_ENABLE
	jnz		_laser_found
	add		x2, 4

	cmp		x2, OAM+95 #last enable/disable
	jnz		_find_laser	
	
	jmp		_no_sprites #no sprites available
	
_laser_found:
	
	

	mov		a, [REG_BASE+REG_TIMER256_COUNT]
	mov		b, [rndseed]
	add		a, b
	rol		a
	mov		[rndseed], a
	and		a, 0b01111111
	cmp		a, 96
	jc		_lower
	sub		a, 96
_lower:
	mov		b, 0
	#check if enemy is at that position
	mov		x1, [scrolly]
	add		x1, BA
	mov		b,[x1]
	test	b, 0x3
	jz		_no_sprites #no enemy

	mov		b, 0
_divloop:
	cmp		a, 12
	jc		_divdone

	sub		a, 12
	inc		b
	jmp		_divloop
_divdone:

	shl		a #*2
	shl		a #*4
	shl		a #*8
	add		a, 16+3 #x
	sub		a, [REG_BASE+REG_BGMOV_H]

	xchg	a, b
	
	shl		a #*2
	shl		a #*4
	shl		a #*8
	add		a, 16+7 #y
	sub		a, [REG_BASE+REG_BGMOV_V]
	
	mov		[x2], OAM_ENABLE
	sub		x2, 2
	mov		[x2], a
	dec		x2
	mov		[x2], b
	
    

_nenemy:

_no_sprites:
	ret

######################################
# handle button A - Spawn new lasers #
######################################
player_shoot:
   
      
    
    mov		x1, [shootdelay]
    cmp		x1,0
    jz		_nodec
    dec		x1
_nodec:
    mov		[shootdelay], x1
    #if result of last arithmetic operation was 0 then delay was reached
    jnz		a_not_pressed
    
   	movb	a, [cheats]
	test	a, CHEAT_AUTOFIRE
	jnz		_doautofire
    
    mov		a, [keyregold]
    test	a, KEY_A
    jz		a_not_pressed
    
_doautofire:
    
    test	[nn+REG_KEYPAD],KEY_A
    jnz		a_not_pressed
    
    
    
    #init the new delay
    mov		x1, 14
    mov		[shootdelay], x1
    mov		nn, OAM
    
    #is laser 1 enabled?
    movb	a, [nn+47]
    cmp		a, OAM_ENABLE
    jz		_laser1
    movb	[nn+47], OAM_ENABLE
    #spawn laser at ship center
    movb	a, [nn+0]
    add		a, 4
    movb	[nn+44], a  # x
    movb	[nn+45], 60 # y
    jmp		laser_added
_laser1:

    movb	a, [nn+51]
    cmp		a, OAM_ENABLE
    jz		_laser2
    movb	[nn+51], OAM_ENABLE
    movb	a, [nn+0]
    add		a, 4
    movb	[nn+48], a
    movb	[nn+49], 60    
    jmp		laser_added
_laser2:

    movb	a, [nn+55]
    cmp		a, OAM_ENABLE
    jz		_laser3
    movb	[nn+55], OAM_ENABLE
    movb	a, [nn+0]
    add		a, 4
    movb	[nn+52], a
    movb	[nn+53], 60    
    jmp		laser_added
_laser3:
	mov		nn, REG_BASE
	jmp		a_not_pressed

laser_added:
	mov		nn, REG_BASE

	#### laser was added - play the laser sound! beep! :)
	call	playlaser
    
a_not_pressed:

	mov		a, [nn+REG_KEYPAD]
	mov		[keyregold], a

	ret

#####################################
# set up tile map                   #
#####################################
set_tiles:
	movw	x1, [scrolly]
	movb	b, 11  # one more row because of scrolling
	movw	x2, TILEMAP

copy12blocks:
	movb	a, [x1]
	movb	[x2], a

	movb	a, [x1+1]
	movb	[x2+1], a

	movb	a, [x1+2]
	movb	[x2+2], a

	movb	a, [x1+3]
	movb	[x2+3], a

	movb	a, [x1+4]
	movb	[x2+4], a

	movb	a, [x1+5]
	movb	[x2+5], a

	movb	a, [x1+6]
	movb	[x2+6], a

	movb	a, [x1+7]
	movb	[x2+7], a

	movb	a, [x1+8]
	movb	[x2+8], a

	movb	a, [x1+9]
	movb	[x2+9], a

	movb	a, [x1+10]
	movb	[x2+10], a

	movb	a, [x1+11]
	movb	[x2+11], a

	movb	a, 0
	movb	[x2+12], a

	add	x1, 12
	add	x2, 16

	jdbnz	copy12blocks
	ret

###################################################
# newgame - Starts a new game (+score/life reset) #
###################################################
newgame:
	push	n
	push	x2
	push	a


	mov		a, [cheats]
	test	a, CHEAT_FASTBOMB
	jz		_nocheat
	mov		nn, REG_BASE
	orb		[nn+REG_EVENT2S],INT2S_KEY_C
_nocheat:

    ### Initialize the sprite
    # use nn addressing for accessing OAM data
    movw	nn, OAM

    # set up sprite: life 1
    movb	[nn+4], 103
    movb	[nn+5], 69
    movb	[nn+6], 30  #we use another image for this sprite
    movb	[nn+7], OAM_ENABLE

    # set up sprite: life 2
    movb	[nn+8], 94
    movb	[nn+9], 69
    movb	[nn+10], 1
    movb	[nn+11], OAM_ENABLE

    # set up sprite: life 3
    movb	[nn+12], 85
    movb	[nn+13], 69
    movb	[nn+14], 1
    movb	[nn+15], OAM_ENABLE
    
    #health bar
    movb	[nn+56], 64
    movb	[nn+57], 16+58
    movb	[nn+58], 25+3
    movb	[nn+59], OAM_ENABLE
    
    mov		x2, 0
    mov		[score], x2
    
    mov		a, 0
    mov		[curlvl], a
    
    mov		x2, level1    
	call	loadlevel
    
    pop		a
    pop		x2
    pop		n
	ret

#################################
# inits all game variables      #
#################################
initgame:
	push	x1
	push	BA
	push	n
	
	mov		nn, REG_BASE
	movb	[nn+REG_LCD_CNT0],LCD0_RENDER|LCD0_TILEBG|LCD0_MAP16x12|LCD0_SPRITES|LCD0_INVERT
	movb	[nn+REG_LCD_CNT1], LCD1_ENABLE|LCD1_REFRESH1
	
	movb	[nn+REG_EVENT3P], INT3P_SHOCK
	movb	[nn+REG_EVENT3S], INT3S_SHOCK

	mov		a, 0
	mov		[invert], a
	mov		[invert2], a
	mov		[rumble], a

	mov		x1, movepath
	mov		[pmovepath],x1
	
	mov		[nn+REG_BGMOV_V],1
	mov		a, 8
	mov		[temp1], a		
	mov		x1, 8
	mov		[shootdelay], x1

    mov		x1, level_end-96-12
    mov		[scrolly], x1

    ### set REG_LCD_TILEBGMEM
    mov		x1, tiles
    mov		[REG_BASE+REG_LCD_TILEBGMEM], x1

    ### set REG_LCD_SPRITEMEM
    movw	x1, sprites1
    movw	[REG_BASE+REG_LCD_SPRITEMEM], x1

	mov		a, (48+9)*2
	mov		[shipx], a
	

    ### Initialize the sprite
    # use nn addressing for accessing OAM data
    movw	nn, OAM

    # set up first sprite (our space-ship)
    movb	[nn+0], 48+9
    movb	[nn+1], 62
    movb	[nn+2], 0
    movb	[nn+3], OAM_ENABLE

    #### score

    # set up sprite - score part 1
    movb	[nn+16], 16
    movb	[nn+17], 74
    movb	[nn+18], 2  #we use another image for this sprite
    movb	[nn+19], OAM_ENABLE

    # set up sprite - score part 2
    movb	[nn+20], 32
    movb	[nn+21], 74
    movb	[nn+22], 3  #we use another image for this sprite
    movb	[nn+23], OAM_ENABLE

    # set up sprite - score letters
    movb	[nn+24], 39
    movb	[nn+25], 74
    movb	[nn+26], 4+1
    movb	[nn+27], OAM_ENABLE

    movb	[nn+28], 43
    movb	[nn+29], 74
    movb	[nn+30], 4+4
    movb	[nn+31], OAM_ENABLE

    movb	[nn+32], 47
    movb	[nn+33], 74
    movb	[nn+34], 4+8
    movb	[nn+35], OAM_ENABLE

    movb	[nn+36], 51
    movb	[nn+37], 74
    movb	[nn+38], 4+3
    movb	[nn+39], OAM_ENABLE

    movb	[nn+40], 55
    movb	[nn+41], 74
    movb	[nn+42], 4+9
    movb	[nn+43], OAM_ENABLE

	# lasers (for player)
    movb	[nn+44], 55
    movb	[nn+45], 50
    movb	[nn+46], 29
    movb	[nn+47], OAM_DISABLE
    
    movb	[nn+48], 55
    movb	[nn+49], 50
    movb	[nn+50], 29
    movb	[nn+51], OAM_DISABLE
    
    movb	[nn+52], 55
    movb	[nn+53], 50
    movb	[nn+54], 29
    movb	[nn+55], OAM_DISABLE
    
    # lasers (for enemies)
    movb	[nn+60], 55
    movb	[nn+61], 50
    movb	[nn+62], 14
    movb	[nn+63], OAM_DISABLE
    
    movb	[nn+64], 55
    movb	[nn+65], 50
    movb	[nn+66], 14
    movb	[nn+67], OAM_DISABLE

	movb	[nn+68], 55
    movb	[nn+69], 50
    movb	[nn+70], 14
    movb	[nn+71], OAM_DISABLE
    
    movb	[nn+72], 55
    movb	[nn+73], 50
    movb	[nn+74], 14
    movb	[nn+75], OAM_DISABLE
    
    movb	[nn+76], 55
    movb	[nn+77], 50
    movb	[nn+78], 14
    movb	[nn+79], OAM_DISABLE
    
	movb	[nn+80], 55
    movb	[nn+81], 50
    movb	[nn+82], 14
    movb	[nn+83], OAM_DISABLE
    
    movb	[nn+84], 55
    movb	[nn+85], 50
    movb	[nn+86], 14
    movb	[nn+87], OAM_DISABLE
    
    movb	[nn+88], 55
    movb	[nn+89], 50
    movb	[nn+90], 14
    movb	[nn+91], OAM_DISABLE    

	movb	[nn+92], 55
    movb	[nn+93], 50
    movb	[nn+94], 14
    movb	[nn+95], OAM_DISABLE
    
    pop		n
    pop		BA
    pop		x1    
	ret


invert_sprites:
	push	BA
	push	x1

	movw	x1, OAM+3

	mov		b, 24
	
_sprloop:
	mov		a, [x1]
	orb		a, OAM_INVERT
	movb	[x1], a
	add		x1,4
	jdbnz	_sprloop
	
	pop		x1
	pop		BA
	ret


ninvert_sprites:
	push	BA
	push	x1

	movw	x1, OAM+3

	mov		b, 24
	
_sprloop:
	movb	a, [x1]
	andb	a, ~OAM_INVERT
	movb	[x1], a
	add		x1,4
	jdbnz	_sprloop
	
	pop		x1
	pop		BA
	ret
	
	
remove_lasers:
	push	n
	mov		nn, OAM
	# lasers (for player)
    movb	[nn+44], 55
    movb	[nn+45], 50
    movb	[nn+46], 29
    movb	[nn+47], OAM_DISABLE
    
    movb	[nn+48], 55
    movb	[nn+49], 50
    movb	[nn+50], 29
    movb	[nn+51], OAM_DISABLE
    
    movb	[nn+52], 55
    movb	[nn+53], 50
    movb	[nn+54], 29
    movb	[nn+55], OAM_DISABLE
    
    # lasers (for enemies)
    movb	[nn+60], 55
    movb	[nn+61], 50
    movb	[nn+62], 14
    movb	[nn+63], OAM_DISABLE
    
    movb	[nn+64], 55
    movb	[nn+65], 50
    movb	[nn+66], 14
    movb	[nn+67], OAM_DISABLE

	movb	[nn+68], 55
    movb	[nn+69], 50
    movb	[nn+70], 14
    movb	[nn+71], OAM_DISABLE
    
    movb	[nn+72], 55
    movb	[nn+73], 50
    movb	[nn+74], 14
    movb	[nn+75], OAM_DISABLE
    
    movb	[nn+76], 55
    movb	[nn+77], 50
    movb	[nn+78], 14
    movb	[nn+79], OAM_DISABLE
    
	movb	[nn+80], 55
    movb	[nn+81], 50
    movb	[nn+82], 14
    movb	[nn+83], OAM_DISABLE
    
    movb	[nn+84], 55
    movb	[nn+85], 50
    movb	[nn+86], 14
    movb	[nn+87], OAM_DISABLE
    
    movb	[nn+88], 55
    movb	[nn+89], 50
    movb	[nn+90], 14
    movb	[nn+91], OAM_DISABLE    

	movb	[nn+92], 55
    movb	[nn+93], 50
    movb	[nn+94], 14
    movb	[nn+95], OAM_DISABLE
    
    pop		n
    ret
	
movepath:
.db 0,0,1,1,2,3,4,5,6,6,7,7,7,7,6,6,5,4,3,2,1,1,0,0

divtab:
.db 10000,1000,100,10


level1:
.incbin level1.bin

level2:
.incbin level2.bin

level3:
.incbin level3.bin


titlesin:
.incbin	sintab1.bin


.align	8
bgtiles1:
.incbin tiles1.bin

bgtiles2:
.incbin tiles2.bin

splash1:
.incbin splash1.bin
splash2:
.incbin splash2.bin

finish1:
.incbin finish1.bin
finish2:
.incbin finish2.bin

goscreen1:
.incbin goscreen1.bin
goscreen2:
.incbin goscreen2.bin


###########################
.align 64
sprites1:
.incbin invader1.bin

#this is done for easy swap of tiles
.org	(sprites1+128*64)
sprites2:
.incbin invader2.bin

#######################
### MUSIC DATA PAGE ###
#######################
.org	0x10000
music:
.incbin starblazer1.mfx
music_e:

laser:
.incbin laser.mfx
laser_e:

explode:
.incbin explode.mfx
explode_e:

hit:
.incbin hit.mfx
hit_e:
