; 3x5 Font test
.equ		PAGE_SIZE		60
.equ		ROW_LENGTH		6

.include	"pmio.asm" 		;Lupin's IO defines

.orgfill 0x1460
;RAM
charnum:
.db 0
xpos:
.db 0
ypos:
.db 0
page:
.db	0
error:
.db 0
row_start:				#start of row
.dw	0
page_buf:
.ds	PAGE_SIZE			#80 bytes (1 page) from the eeprom

.orgfill 0x2100
.db "MN" 			;ROM ID

;------------- Interrupt table ---------------
#INT #0
.orgfill 0x2102   #GAME START
    jmp start
#INT #1    
.orgfill 0x2108   #V-BLANK
    jmp unhandled_interrupt
#INT #2
.orgfill 0x210E   #V-DRAW
    jmp unhandled_interrupt
#INT #3
.orgfill 0x2114   #TIMER 2 OVERFLOW
    jmp unhandled_interrupt
#INT #4
.orgfill 0x211A   # 
    jmp unhandled_interrupt
#INT #5
.orgfill 0x2120   #TIMER 1 OVERFLOW
    jmp unhandled_interrupt
#INT #6
.orgfill 0x2126   # 
    jmp unhandled_interrupt
#INT #7
.orgfill 0x212C   #TIMER 3 OVERFLOW
    jmp unhandled_interrupt
#INT #8
.orgfill 0x2132   #TIMER 3 OVERFLOW
    jmp unhandled_interrupt
#INT #9
.orgfill 0x2138   # 
    jmp unhandled_interrupt
#INT #10
.orgfill 0x213E   # 
    jmp unhandled_interrupt
#INT #11
.orgfill 0x2144   # 
    jmp unhandled_interrupt
#INT #12
.orgfill 0x214A   # 
    jmp unhandled_interrupt
#INT #13
.orgfill 0x2150   #IR RECEIVE LOW TO HIGH
    jmp unhandled_interrupt
#INT #14
.orgfill 0x2156   #SHOCK DETECTOR
    jmp unhandled_interrupt
#INT #15
.orgfill 0x215C   #KEY PRESS: POWER BUTTON
    jmp int_power_key
#INT #16
.orgfill 0x2162   #KEY PRESS: D-PAD RIGHT
    jmp unhandled_interrupt
#INT #17
.orgfill 0x2168   #KEY PRESS: D-PAD LEFT
    jmp unhandled_interrupt
#INT #18
.orgfill 0x216E   #KEY PRESS: D-PAD DOWN
    jmp int_down_key
#INT #19
.orgfill 0x2174   #KEY PRESS: D-PAD UP
    jmp int_up_key
#INT #20
.orgfill 0x217A   #KEY PRESS: C KEY
    jmp unhandled_interrupt
#INT #21
.orgfill 0x2180   #KEY PRESS: B KEY
    jmp unhandled_interrupt
#INT #22
.orgfill 0x2186   #KEY PRESS: A KEY
    jmp unhandled_interrupt
#INT #23
.orgfill 0x218C   # 
    jmp unhandled_interrupt
#INT #24
.orgfill 0x2192   # 
    jmp unhandled_interrupt
#INT #25
.orgfill 0x2198   # 
    jmp unhandled_interrupt
;---------------------------------------------
    
.orgfill 0x219E   
.orgfill 0x21A4 
.db "NINTENDO"         ; magic signature checked by the BIOS
.db "EEPR"             ; game code - 4 byte
.db "EEPROMReader"     ; name of rom, 12 chars max
.orgfill 0x21Bc
.db "2P"

# end of rom header, start of program code
.orgfill 0x21D0

unhandled_interrupt:
    reti   #reti - return from interrupt


int_power_key:
    movb	[nn+REG_INT_FLAG2],IF_KEY_POWER
    test	[nn+REG_KEYPAD],KEY_POWER
    jnz		noturnoff
    cint	$24
noturnoff:
    reti

int_down_key:
    movb	[nn+REG_INT_FLAG2],IF_KEY_DOWN
    test	[nn+REG_KEYPAD],KEY_DOWN
    jnz		nodown
    mov		a, [page]	#needs bounds checking
    inc		a
    mov		[page], a
    call 	draw_page
nodown:
    reti

int_up_key:
    movb	[nn+REG_INT_FLAG2],IF_KEY_UP
    test	[nn+REG_KEYPAD],KEY_UP
    jnz		noup
    mov		a, [page]
    dec		a
    mov		[page], a
    call	draw_page
noup:
    reti


start:
    ### set up sp and nn registers
    # set SP to end of general purpose RAM (stack grows downwards)
    movw	sp, REG_BASE
    # NN register points to hardware registers
    movw	nn, REG_BASE
		
    ### activate input events
    movb	[nn+REG_EVENT2P],INT2P_KEYPAD
    movb	[nn+REG_EVENT2S],INT2S_KEY_POWER|INT2S_KEY_DOWN|INT2S_KEY_UP

    ### activate interrupts
    mov		flags, 0


    ### activate the LCD.
    movb	[nn+REG_LCD_CNT0],LCD0_RENDER
    # enable the LCD and set the refresh rate to fast mode
    movb	[nn+REG_LCD_CNT1], LCD1_ENABLE|LCD1_REFRESH1


    # restore nn for later use		
    movw	nn, REG_BASE

	mov		a, 0
	mov		[error], a
	mov 	[page], a
	call	draw_page
	
    ### endless loop - we check if a key is pressed or not
game_end:
    jmp		game_end

#--------------------------------------------
# draw_page - draw a page from the eeprom
draw_page:	
	mov		h, 0
	mov		l, PAGE_SIZE
	mov		b, [page]
	mov		x1, 0		#x1 will hold eeprom start address
	cmp 	b, 0
	jz 		set_start_address
add_page:	
	add		x1, hl
	jdbnz	add_page
	
set_start_address:
	#enable the eeprom lines
	#orb		[nn+REG_IO_DATA], IO_EEPROM_DATA|IO_EEPROM_CLOCK 	#start high
	orb		[nn+REG_IO_ENABLE], IO_EEPROM_DATA|IO_EEPROM_CLOCK

	call	start_condition	
		
	#write device address byte
	mov		a, 0b10100000	#dummy write, to set address
	call 	send_byte
	mov		ba, x1			#get high byte off address
	mov		a, b
	call 	send_byte
	mov		ba, x1			#and low byte
	call 	send_byte
	#now set to read
	call	start_condition
	mov		a, 0b10100001	#read
	call 	send_byte
	
	#read into buffer
	mov		x2,	page_buf
	mov		l, 0
	
read_data:
	andb	[nn+REG_IO_ENABLE], IO_EEPROM_DATA_OFF	#switch data line to read
	call	read_byte
	andb	[nn+REG_IO_DATA], IO_EEPROM_CLOCK_OFF	#clock down
	orb		[nn+REG_IO_ENABLE], IO_EEPROM_DATA		#switch data line to write
	
	mov		[x2+l], a
	inc		l
	cmp		l, PAGE_SIZE
	jz		all_read
	#send ack
	andb	[nn+REG_IO_DATA], IO_EEPROM_DATA_OFF	#data down
	orb		[nn+REG_IO_DATA], IO_EEPROM_CLOCK		#clock up
	andb	[nn+REG_IO_DATA], IO_EEPROM_CLOCK_OFF	#clock down
	jmp		read_data
	
all_read:
	#send stop condition
	orb		[nn+REG_IO_DATA], IO_EEPROM_CLOCK		#clock up 
	orb		[nn+REG_IO_DATA], IO_EEPROM_DATA		#data up
	andb	[nn+REG_IO_DATA], IO_EEPROM_CLOCK_OFF	#clock down
		
	#disable the eeprom lines
	andb	[nn+REG_IO_ENABLE], IO_EEPROM_DATA_OFF&IO_EEPROM_CLOCK_OFF
	
	#now draw the page
	call	clear_screen
	call 	draw_lines
	mov		a, 0
	mov		[ypos], a
	mov		[xpos], a
	
draw_row:
	#address (2 bytes)
	mov		[row_start], x2		#store for later
	mov		ba, x1
	mov		a, b
	call 	draw_byte
	mov		ba, x1
	call	draw_byte
	mov		a, [xpos]
	inc 	a
	inc 	a
	mov		[xpos], a
	
	#6 bytes of data
	mov		b, ROW_LENGTH
draw_datum:
	mov		a, [x2]
	call 	draw_byte
	inc		x2			#increment buffer address
	inc 	x1			#increment rom address too
	mov		a, [xpos]
	inc 	a
	mov		[xpos], a
	jdbnz	draw_datum
	
	inc 	a
	mov		[xpos], a	#extra space to clear line
	
	#now draw the ascii characters for the row
	mov		x2, [row_start]	#reset buffer pos
	mov		b, ROW_LENGTH
_draw_ascii_char:
	mov		a, [x2]
	call 	draw_ascii
	inc		x2
	jdbnz	_draw_ascii_char
	
	#increment ypos
	mov		a, 0
	mov		[xpos], a
	mov		a, [ypos]
	add		a, 6
	mov		[ypos], a
	cmp		a, 60
	jnz		draw_row
	
	#draw error code in column 72 of top byte-row
	mov		x2, VRAM
	add		x2, 72
	mov		a, [error]
	mov		[x2], a
	
	ret

#---------------------------------------------	
#start condition - data down, clock down
start_condition:
	orb		[nn+REG_IO_DATA], IO_EEPROM_DATA	#data up
	orb		[nn+REG_IO_DATA], IO_EEPROM_CLOCK	#clock up
	andb	[nn+REG_IO_DATA], IO_EEPROM_DATA_OFF
	andb	[nn+REG_IO_DATA], IO_EEPROM_CLOCK_OFF
	ret
#--------------------------------------------
#send byte - transmit a byte of data
#assumes clock is down, destroys b
#input is in a
send_byte:
	mov		b, 8
_send_bit:
	andb	[nn+REG_IO_DATA], IO_EEPROM_CLOCK_OFF	#clock down
	rolb	a			#msb to lsb
	test	a, 1
	jz		_send_bit_off
	orb		[nn+REG_IO_DATA], IO_EEPROM_DATA	#switch bit on
	jmp 	_next_bit
	
_send_bit_off:
	andb	[nn+REG_IO_DATA], IO_EEPROM_DATA_OFF	#switch bit off
	
_next_bit:
	orb		[nn+REG_IO_DATA], IO_EEPROM_CLOCK	#clock up
	jdbnz	_send_bit
	
	#ack
	andb	[nn+REG_IO_DATA], IO_EEPROM_CLOCK_OFF	#clock down
	andb	[nn+REG_IO_ENABLE],	IO_EEPROM_DATA_OFF	#switch data line to read
	orb		[nn+REG_IO_DATA], IO_EEPROM_CLOCK		#clock up
	testb	[nn+REG_IO_DATA], IO_EEPROM_DATA		#read bit
	jnz		_do_something
	#orb		[nn+REG_IO_DATA], IO_EEPROM_CLOCK		#clock up
	orb		[nn+REG_IO_ENABLE],	IO_EEPROM_DATA		#switch data line to write
	jmp		_done
	
_do_something:
	mov 	b, a
	mov		a,	$ff
	mov		[error], a
	mov 	a, b
_done:
	andb	[nn+REG_IO_DATA], IO_EEPROM_CLOCK_OFF	#clock down
	ret	
#--------------------------------------------
#read byte - receive a byte of data
#assumes clock is high, destroys b
#output goes in a
read_byte:
	mov		b, 8
	mov		a, 0
_read_bit:
	andb	[nn+REG_IO_DATA], IO_EEPROM_CLOCK_OFF	#clock down
	orb		[nn+REG_IO_DATA], IO_EEPROM_CLOCK	#clock up
	shlb	a
	testb	[nn+REG_IO_DATA], IO_EEPROM_DATA		#read bit
	jz		_next_read
	inc		a										#set low bit
	
_next_read:
	jdbnz	_read_bit
	
	ret	
#--------------------------------------------
# clear screen 
clear_screen:
	push	x1
	mov		x1, VRAM
	mov		a, 0
	
_wipe_byte:
	mov		[x1], a
	inc		x1
	cmp		x1, OAM		#end of VRAM is OAM
	jnz		_wipe_byte
	
	pop		x1
	ret
#--------------------------------------------
# draw lines to divide the screen
draw_lines:
	push	x1
	mov		x1, VRAM
	add		x1, 16
	mov		a, $ff
	
_draw_line:
	mov		[x1], a
	add		x1, 96
	cmp		x1, OAM		#end of VRAM is OAM
	jc		_draw_line
	
	mov		x1, VRAM
	add		x1, 71
	
_draw_line2:
	mov		[x1], a
	add		x1, 96
	cmp		x1, OAM		#end of VRAM is OAM
	jc		_draw_line2
	
	pop		x1
	ret
#--------------------------------------------
# draw_byte - draw a byte to the screen as 
# two hex characters
# updates xpos, byte is in a
draw_byte:
	push	x1		#save the stuff we might be using
	push 	x2
	push	b
	
	push 	a		#save byte
	
	shr		a		#first character
	shr		a
	shr		a
	shr		a
	call	draw_hex
	mov		a, [xpos]	#update screen pos
	add		a, 4
	mov		[xpos], a
	
	pop 	a		#retrieve byte
	andb	a, $0f	#second character
	call 	draw_hex
	mov		a, [xpos]	#update screen pos
	add		a, 4
	mov		[xpos], a
	
	pop		b		#restore our saved data
	pop		x2
	pop		x1
	ret
#--------------------------------------------
# draw_hex - convert our halfbyte to a charnum
draw_hex:
	cmp		a, 10
	jnc		_letter
	
	#it's a number, add $10 to it
	add		a, $10
	mov		[charnum], a
	jmp		_paint_it
	
	#it's a letter, add $21
_letter:
	add		a, $17
	mov		[charnum], a
	
_paint_it:
	call	draw_char
	ret
#--------------------------------------------
# draw_ascii - convert our byte to a charnum
draw_ascii:
	push	x1		#save the stuff we might be using
	push 	x2
	push	b
	
	sub 	a, $20
	cmp		a, 96
	jc		_valid
	
	#unknown char, draw . (asc $2e, charset $0e)
	mov		a, $0e
_valid:
	mov		[charnum], a
	call	draw_char
	
	mov		a, [xpos]	#update screen pos
	add		a, 4
	mov		[xpos], a
	
	pop 	b
	pop 	x2
	pop		x1
	ret
#--------------------------------------------
# draw_char - draw character [charnum] at [xpos] [ypos]
# (destroys registers - save them first)
#draw_char
draw_char:
	mov		a, [charnum]
	mov		b, 0
	
	mov		x1, font_data
	add		x1, ba		#pointer to char data
	add		x1, ba		#at font_data + 3*charnum
	add		x1, ba		#since chars are 3 bytes
	
	mov		a, [ypos]
	#divide y by 8 to find out which 8-pixel block it is in
	shr		a
	shr		a
	shr 	a
	#multiply by 96 for complete rows
	mov		x2, VRAM
	mov		h, 0
	mov		l, 96
calc_row:	
	cmp		a, 0
	jz 		add_x
	add		x2, hl		#add 96 until we run out of rows
	dec		a
	jmp		calc_row
	
add_x:
	#add x to get the starting byte in screen mem
	mov		a, [xpos]
	mov		b, 0
	add		x2, ba		#store in x2
	
	#get vertical offset (y mod 8)
	mov 	a, [ypos]
	and		a, 0x07
	mov 	b, a		#store in b
	mov		h, a		#and h
	mov		a, 0
	mov		l, 0		#column of character
	
draw_col:
	mov		a, [charnum]
	mov		b, 0
	
	mov		x1, font_data
	add		x1, ba		#pointer to char data
	add		x1, ba		#at font_data + 3*charnum
	add		x1, ba		#since chars are 3 bytes
	
	mov 	a, [x1+l]	#get character
	
	#rotate the column byte
	mov		b, h
	cmp 	b, 0
	jz		done_rotate
shift_down:
	rol		a
	jdbnz	shift_down
	
done_rotate:
	mov		b, a
	mov		x1, mask_top	#get mask pointer
	pushb	l				#store column
	mov		l, h
	mov		a, [x1+l]		#get correct mask for top	
	and		a, b			#get correct part of character (?)
	popb 	l				#restore column
	pushb	b				#save rotated character
	mov		b, a			#masked character to b
	mov		a, [x2+l]
	or		a, b
	mov		[x2+l], a
	popb	b				#get rotated char back
	
	cmp 	h, 3			#if offset is 3 or less then no second byte needed
	jc		no_bottom
	
	pushb 	b
	#this might overflow the bottom of the vram, but I don't think it matters
	mov		b, 0
	mov		a, 96
	add		x2, ba			#next row of bytes
	
	#bottom part of character
	popb 	b				#get rotated character data back
	mov		x1, mask_bottom
	pushb 	l
	mov		l, h
	mov		a, [x1+l]		#get mask for bottom
	and		a, b			#get correct part of character byte
	mov		b, a			#save in b
	popb 	l
	mov		a, [x2+l]
	or		a, b
	mov		[x2+l], a		#write to screen
	
	#subtract 96 again to get x2 back to normal
	mov		b, 0
	mov		a, 96
 	sub		x2, ba
 	
no_bottom:
	#next column
	mov		a, l
	inc 	a
	mov		l, a
	cmp		a, 3
	jz		next_char
	
	jmp		draw_col
	
next_char:
	ret	

; data
mask_top:
.db		0x1f, 0x3e, 0x7c, 0xf8, 0xf0, 0xe0, 0xc0, 0x80
mask_bottom:
.db		0x00, 0x00, 0x00, 0x00, 0x01, 0x03, 0x07, 0x0f
# mask_top:
# .db		0xf8, 0x7c, 0x3e, 0x1f, 0x0f, 0x07, 0x03, 0x01
# mask_bottom:
# .db		0x00, 0x00, 0x00, 0x00, 0x80, 0xc0, 0xe0, 0xf0

font_data:
.incbin "3x5font.bin"