/* A Simple Pointer Table Recalculator
 * Written by Prez@lfx.org
 * Last updated: August 22th, 2000.
 * Current version: 1.0
 *
 * This may prove useful for recalcing the
 * pointer table of a entire dialog block.
 *
 */ 

#include <stdio.h>
#include <fcntl.h>
#include <stdlib.h>

#define ARGNUM 6

int main(int argc, char ** argv) {
  int i, psf, fp, dstart, dend, pstart, firstp, defaultp, breakv;
  unsigned char * pt;
  unsigned char * db;

  if ( argc < ARGNUM ) exit(printf("Usage: recalc [rom file] [dialog start addr] [dialog end addr]\n              [pointer table addr] [break value] <default pointer addr>\n"));

  sscanf(argv[2],"%x",&dstart);
  sscanf(argv[3],"%x",&dend);
  sscanf(argv[4],"%x",&pstart);
  sscanf(argv[5],"%x",&breakv);
  sscanf(argv[6],"%x",&defaultp);

  if ( dstart > dend ) exit(printf("Error: Your dialog block ends before it starts.\n"));
  if ( pstart > dstart ) exit(printf("Error: Pointer table *should* come before dialog block.\n"));
  if ( argc > ARGNUM && ( defaultp < dstart ) ) exit(printf("Error: Default pointer must be after dialog block start.\n"));

  pt = malloc(dstart-pstart);
  db = malloc(dend-dstart);

  if ( pt == NULL || db == NULL ) exit(printf("Error: Ran out of memory.\n"));

  fp = open(argv[1],O_RDWR|O_BINARY);
  if ( fp == -1 ) exit(printf("Error: Couldn't open \"%s\".\n", argv[0]));

  lseek(fp,pstart,SEEK_SET);
  read(fp,pt,2);

  firstp = ( pt[0] + ( pt[1] * 0x100 ) );

  printf("\nRecalculating: Dialog Block (%X-%X)\n               Pointer Block (%X)\n               1st pointer: %04X\n               Break value: %02X\n\n", dstart, dend, pstart, firstp, breakv);

  if ( argc > ARGNUM ) {
    for ( i = 0 ; i < (dstart-pstart)/2 ; i++ ) {
      pt[(i*2)] = ((firstp+(defaultp-dstart))&0xFF);
      pt[(i*2)+1] = ((firstp+(defaultp-dstart))&0xFF00)/0x100;
    }
  }

  lseek(fp,dstart,SEEK_SET);
  read(fp,db,dend-dstart);

  pt[0] = ((firstp)&0xFF);
  pt[1] = ((firstp)&0xFF00)/0x100;

  for ( i = 0, psf = 1; i < dend-dstart ; i++ ) {
    if ( db[i] == breakv ) {
      if ( psf > (dstart-pstart)/2 ) exit(printf("Error: Too many script entries, pointer table exausted.\n"));

      pt[(psf*2)] = ((firstp+i+1)&0xFF);
      pt[(psf*2)+1] = ((firstp+i+1)&0xFF00)/0x100;
      psf++;
    }
  }

  lseek(fp,pstart,SEEK_SET);

  if ( argc > ARGNUM ) write(fp,pt,dstart-pstart);
  else write(fp,pt,psf*2);

  close(fp);

  free(pt);
  free(db);

  return(0);
}
