###
### This example shows how to display a screen with 6 shades of grey
### by writing directly to the LCD display. The screen is converted
### using a little VB app that i wrote.
### The grey is generated by having 5 screens alternating
### as fast as possible.
### So we can have an intensity of 0/5 if a pixel is OFF in all 5
### screens, we can have 1/5 intensity if just one pixel is ON in a
### single of the 5 screens. We can also have 2/5 3/5 4/5 and 5/5
###


.include	"pmio.asm"

#-------------------------------------- RAM ---------------------------------
.orgfill 0x1000   # first part of RAM is VRAM

.orgfill 0x1460
###

#---------------------------- CART INTERRUPT HANDLERS -----------------------
.orgfill 0x2100   # "MN" ID
.db "MN"
#INT #0
.orgfill 0x2102   #GAME START
    jmp start
#INT #1    
.orgfill 0x2108   #V-BLANK
    jmp unhandled_interrupt
#INT #2
.orgfill 0x210E   #V-DRAW
    jmp unhandled_interrupt
#INT #3
.orgfill 0x2114   #TIMER 2 OVERFLOW
    jmp unhandled_interrupt
#INT #4
.orgfill 0x211A   # 
    jmp unhandled_interrupt
#INT #5
.orgfill 0x2120   #TIMER 1 OVERFLOW
    jmp unhandled_interrupt
#INT #6
.orgfill 0x2126   # 
    jmp unhandled_interrupt
#INT #7
.orgfill 0x212C   #TIMER 3 OVERFLOW
    jmp unhandled_interrupt
#INT #8
.orgfill 0x2132   #TIMER 3 OVERFLOW
    jmp unhandled_interrupt
#INT #9
.orgfill 0x2138   # 
    jmp unhandled_interrupt
#INT #10
.orgfill 0x213E   # 
    jmp unhandled_interrupt
#INT #11
.orgfill 0x2144   # 
    jmp unhandled_interrupt
#INT #12
.orgfill 0x214A   # 
    jmp unhandled_interrupt
#INT #13
.orgfill 0x2150   #IR RECEIVE LOW TO HIGH
    jmp unhandled_interrupt
#INT #14
.orgfill 0x2156   #SHOCK DETECTOR
    jmp unhandled_interrupt
#INT #15
.orgfill 0x215C   #KEY PRESS: POWER BUTTON
    jmp int_power_key
#INT #16
.orgfill 0x2162   #KEY PRESS: D-PAD RIGHT
    jmp unhandled_interrupt
#INT #17
.orgfill 0x2168   #KEY PRESS: D-PAD LEFT
    jmp unhandled_interrupt
#INT #18
.orgfill 0x216E   #KEY PRESS: D-PAD DOWN
    jmp unhandled_interrupt
#INT #19
.orgfill 0x2174   #KEY PRESS: D-PAD UP
    jmp unhandled_interrupt
#INT #20
.orgfill 0x217A   #KEY PRESS: C KEY
    jmp unhandled_interrupt
#INT #21
.orgfill 0x2180   #KEY PRESS: B KEY
    jmp unhandled_interrupt
#INT #22
.orgfill 0x2186   #KEY PRESS: A KEY
    jmp unhandled_interrupt
#INT #23
.orgfill 0x218C   # 
    jmp unhandled_interrupt
#INT #24
.orgfill 0x2192   # 
    jmp unhandled_interrupt
#INT #25
.orgfill 0x2198   # 
    jmp unhandled_interrupt
    
.orgfill 0x219E   
## 0
    
#-------------------------------- CART HEADER -------------------------------
.orgfill 0x21A4 
.db "NINTENDO"         # magic signature checked by the BIOS
.db "TPME"             # game code - 4 byte
.db "6COLOR IMAGE"     # name of rom, 12 chars max
.orgfill 0x21Bc
.db "2P"               

#--------------------------------- CART MAIN --------------------------------
.orgfill 0x21D0

unhandled_interrupt:
    reti
    
int_power_key:
	movb	[nn+REG_INT_FLAG2],IF_KEY_POWER
	test	[nn+$52],$80		# Power key
	jnz		noturnoff
	cint	$24			# bye bye
noturnoff:
	reti
		

start:
  mov		sp, $2000    # set SP
  movw	nn, REG_BASE           # NN reg always point to hardware regs
	
  ### activate input events
  mov		[nn+REG_EVENT2S],INT2S_KEY_POWER	# Interrupt Enable
  mov		[nn+REG_EVENT2P],INT2P_KEYPAD	# Master Enable

  mov		[nn+0xFE], 0x81
  mov		[nn+0xFE], 0x1D

resetscreen:
  movw	x1, testscreen
idleloop:
	cmp		x1, testscreen+768*5
	jge		resetscreen
	call	copy_image_static			#x1 will be incremented by 768 in this function (so it will point to next screen in next run)
  jmp		idleloop


.macro putpix bbb
  movb		[nn+0xFF], [x1]
  inc x1
  nop
.endm

###############################################
# COPIES AN IMAGE TO GDDRAM OF LCD CONTROLLER #
###############################################
copy_image_static:
	#b=row select ("page address")
	movb		b, 0xB0

	### Wait for LCD vblank
_waitsyncloop1: 
  test	[nn+0x8A], 0x10
  jnz		_waitsyncloop1


_dorow:
	#a=high column address nibble, start out with 0
	mov		a, 0x10
	mov		[nn+$FE], b		#row
	
_docol:
	mov		[nn+$FE], a
	
	#write 16 bytes to GDDRAM
	putpix 0
	putpix 1
	putpix 2
	putpix 3
	putpix 4
	putpix 5
	putpix 6
	putpix 7
	putpix 8
	putpix 9
	putpix 10
	putpix 11
	putpix 12
	putpix 13
	putpix 14
	putpix 15
	
	inc		a			#increment high address of column
	cmp		a, 0x16
	jnz		_docol
	
	inc		b			#increment page/row address
	cmp		b, 0xB8
	jnz		_dorow

	ret
	
testscreen:
.incbin testscreen.bin
