################################
# 4 bit / 4000 Hz sound player #
################################

.include	"pmio.asm"

#-------------------------------------- RAM ---------------------------------
.orgfill 0x1000   # first part of RAM is VRAM
.orgfill 0x1460


#---------------------------- CART INTERRUPT HANDLERS -----------------------
.orgfill 0x2100   # "MN" ID
.db "MN"
#INT #0
.orgfill 0x2102   #GAME START
    jmp start
#INT #1    
.orgfill 0x2108   #V-BLANK
    jmp unhandled_interrupt
#INT #2
.orgfill 0x210E   #V-DRAW
    jmp unhandled_interrupt
#INT #3
.orgfill 0x2114   #TIMER 2 OVERFLOW
    jmp dosound
#INT #4
.orgfill 0x211A   # 
    jmp unhandled_interrupt
#INT #5
.orgfill 0x2120   #TIMER 1 OVERFLOW
    jmp unhandled_interrupt
#INT #6
.orgfill 0x2126   # 
    jmp unhandled_interrupt
#INT #7
.orgfill 0x212C   #TIMER 3 OVERFLOW
    jmp unhandled_interrupt
#INT #8
.orgfill 0x2132   #TIMER 3 OVERFLOW
    jmp unhandled_interrupt
#INT #9
.orgfill 0x2138   # 
    jmp unhandled_interrupt
#INT #10
.orgfill 0x213E   # 
    jmp unhandled_interrupt
#INT #11
.orgfill 0x2144   # 
    jmp unhandled_interrupt
#INT #12
.orgfill 0x214A   # 
    jmp unhandled_interrupt
#INT #13
.orgfill 0x2150   #IR RECEIVE LOW TO HIGH
    jmp unhandled_interrupt
#INT #14
.orgfill 0x2156   #SHOCK DETECTOR
    jmp unhandled_interrupt
#INT #15
.orgfill 0x215C   #KEY PRESS: POWER BUTTON
    jmp int_power_key
#INT #16
.orgfill 0x2162   #KEY PRESS: D-PAD RIGHT
    jmp unhandled_interrupt
#INT #17
.orgfill 0x2168   #KEY PRESS: D-PAD LEFT
    jmp unhandled_interrupt
#INT #18
.orgfill 0x216E   #KEY PRESS: D-PAD DOWN
    jmp unhandled_interrupt
#INT #19
.orgfill 0x2174   #KEY PRESS: D-PAD UP
    jmp unhandled_interrupt
#INT #20
.orgfill 0x217A   #KEY PRESS: C KEY
    jmp unhandled_interrupt
#INT #21
.orgfill 0x2180   #KEY PRESS: B KEY
    jmp unhandled_interrupt
#INT #22
.orgfill 0x2186   #KEY PRESS: A KEY
    jmp unhandled_interrupt
#INT #23
.orgfill 0x218C   # 
    jmp unhandled_interrupt
#INT #24
.orgfill 0x2192   # 
    jmp unhandled_interrupt
#INT #25
.orgfill 0x2198   # 
    jmp unhandled_interrupt
    
.orgfill 0x219E   
## 0
    
#-------------------------------- CART HEADER -------------------------------
.orgfill 0x21A4 
.db "NINTENDO"         # magic signature checked by the BIOS
.db "LUPI"             # game code - 4 byte
.db "4 bit sound "     # name of rom, 12 chars max
.orgfill 0x21Bc
.db "2P"               

#--------------------------------- CART MAIN --------------------------------
.orgfill 0x21D0

unhandled_interrupt:
    reti

int_power_key:
	movb	[nn+REG_INT_FLAG2],IF_KEY_POWER
	test	[nn+$52],$80		# Power key
	jnz		noturnoff
	cint	$24			# bye bye
noturnoff:
	reti




dosound:
	movb 	[nn+REG_INT_FLAG1],IF_TIMER2OVERFLOW

	inc		b
	test	b, 1
	jnz		loadfirst
	
	movb	l, [x1]
	
	movb	a, l
	shr		a
	shr		a
	shr		a
	shr		a
	movb	[REG_BASE+REG_TIMER3_PIVOT], a
	jmp		loaded

loadfirst:

	andb	l, 0xF
	movb	[REG_BASE+REG_TIMER3_PIVOT], l

	movx	a, x1
	inc		x1
	jnz		noinc
	inc		a
	movx	x1, a
noinc:

	cmp		x1, soundend
	jnz		endnotreached
	cmp		a, (soundend>>16)
	jnz		endnotreached
	
	movx		x1, (sound>>16)
	movw		x1, sound

endnotreached:

loaded:
	
  reti
	

start:
	mov		sp, $2000    # set SP
	movw	nn, REG_BASE           # NN reg always point to hardware regs


	### activate input events
	mov		[nn+REG_EVENT2S],INT2S_KEY_POWER	# Interrupt Enable
	mov		[nn+REG_EVENT2P],INT2P_KEYPAD	# Master Enable

	movw	x1, title
	call	copy_image_gddram

	### set volume
	mov		[nn+REG_VOLUME], 3
	
	### setup timers
	mov		[nn+REG_TIMER_CONTROL], TIMERS_ON
	mov		[nn+REG_TIMER2_PRESCALE], PRESCALE_ENABLE | PRESCALE_FREQ_2MHZ
	mov		[nn+REG_TIMER3_PRESCALE], PRESCALE_ENABLE | PRESCALE_FREQ_2MHZ
	
	### activate Timer 2 interrupts
	mov		[nn+REG_EVENT1P],INT1P_TIMER2OVERFLOW
	mov		[nn+REG_EVENT1S],INT1S_TIMER2OVERFLOW
	
	### activate timer 2
	mov		[nn+REG_TIMER2_CNT1], TIMER_ENABLE | TIMER_PRESET
	mov		[nn+REG_TIMER2_CNT2], 0

	### activate timer 3
	mov		[nn+REG_TIMER3_CNT1], TIMER_ENABLE | TIMER_PRESET
	mov		[nn+REG_TIMER3_CNT2], 0


	### let timer 2 run at 4000 Hz
	movw	x1, (2000000 / 4000)
	movw	[REG_BASE+REG_TIMER2_PRESET], x1

	### Values from 0-15 define the 4 bit range
	movw	x1, 15
	movw	[REG_BASE+REG_TIMER3_PRESET], x1
	### no sound yet
	movw	x1, 0
	movw	[REG_BASE+REG_TIMER3_PIVOT], x1


	
	### init regs
	mov		b, 0
	mov		a, 0
	mov		l, 0
	mov		x1, sound
  movx	x1, 0
	
	#mov		flags, 0   #only needed on emulator and emulator cant emulate this anyways :P
	
	### do nothing
game_end:
	jmp		game_end



###############################################
# COPIES AN IMAGE TO GDDRAM OF LCD CONTROLLER #
###############################################
copy_image_gddram:
	push	BA	
	
	#b=row select ("page address")
	movb		b, 0xB0
dorow:
	
	#a=high column address nibble, start out with 0
	mov		a, 0x10
	mov		[nn+$FE], b		#row
	
	
docol:
	mov		[nn+$FE], a		#high column
	
	#write 16 bytes to GDDRAM
	
	mov		[nn+$FE], 0x00	#low column
	mov		[nn+$FF], [x1]		#write byte to GDDRAM
	inc		x1
	
	mov		[nn+$FE], 0x01
	mov		[nn+$FF], [x1]
	inc		x1

	mov		[nn+$FE], 0x02
	mov		[nn+$FF], [x1]
	inc		x1

	mov		[nn+$FE], 0x03
	mov		[nn+$FF], [x1]
	inc		x1

	mov		[nn+$FE], 0x04
	mov		[nn+$FF], [x1]
	inc		x1

	mov		[nn+$FE], 0x05
	mov		[nn+$FF], [x1]
	inc		x1

	mov		[nn+$FE], 0x06
	mov		[nn+$FF], [x1]
	inc		x1

	mov		[nn+$FE], 0x07
	mov		[nn+$FF], [x1]
	inc		x1

	mov		[nn+$FE], 0x08
	mov		[nn+$FF], [x1]
	inc		x1

	mov		[nn+$FE], 0x09
	mov		[nn+$FF], [x1]
	inc		x1

	mov		[nn+$FE], 0x0A
	mov		[nn+$FF], [x1]
	inc		x1

	mov		[nn+$FE], 0x0B
	mov		[nn+$FF], [x1]
	inc		x1

	mov		[nn+$FE], 0x0C
	mov		[nn+$FF], [x1]
	inc		x1
	
	mov		[nn+$FE], 0x0D
	mov		[nn+$FF], [x1]
	inc		x1
	
	mov		[nn+$FE], 0x0E
	mov		[nn+$FF], [x1]
	inc		x1
	
	mov		[nn+$FE], 0x0F
	mov		[nn+$FF], [x1]
	inc		x1

	
	inc		a			#increment high address of column
	cmp		a, 0x16
	jnz		docol
	
	
	inc		b			#increment page/row address
	cmp		b, 0xB8
	jnz		dorow

	pop		BA
	ret


.align 8
title:
.incbin title.bin

sound:
.incbin Hawkeye2.4pm
soundend: