###
### This example plays back a 4 bit wave sample and draws an animation with
### grey shade to the screen. It does not use the PMs drawing hardware because
### it would majorly distort the audio output so that it's not possible to play
### the sound at even 1000 Hz. However with this method it would be possible to
### play the sound with up to 8000 Hz while still having the grey shade, this
### is because the sound timer has the highest priority and not the screen 
### redraw.
###


.include	"pmio.asm"

.equ		ANIMSPEED		8		## less = faster
.equ		NUMFRAMES		18

#-------------------------------------- RAM ---------------------------------
.orgfill 0x1000   # first part of RAM is VRAM

.orgfill 0x1460
frame:
.db		0

animdelay:
.db		0

animpos:
.dw		0

sndpos:
.dw		0

flip:
.db		0

tiledata:
.dw		0

#---------------------------- CART INTERRUPT HANDLERS -----------------------
.orgfill 0x2100   # "MN" ID
.db "MN"
#INT #0
.orgfill 0x2102   #GAME START
    jmp start
#INT #1    
.orgfill 0x2108   #V-BLANK
    jmp unhandled_interrupt
#INT #2
.orgfill 0x210E   #V-DRAW
    jmp unhandled_interrupt
#INT #3
.orgfill 0x2114   #TIMER 2 OVERFLOW
    jmp dosound
#INT #4
.orgfill 0x211A   # 
    jmp unhandled_interrupt
#INT #5
.orgfill 0x2120   #TIMER 1 OVERFLOW
    jmp unhandled_interrupt
#INT #6
.orgfill 0x2126   # 
    jmp unhandled_interrupt
#INT #7
.orgfill 0x212C   #TIMER 3 OVERFLOW
    jmp unhandled_interrupt
#INT #8
.orgfill 0x2132   #TIMER 3 OVERFLOW
    jmp unhandled_interrupt
#INT #9
.orgfill 0x2138   # 
    jmp unhandled_interrupt
#INT #10
.orgfill 0x213E   # 
    jmp unhandled_interrupt
#INT #11
.orgfill 0x2144   # 
    jmp unhandled_interrupt
#INT #12
.orgfill 0x214A   # 
    jmp unhandled_interrupt
#INT #13
.orgfill 0x2150   #IR RECEIVE LOW TO HIGH
    jmp unhandled_interrupt
#INT #14
.orgfill 0x2156   #SHOCK DETECTOR
    jmp unhandled_interrupt
#INT #15
.orgfill 0x215C   #KEY PRESS: POWER BUTTON
    jmp int_power_key
#INT #16
.orgfill 0x2162   #KEY PRESS: D-PAD RIGHT
    jmp unhandled_interrupt
#INT #17
.orgfill 0x2168   #KEY PRESS: D-PAD LEFT
    jmp unhandled_interrupt
#INT #18
.orgfill 0x216E   #KEY PRESS: D-PAD DOWN
    jmp unhandled_interrupt
#INT #19
.orgfill 0x2174   #KEY PRESS: D-PAD UP
    jmp unhandled_interrupt
#INT #20
.orgfill 0x217A   #KEY PRESS: C KEY
    jmp unhandled_interrupt
#INT #21
.orgfill 0x2180   #KEY PRESS: B KEY
    jmp unhandled_interrupt
#INT #22
.orgfill 0x2186   #KEY PRESS: A KEY
    jmp unhandled_interrupt
#INT #23
.orgfill 0x218C   # 
    jmp unhandled_interrupt
#INT #24
.orgfill 0x2192   # 
    jmp unhandled_interrupt
#INT #25
.orgfill 0x2198   # 
    jmp unhandled_interrupt
    
.orgfill 0x219E   
## 0
    
#-------------------------------- CART HEADER -------------------------------
.orgfill 0x21A4 
.db "NINTENDO"         # magic signature checked by the BIOS
.db "4BIT"             # game code - 4 byte
.db "4BITSOUND___"     # name of rom, 12 chars max
.orgfill 0x21Bc
.db "2P"               

#--------------------------------- CART MAIN --------------------------------
.orgfill 0x21D0

unhandled_interrupt:
    reti
    
int_power_key:
	movb	[nn+REG_INT_FLAG2],IF_KEY_POWER
	test	[nn+$52],$80		# Power key
	jnz		noturnoff
	cint	$24			# bye bye
noturnoff:
	reti
	
### 4 bit sound handler
dosound:
	push	HL
	push	a

	movb 	[nn+REG_INT_FLAG1],IF_TIMER2OVERFLOW

	movb	a, [flip]
	inc		a
	movb	[flip], a
	test	a, 1
	jnz		loadfirst
	
	movw	HL, [sndpos]
	movx	HL, 1
	movb	a, [HL]	
	movx	HL, 0

	shr		a
	shr		a
	shr		a
	shr		a
	movb	[REG_BASE+REG_TIMER3_PIVOT], a
	jmp		loaded

loadfirst:

	movw	HL, [sndpos]
	movx	HL, 1
	movb	a, [HL]
	movx	HL, 0

	andb	a, 0xF
	movb	[REG_BASE+REG_TIMER3_PIVOT], a

	inc		HL
	cmp		HL, soundend
	jnz		endnotreached
	movw		HL, sound
endnotreached:

loaded:

	movw	[sndpos], HL
	
	pop		a
	pop		HL
  reti
  

	

start:
  mov		sp, $2000    # set SP
  movw	nn, REG_BASE           # NN reg always point to hardware regs
	
  ### activate input events
  mov		[nn+REG_EVENT2S],INT2S_KEY_POWER	# Interrupt Enable
  mov		[nn+REG_EVENT2P],INT2P_KEYPAD	# Master Enable
  	
  ### set volume
	mov		[nn+REG_VOLUME], 3
	
	### setup timers
	mov		[nn+REG_TIMER_CONTROL], TIMERS_ON
	mov		[nn+REG_TIMER2_PRESCALE], PRESCALE_ENABLE | PRESCALE_FREQ_2MHZ
	mov		[nn+REG_TIMER3_PRESCALE], PRESCALE_ENABLE | PRESCALE_FREQ_2MHZ
	
	### activate Timer 2 interrupts
	mov		[nn+REG_EVENT1P],INT1P_TIMER2OVERFLOW
	mov		[nn+REG_EVENT1S],INT1S_TIMER2OVERFLOW
	
	### activate timer 2
	mov		[nn+REG_TIMER2_CNT1], TIMER_ENABLE | TIMER_PRESET
	mov		[nn+REG_TIMER2_CNT2], 0

	### activate timer 3
	mov		[nn+REG_TIMER3_CNT1], TIMER_ENABLE | TIMER_PRESET
	mov		[nn+REG_TIMER3_CNT2], 0


	### let timer 2 run at 4000 Hz
	movw	x1, (2000000 / 4000)
	movw	[REG_BASE+REG_TIMER2_PRESET], x1

	### Values from 0-15 define the 4 bit range
	movw	x1, 15
	movw	[REG_BASE+REG_TIMER3_PRESET], x1
	### no sound yet
	movw	x1, 0
	movw	[REG_BASE+REG_TIMER3_PIVOT], x1

	### sound start position
	movw	x1, 0
	movw	[sndpos], x1
	### animation start position
	movw	[animpos], x1
	### initialize delay counter
	mov		a, ANIMSPEED
	mov		[animdelay], a
	
	
	#setup screen
  movb	b, 96
  movw	HL, TILEMAP+96
bglinear:
  movb	[HL], b
  dec		HL
  jdbnz       bglinear
    
idleloop:
	mov		x1, [animpos]
	
	### decrement delay counter and check for zero
	mov		a, [animdelay]
	dec		a
	jnz		nonxtframe
	
	### delay counter reached 0, reset counter and proceed to next frame
	mov		a, ANIMSPEED
	add		x1, 768
	### check for end of movie
	cmp		x1, 768*NUMFRAMES
	jnz		noresetfmv
	mov		x1, 0
noresetfmv:
	mov		[animpos], x1
	
nonxtframe:
	mov		[animdelay], a
	
	### do the greyish thing by alternating between the two sets
	mov		a, [frame]
  inc		a
  mov		[frame], a
    
  test	a, 1
  jnz		t1__
  add		x1, animation1           # set tiles graphix base
  jmp		t2__
t1__:
  add		x1, animation2           # set tiles graphix base
t2__:
  
  
  movw	[tiledata], x1
  
 
  ### update the screen
	call	copy_image_gddram

  jmp		idleloop
    
#####################################

animation1:
.incbin		anim/bounce.a00
.incbin		anim/bounce.a01
.incbin		anim/bounce.a02
.incbin		anim/bounce.a03
.incbin		anim/bounce.a04
.incbin		anim/bounce.a05
.incbin		anim/bounce.a06
.incbin		anim/bounce.a07
.incbin		anim/bounce.a08
.incbin		anim/bounce.a09
.incbin		anim/bounce.a10
.incbin		anim/bounce.a11
.incbin		anim/bounce.a12
.incbin		anim/bounce.a13
.incbin		anim/bounce.a14
.incbin		anim/bounce.a15
.incbin		anim/bounce.a16
.incbin		anim/bounce.a17


animation2:
.incbin		anim/bounce.b00
.incbin		anim/bounce.b01
.incbin		anim/bounce.b02
.incbin		anim/bounce.b03
.incbin		anim/bounce.b04
.incbin		anim/bounce.b05
.incbin		anim/bounce.b06
.incbin		anim/bounce.b07
.incbin		anim/bounce.b08
.incbin		anim/bounce.b09
.incbin		anim/bounce.b10
.incbin		anim/bounce.b11
.incbin		anim/bounce.b12
.incbin		anim/bounce.b13
.incbin		anim/bounce.b14
.incbin		anim/bounce.b15
.incbin		anim/bounce.b16
.incbin		anim/bounce.b17


###############################################
# COPIES AN IMAGE TO GDDRAM OF LCD CONTROLLER #
###############################################
copy_image_gddram:	
	#b=row select ("page address")
	movb		b, 0xB0
	mov		x2, TILEMAP
	mov		x1, [tiledata]

	### Wait for LCD vblank
waitsyncloop: 
  test	[nn+0x8A], 0x10
  jnz		waitsyncloop
  
  ### Now update the screen
dorow:
	
	#a=high column address nibble, start out with 0
	mov		a, 0x10
	mov		[nn+$FE], b		#row
	
docol:
	
	mov		[nn+$FE], a		#high column
	
	#write 16 bytes to GDDRAM
	#this section is critical because of the damn slow display,
	#if you move in data too fast display errors will appear
	
	movb	l, [x2]
	add		HL, HL
	movb	h, (mul8>>8)
	movw	HL,[HL]
	add		HL, x1
	
	movb	[nn+$FF], [HL]
	inc		HL
	inc		x2							#do useful operation instead of NOP
	movb	[nn+$FF], [HL]
	inc		HL
	nop
	movb	[nn+$FF], [HL]
	inc		HL
	nop
	movb	[nn+$FF], [HL]
	inc		HL
	nop
	movb	[nn+$FF], [HL]
	inc		HL
	nop
	movb	[nn+$FF], [HL]
	inc		HL
	nop
	movb	[nn+$FF], [HL]
	inc		HL
	nop
	movb	[nn+$FF], [HL]
		
		

	movb	l, [x2]
	add		HL, HL
	movb	h, (mul8>>8)
	movw	HL,[HL]	
	add		HL, x1
	
	movb	[nn+$FF], [HL]
	inc		HL
	inc		x2
	movb	[nn+$FF], [HL]
	inc		HL
	nop
	movb	[nn+$FF], [HL]
	inc		HL
	nop
	movb	[nn+$FF], [HL]
	inc		HL
	nop
	movb	[nn+$FF], [HL]
	inc		HL
	nop
	movb	[nn+$FF], [HL]
	inc		HL
	nop
	movb	[nn+$FF], [HL]
	inc		HL
	nop
	movb	[nn+$FF], [HL]

	
	inc		a			#increment high address of column
	cmp		a, 0x16
	jnz		docol
	
	
	inc		b			#increment page/row address
	cmp		b, 0xB8
	jnz		dorow

	ret
	
.align 256
mul8:
.dw	0*8, 1*8, 2*8, 3*8, 4*8, 5*8, 6*8, 7*8, 8*8, 9*8, 10*8, 11*8, 12*8, 13*8, 14*8, 15*8, 16*8
.dw 17*8, 18*8, 19*8, 20*8, 21*8, 22*8, 23*8, 24*8, 25*8, 26*8, 27*8, 28*8, 29*8, 30*8, 31*8, 32*8
.dw 33*8, 34*8, 35*8, 36*8, 37*8, 38*8, 39*8, 40*8, 41*8, 42*8, 43*8, 44*8, 45*8, 46*8, 47*8, 48*8
.dw 49*8, 50*8, 51*8, 52*8, 53*8, 54*8, 55*8, 56*8, 57*8, 58*8, 59*8, 60*8, 61*8, 62*8, 63*8, 64*8
.dw 65*8, 66*8, 67*8, 68*8, 69*8, 70*8, 71*8, 72*8, 73*8, 74*8, 75*8, 76*8, 77*8, 78*8, 79*8, 80*8
.dw 81*8, 82*8, 83*8, 84*8, 85*8, 86*8, 87*8, 88*8, 89*8, 90*8, 91*8, 92*8, 93*8, 94*8, 95*8, 96*8
.dw 97*8, 98*8, 99*8, 100*8, 101*8, 102*8, 103*8, 104*8, 105*8, 106*8, 107*8, 108*8, 109*8, 110*8, 111*8, 112*8
.dw 113*8, 114*8, 115*8, 116*8, 117*8, 118*8, 119*8, 120*8, 121*8, 122*8, 123*8, 124*8, 125*8, 126*8, 127*8, 128*8

### include the sound file... 4 bits per sample, 4000Hz
.orgfill 0x10000
sound:
.incbin lazyjones.4pm
soundend: