# PokemonMini Register definitions by Lupin

##Memory defines
.equ	VRAM		$1000
.equ	OAM		$1300
.equ	TILEMAP		$1360

.equ	REG_BASE	$2000

######Registers#######

###256 Hz Timer
.equ	REG_TIMER256_CNT		$40
.equ	REG_TIMER256_COUNT		$41

###AUDIO TIMER
.equ	REG_VOLUME			$71

.equ	REG_TIMER3_CNT1			$48
.equ	REG_TIMER3_CNT2			$49
.equ	REG_TIMER3_PRESET		$4A
.equ	REG_TIMER3_PIVOT		$4C
.equ	REG_TIMER3_COUNT		$4E


.equ	REG_TIMER2_CNT1			$38
.equ	REG_TIMER2_CNT2			$39
.equ	REG_TIMER2_PRESET		$3A
.equ	REG_TIMER2_PIVOT		$3C #unused?
.equ	REG_TIMER2_COUNT		$3E


.equ	REG_TIMER1_CNT1			$30
.equ	REG_TIMER1_CNT2			$31
.equ	REG_TIMER1_PRESET		$32
.equ	REG_TIMER1_PIVOT		$34
.equ	REG_TIMER1_COUNT		$36

.equ	TIMER_ENABLE			$80
.equ	TIMER_PRESET			$04

.equ	REG_TIMER_CONTROL		$19
.equ	TIMERS_ON				$20

.equ	REG_TIMER1_PRESCALE		$18
.equ	REG_TIMER2_PRESCALE		$1A
.equ	REG_TIMER3_PRESCALE		$1C
.equ	PRESCALE_ENABLE			0b01000

#most frequencies are wrong
.equ	PRESCALE_FREQ_2MHZ		0  #2
.equ	PRESCALE_FREQ_500KHZ	1  #8
.equ	PRESCALE_FREQ_125KHZ	2  #32
.equ	PRESCALE_FREQ_62500HZ	3  #64
.equ	PRESCALE_FREQ_31250HZ	4  #128
.equ	PRESCALE_FREQ_15625HZ	5  #256
.equ	PRESCALE_FREQ_3906HZ	6  #1024
.equ	PRESCALE_FREQ_977HZ		7  #4096

###SECONDS TIMER
.equ    REG_SECONDS_TIMER_CNT	$08
.equ	REG_SECONDS_TIMER_DL	$09
.equ	REG_SECONDS_TIMER_DM	$0A
.equ	REG_SECONDS_TIMER_DH	$0B

###LCD CONTROL
.equ    REG_LCD_CNT0	$80
.equ	REG_LCD_CNT1	$81

.equ	REG_BGMOV_V	$85
.equ	REG_BGMOV_H	$86

#tile memory
.equ	REG_LCD_TILEBGMEM	$82
.equ	REG_LCD_TILEBGMEM_HI	$84
.equ	REG_LCD_SPRITEMEM	$87
.equ	REG_LCD_SPRITEMEM_HI	$89

.equ	REG_LCD_STATUS		$8A
.equ	LCD_STATUS_VSYNC	16

.equ    LCD0_INVERT	0b00000001
.equ	LCD0_TILEBG	0b00000010 #render BG
.equ	LCD0_SPRITES	0b00000100 #render SPRITES
.equ	LCD0_RENDER	0b00001000 #render enable
.equ	LCD0_MAP12x16	0b0000
.equ	LCD0_MAP16x12	0b10000
.equ	LCD0_MAP24x8	0b100000
.equ	LCD0_MAP24x16	0b110000 ##prohibited (?)

.equ	LCD1_ENABLE				$01
.equ	LCD1_REFRESH1   		$08
.equ	LCD1_SLOW0				$02
.equ	LCD1_SLOW1				$04

#OAM attributes
.equ    OAM_FLIPH  			0b00000001
.equ    OAM_FLIPV 	 		0b00000010
.equ    OAM_INVERT  			0b00000100
.equ    OAM_ENABLE			0b00001000
.equ    OAM_DISABLE			0b00000000

###???
#.equ	LCD1_REFRESH30HZ	4
#.equ	LCD1_REFRESH20HZ	0
#.equ	LCD1_REFRESH15HZ	5
#.equ	LCD1_REFRESH10HZ	1
#.equ	LCD1_REFRESH10HZ	6
#.equ	LCD1_REFRESH7_5HZ	7
#.equ	LCD1_REFRESH6_6HZ	2
#.equ	LCD1_REFRESH5HZ		3

###INPUT
.equ	REG_KEYPAD		$52
.equ	KEY_A			0b1
.equ    KEY_B			0b10
.equ    KEY_C			0b100
.equ    KEY_UP			0b1000
.equ    KEY_DOWN		0b10000
.equ    KEY_LEFT		0b100000
.equ    KEY_RIGHT		0b1000000
.equ    KEY_POWER		0b10000000

###Interrupts
#### INT #1 - #8
#primary enable
.equ	REG_EVENT1P		$20
.equ	INT1P_TIMER1OVERFLOW	0b1100
.equ	INT1P_TIMER2OVERFLOW	0b110000
.equ	INT1P_TIMER3OVERFLOW	0b11
.equ	INT1P_V			0b11000000
#secondary enable
.equ	REG_EVENT1S		$23
.equ	INT1S_TIMER3OVERFLOW    0b1 ##INT #8
.equ	INT1S_TIMER3OVERFLOW    0b10 ##INT #8
.equ	INT1S_TIMER1OVERFLOW    0b1000 ##INT #5
.equ	INT1S_TIMER2OVERFLOW    0b100000 ##INT #3
.equ	INT1S_VDRAW		0b1000000 ##INT #2
.equ	INT1S_VBLANK		0b10000000 ##INT #1

#### INT #15 - #22
#primary enable
.equ	REG_EVENT2P		$21
.equ	INT2P_KEYPAD		0b1100 ##INT #15 - #22
#secondary enable
.equ	REG_EVENT2S		$25
.equ	INT2S_KEY_A		0b1
.equ	INT2S_KEY_B		0b10
.equ	INT2S_KEY_C		0b100
.equ	INT2S_KEY_UP		0b1000
.equ	INT2S_KEY_DOWN		0b10000
.equ	INT2S_KEY_LEFT		0b100000
.equ	INT2S_KEY_RIGHT		0b1000000
.equ	INT2S_KEY_POWER		0b10000000
.equ	INT2S_KEY_DPAD		0b01111000


### INTERRUPT FLAG (IF register)
#### INT #1 - #8
.equ	REG_INT_FLAG1		$27
.equ	IF_TIMER3OVERFLOW	0b1
.equ	IF_TIMER3OVERFLOW	0b10
.equ	IF_TIMER1OVERFLOW	0b1000
.equ	IF_TIMER2OVERFLOW	0b100000
.equ	IF_VDRAW		0b1000000
.equ	IF_VBLANK		0b10000000

#### INT #15 - #22
.equ	REG_INT_FLAG2		$29
.equ	IF_KEY_A		0b1
.equ	IF_KEY_B		0b10
.equ	IF_KEY_C		0b100
.equ	IF_KEY_UP		0b1000
.equ	IF_KEY_DOWN		0b10000
.equ	IF_KEY_LEFT		0b100000
.equ	IF_KEY_RIGHT		0b1000000
.equ	IF_KEY_POWER		0b10000000