/**************************************************************************
 * FreeDOS32 File System Layer                                            *
 * Wrappers for file system driver functions, SFT and JFT support         *
 * by Salvo Isaja                                                         *
 *                                                                        *
 * Copyright (C) 2002, Salvatore Isaja                                    *
 *                                                                        *
 * The FreeDOS32 File System Layer is part of FreeDOS32.                  *
 *                                                                        *
 * FreeDOS32 is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU General Public License as published by the  *
 * Free Software Foundation; either version 2 of the License, or (at your *
 * option) any later version.                                             *
 *                                                                        *
 * FreeDOS32 is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty                *
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the       *
 * GNU General Public License for more details.                           *
 *                                                                        *
 * You should have received a copy of the GNU General Public License      *
 * along with FreeDOS32; see the file COPYING; if not, write to the       *
 * Free Software Foundation, Inc.,                                        *
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA                *
 **************************************************************************/

#ifndef __FILESYS_H
#define __FILESYS_H

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* File and path names limits, in bytes, including the NULL terminator */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#define FD32_LFNPMAX 260 /* Max length for a long file name path  */
#define FD32_LFNMAX  255 /* Max length for a long file name       */
#define FD32_SFNPMAX 64  /* Max length for a short file name path */
#define FD32_SFNMAX  14  /* Max length for a short file name      */


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* OPEN system call - Flags for opening mode and action taken  */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/* Access codes */
#define FD32_OACCESS  0x0007    /* Bit mask for access type       */
#define FD32_OREAD    0x0000    /* Allow only reads from file     */
#define FD32_OWRITE   0x0001    /* Allow only writes into file    */
#define FD32_ORDWR    0x0002    /* Allow both reads and writes    */
#define FD32_ORDNA    0x0004    /* Read only without updating the */
                                /* last access date               */
/* Sharing modes and inheritance */
#define FD32_OSHARE   0x0070    /* Bit mask for sharing type      */
#define FD32_OCOMPAT  0x0000    /* Compatibility mode             */
#define FD32_ODENYRW  0x0010    /* Deny r/w by other handles      */
#define FD32_ODENYWR  0x0020    /* Deny write by other handles    */
#define FD32_ODENYRD  0x0030    /* Deny read by other handles     */
#define FD32_ODENYNO  0x0040    /* Allow full access by others    */
#define FD32_ONOINHER (1 << 7)  /* Child processes will not       */
                                /* inherit the file               */
/* Extended LFN open flags */
#define FD32_ONOBUFF  (1 << 8)  /* Do not use buffered I/O        */
#define FD32_ONOCOMPR (1 << 9)  /* Do not compress files (N/A)    */
#define FD32_OALIAS   (1 << 10) /* Use the numeric hint for alias */
#define FD32_ONOINT24 (1 << 13) /* Do not generate INT 24 on fail */
#define FD32_OCOMMIT  (1 << 14) /* Commit file at every write     */
/* Action to take */
#define FD32_OEXIST   (1 << 16) /* Open existing file             */
#define FD32_OTRUNC   (1 << 17) /* Truncate existing file         */
#define FD32_OCREAT   (1 << 20) /* Create unexisting file         */
#define FD32_ODIR     (1 << 24) /* Open a directory as a file     */
#define FD32_OFILEID  (1 << 25) /* Interpret *FileName as a fileid */


/* * * * * * * * * * * * * * * * * * * * * * * * */
/* CHMOD system call - Flags for file attributes */
/* * * * * * * * * * * * * * * * * * * * * * * * */
#define FD32_ARDONLY 0x01 /* Read only file                          */
#define FD32_AHIDDEN 0x02 /* Hidden file                             */
#define FD32_ASYSTEM 0x04 /* System file                             */
#define FD32_AVOLID  0x08 /* Volume label                            */
#define FD32_ADIR    0x10 /* Directory                               */
#define FD32_AARCHIV 0x20 /* File modified since last backup         */
#define FD32_ALNGNAM 0x0F /* Long file name directory slot (R+H+S+V) */
#define FD32_AALL    0x3F /* Select all attributes                   */
#define FD32_ANONE   0x00 /* Select no attributes                    */


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* Search flags for FINDFIRST/FINDNEXT and UNLINK system calls */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/* Allowable attributes */
#define FD32_FALLOW   0x00FF /* Allowable attributes mask */
#define FD32_FARDONLY FD32_ARDONLY
#define FD32_FAHIDDEN FD32_AHIDDEN
#define FD32_FASYSTEM FD32_ASYSTEM
#define FD32_FAVOLID  FD32_AVOLID
#define FD32_FADIR    FD32_ADIR
#define FD32_FAARCHIV FD32_AARCHIV
#define FD32_FAALL    FD32_AALL
#define FD32_FANONE   FD32_ANONE
/* Required attributes */
#define FD32_FREQUIRD 0xFF00 /* Allowable attributes mask */
#define FD32_FRRDONLY (FD32_ARDONLY << 8)
#define FD32_FRHIDDEN (FD32_AHIDDEN << 8)
#define FD32_FRSYSTEM (FD32_ASYSTEM << 8)
#define FD32_FRVOLID  (FD32_AVOLID  << 8)
#define FD32_FRDIR    (FD32_ADIR    << 8)
#define FD32_FRARCHIV (FD32_AARCHIV << 8)
#define FD32_FRALL    (FD32_AALL    << 8)
#define FD32_FRNONE   (FD32_ANONE   << 8)
/* Other search flags */
#define FD32_FDOSDATE (1 << 16) /* Use DOS date and time format */
#define FD32_FWILDCRD (1 << 17) /* Allow wildcards              */

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* GEN_SHORT_FNAME system call - Mnemonics for flags and return values */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* TODO: Pack these huge mnemonics... */
#define FD32_GENSFN_FORMAT_MASK   (0xFF << 8)
#define FD32_GENSFN_FORMAT_FCB    (0x00 << 8)
#define FD32_GENSFN_FORMAT_NORMAL (0x01 << 8)

#define FD32_GENSFN_CASE_CHANGED  (1 << 0)
#define FD32_GENSFN_WAS_INVALID   (1 << 1)


int  fd32_expand_fcb_name  (char *Dest, BYTE *Source);

// This doesn't belong here... Who cares anyway?
enum
{
  FD32_OROPEN  = 1, /* File has been opened    */
  FD32_ORCREAT = 2, /* File has been created   */
  FD32_ORTRUNC = 3  /* File has been truncated */
};

enum
{
  FD32_SEEKSET = 0, /* Seek from the beginning of the file */
  FD32_SEEKCUR = 1, /* Seek from the current file position */
  FD32_SEEKEND = 2  /* Seek from the end of file           */
};



#endif
