#ifndef __FD32_ERRORS_H
#define __FD32_ERRORS_H

#define FD32_E(x)            (-(x))

#define FD32_EPERM           FD32_E(    1)      /* Operation not permitted */
#define FD32_ENOENT          FD32_E(    2)      /* No such file or directory */
#define FD32_ESRCH           FD32_E(    3)      /* No such process */
#define FD32_EINTR           FD32_E(    4)      /* Interrupted system call */
#define FD32_EIO             FD32_E(    5)      /* I/O error */
#define FD32_ENXIO           FD32_E(    6)      /* No such device or address */
#define FD32_E2BIG           FD32_E(    7)      /* Argument list too long */
#define FD32_ENOEXEC         FD32_E(    8)      /* Exec format error */
#define FD32_EBADF           FD32_E(    9)      /* Bad file number */
#define FD32_ECHILD          FD32_E(   10)      /* No child processes */
#define FD32_EAGAIN          FD32_E(   11)      /* Try again */
#define FD32_ENOMEM          FD32_E(   12)      /* Out of memory */
#define FD32_EACCES          FD32_E(   13)      /* Permission denied */
#define FD32_EFAULT          FD32_E(   14)      /* Bad address */
#define FD32_ENOTBLK         FD32_E(   15)      /* Block device required */
#define FD32_EBUSY           FD32_E(   16)      /* Device or resource busy */
#define FD32_EEXIST          FD32_E(   17)      /* File exists */
#define FD32_EXDEV           FD32_E(   18)      /* Cross-device link */
#define FD32_ENODEV          FD32_EBUSY         /* No such device */
#define FD32_ENOTDIR         FD32_E(   20)      /* Not a directory */
#define FD32_EISDIR          FD32_E(   21)      /* Is a directory */
#define FD32_EINVAL          FD32_E(   22)      /* Invalid argument */
#define FD32_ENFILE          FD32_E(   23)      /* File table overflow */
#define FD32_ENMFILE         FD32_ENFILE
#define FD32_EMFILE          FD32_E(   24)      /* Too many open files */
#define FD32_ENOTTY          FD32_E(   25)      /* Not a typewriter */
#define FD32_ETXTBSY         FD32_E(   26)      /* Text file busy */
#define FD32_EFBIG           FD32_E(   27)      /* File too large */
#define FD32_ENOSPC          FD32_E(   28)      /* No space left on device */
#define FD32_ESPIPE          FD32_E(   29)      /* Illegal seek */
#define FD32_EISEEK          FD32_ESPIPE
#define FD32_EROFS           FD32_E(   30)      /* Read-only file system */
#define FD32_EMLINK          FD32_E(   31)      /* Too many links */
#define FD32_EPIPE           FD32_E(   32)      /* Broken pipe */
#define FD32_EDOM            FD32_E(   33)      /* Math argument out of domain of func */
#define FD32_ERANGE          FD32_E(   34)      /* Math result not representable */

#define FD32_ENOMEDIUM       FD32_E(  123)      /* No medium found */
#define FD32_EMEDIUMTYPE     FD32_E(  124)      /* Wrong medium type */
#define FD32_EMEDIA          FD32_EMEDIUMTYPE

#define FD32_EFORMAT         FD32_E(0x100)
#define FD32_EUTF8           FD32_E(0x101)
#define FD32_EUTF16          FD32_E(0x102)
#define FD32_EUTF32          FD32_E(0x103)
#define FD32_EGENERAL        FD32_E(0x104)
#define FD32_EACODE          FD32_E(0x105)
#if 0
/* Error codes */
#define FD32_E(x)     (-(x))
#define FD32_EINVAL   FD32_E(0x01) /* Invalid argument        */
#define FD32_ENOENT   FD32_E(0x02) /* (FIXME: file not found) No such file or directory */
#define FD32_ENOTDIR  FD32_E(0x03) /* (FIXME: path not found) Not a directory */
#define FD32_EMFILE   FD32_E(0x04) /* Too many open files     */
#define FD32_EACCES   FD32_E(0x05) /* Access denied           */
#define FD32_EBADF    FD32_E(0x06) /* Invalid file handle     */
#define FD32_ENOMEM   FD32_E(0x08) /* Insufficient memory     */
#define FD32_EFORMAT  FD32_E(0x0B) /* Format invalid          */
#define FD32_EACODE   FD32_E(0x0C) /* Access code invalid     */
#define FD32_EIDATA   FD32_E(0x0D) /* Data invalid            */
#define FD32_ENODRV   FD32_E(0x0F) /* Invalid drive           */
#define FD32_EBUSY    FD32_E(0x10) /* Attempt to remove the current directory */
#define FD32_EXDEV    FD32_E(0x11) /* Not same device         */
#define FD32_ENMFILE  FD32_E(0x12) /* No more files           */
#define FD32_EROFS    FD32_E(0x13) /* Read-only file system   */
#define FD32_ENODEV   FD32_E(0x14) /* No such device          */
#define FD32_ENOTRDY  FD32_E(0x15) /* Drive not ready         */
#define FD32_ECRC     FD32_E(0x17) /* CRC error               */
#define FD32_EISEEK   FD32_E(0x19) /* Invalid seek            */
#define FD32_EMEDIA   FD32_E(0x1A) /* Unknown media (not DOS) */
#define FD32_ENOSEC   FD32_E(0x1B) /* Sector not found        */
#define FD32_EWRITE   FD32_E(0x1D) /* Write fault             */
#define FD32_EREAD    FD32_E(0x1E) /* Read fault              */
#define FD32_EGENERAL FD32_E(0x1F) /* General failure         */
#define FD32_EVSHAR   FD32_E(0x20) /* Sharing violation       */
#define FD32_EVLOCK   FD32_E(0x21) /* Lock violation          */
#define FD32_ECHANGE  FD32_E(0x22) /* Invalid media change (ES:DI -> media ID structure)(see #1546) */
#define FD32_EOINPUT  FD32_E(0x26) /* Out of input            */
#define FD32_ENOSPC   FD32_E(0x27) /* No space left on drive  */
#define FD32_EEXIST   FD32_E(0x50) /* File exists             */
#define FD32_EMKDIR   FD32_E(0x52) /* Cannot make directory   */
#define FD32_EINT24   FD32_E(0x53) /* Fail on INT 24          */
#define FD32_ENOTLCK  FD32_E(0xB0) /* Not locked              */
#define FD32_ELOCKED  FD32_E(0xB1) /* Locked in drive         */
#define FD32_ENOTREM  FD32_E(0xB2) /* Media not removable     */
#define FD32_ENOLCK   FD32_E(0xB4) /* No more locks available */
#define FD32_EEJECT   FD32_E(0xB5) /* Eject request failed    */
/* FD32 defined error codes */
#define FD32_ENMOUNT  FD32_E(0x100) /* File system not mounted */
#define FD32_EUTF8    FD32_E(0x101) /* Invalid UTF-8 sequence  */
#define FD32_EUTF16   FD32_E(0x102) /* Invalid UTF-32 sequence */
#define FD32_EUTF32   FD32_E(0x103) /* Invalid Unicode char    */
#define FD32_ENMDEV   FD32_E(0x104) /* No more devices         */
#endif

#endif /* #ifndef __FD32_ERRORS_H */

