/**************************************************************************
 * FreeDOS 32 FAT Driver                                                  *
 * by Salvo Isaja                                                         *
 *                                                                        *
 * Copyright (C) 2001-2003, Salvatore Isaja                               *
 *                                                                        *
 * This is "blockio.c" - Services to access the hosting block device      *
 *                                                                        *
 *                                                                        *
 * This file is part of the FreeDOS 32 FAT Driver.                        *
 *                                                                        *
 * The FreeDOS 32 FAT Driver is free software; you can redistribute it    *
 * and/or modify it under the terms of the GNU General Public License     *
 * as published by the Free Software Foundation; either version 2 of the  *
 * License, or (at your option) any later version.                        *
 *                                                                        *
 * The FreeDOS 32 FAT Driver is distributed in the hope that it will be   *
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          *
 * GNU General Public License for more details.                           *
 *                                                                        *
 * You should have received a copy of the GNU General Public License      *
 * along with the FreeDOS 32 FAT Driver; see the file COPYING;            *
 * if not, write to the Free Software Foundation, Inc.,                   *
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA                *
 **************************************************************************/
 
#include "fat.h"

/* Define the DEBUG symbol in order to activate driver's log output */
#ifdef DEBUG
 #define LOG_PRINTF(s) fd32_log_printf s
#else
 #define LOG_PRINTF(s)
#endif

/* Buffer flags */
#define BUSED  0x1 /* Buffer has been used at least once */
#define BDIRTY 0x2 /* Buffer contains data to be written */

//#define BSIZE 4096

//#define ROUNDSEC(x) (((int)(x/(BSIZE/V->Bpb.BPB_BytsPerSec)))*(BSIZE/V->Bpb.BPB_BytsPerSec))
//#define BLOCKNUM(x) ((int)(x/(BSIZE/V->Bpb.BPB_BytsPerSec)))
//#define SECSPERBLOCK (BSIZE/V->Bpb.BPB_BytsPerSec)
//#define MAXSECSPERBLOCK (BSIZE/512)
extern int SECSPERBLOCK;
//#define SECSPERBLOCK V->NumBuffers 
#define ROUNDSEC(x) ((x/SECSPERBLOCK)*SECSPERBLOCK) 
//char tempbuffer[BSIZE];

/* Searches for a volume's buffer contaning the specified sector. */
/* Returns the buffer number on success, or -1 on failure.        */
/* Called by fat_readbuf.                                         */
static int search_for_buffer(DWORD Sector)
{
  int k;
  for (k = 0; k < V->NumBuffers; k++)
    if (V->Buffers[k].Flags & BUSED)
     
     if (Sector == V->Buffers[k].StartingSector) return k;

    
  return -1;
}


/* Returns the number of the least recently used volume's buffer. */
/* Called by fat_readbuf.                                         */
static int find_least_recently_used()
{
  int   k, Lru = 0;
  DWORD MinAccess = V->BufferAccess;
k = 0;
if(V->NumBuffers>SECSPERBLOCK) Lru=k=SECSPERBLOCK;
  // Lru=V->NumBuffers-1;

  for (; k < V->NumBuffers; k+=SECSPERBLOCK)
    /* Never used buffers have LastAccess == 0, so it works */
    if (V->Buffers[k].LastAccess < MinAccess)
    {
      MinAccess = V->Buffers[k].LastAccess;
      Lru       = k;
    }
  return Lru;
}


#ifdef FATWRITE
/* Writes the content of the specified buffer in the hosting block */
/* device, marking the buffer as not dirty.                        */
/* Returns 0 on success, or a negative error code on failure.      */
/* Called by fat_flushall and fat_readbuf.                         */
static int flush_buffer(int NumBuf)
{
  int               Res;
  //fd32_blockwrite_t Params;

  if (V->Buffers[NumBuf].Flags & BDIRTY)
  {/*
    Params.Size      = sizeof(fd32_blockwrite_t);
    Params.DeviceId  = V->BlkDev;
    Params.Start     = V->Buffers[NumBuf].StartingSector;
    Params.Buffer    = V->Buffers[NumBuf].Data;
    Params.NumBlocks = 1;
    Res = V->blkreq(FD32_BLOCKWRITE, &Params);*/
    Res = write_sectors(V->Buffers[NumBuf].Data,V->Buffers[NumBuf].StartingSector,1);
    if (Res < 0) return FD32_ENOMEDIUM;
    V->Buffers[NumBuf].Flags &= ~BDIRTY;
  }
  return 0;
}

static int flush_multi_buffer(int NumBuf,int numsects)
{
  int               Res;
  int n,m,ns,tsect;
if(NumBuf<0) return FD32_ENOMEDIUM;
while(numsects>0)
{
	if(NumBuf>=V->NumBuffers) break;

	m=SECSPERBLOCK;
	n=ns=(NumBuf % SECSPERBLOCK);
	if((m-n)>numsects) m=n+numsects;
	tsect=ROUNDSEC(V->Buffers[NumBuf].StartingSector);
	for(;n<m;n++)
	{
	if(tsect!=ROUNDSEC(V->Buffers[NumBuf].StartingSector)) break;
	if (!(V->Buffers[ROUNDSEC(NumBuf)+n].Flags & BDIRTY)) break;
	}
    ns=n-ns; // esto es cero si no hay sectores dirty, en ese caso saltamos un sector

	if(ns>0)
	{
	Res = write_sectors(V->Buffers[NumBuf].Data,V->Buffers[NumBuf].StartingSector,ns);
    if (Res < 0) return FD32_ENOMEDIUM;
	for(n=(NumBuf % SECSPERBLOCK);n<m;n++)
	{
	V->Buffers[ROUNDSEC(NumBuf)+n].Flags &= ~BDIRTY; // borra el flag dirty
	}
	NumBuf+=ns;numsects-=ns;
	}
	else {NumBuf++;numsects--;}


	
}

  return 0;
}




/* Flushes all buffers of the specified volume, calling flush_buffer. */
/* Returns 0 on success, or a negative error code on failure.         */
/* Called by fat_fflush (open.c) and fat_write (readwrit.c).          */
int fat_flushall()
{
  int k, Res;
  /* Update FSI_Free_Count and FSI_Nxt_Free in the FAT32 FSInfo sector */
  if (V->FatType == FAT32)
  {
    if ((Res = fat_readbuf(1)) < 0) return Res;
    ((tFSInfo *) V->Buffers[Res].Data)->Free_Count = V->FSI_Free_Count;
    ((tFSInfo *) V->Buffers[Res].Data)->Nxt_Free   = V->FSI_Nxt_Free;
    if ((Res = fat_writebuf(Res)) < 0) return Res;
  }
  /* Flush all volume's buffers */
 /* for (k = 0; k < V->NumBuffers; k++)
  {
    Res = flush_buffer(k);
    if (Res) return Res;
  }*/
  Res = flush_multi_buffer(0,V->NumBuffers);
  if (Res) return Res;
  return 0;
}


/* If buffers are enabled, it just marks a buffer as dirty.              */
/* If buffers are disabled, writes a buffer to the hosting block device. */
/* Returns 0 on success, or a negative error code on failure.            */
int fat_writebuf(int NumBuf)
{
  #ifdef FATBUFFERS
  V->Buffers[NumBuf].Flags |= BDIRTY;
  return 0;
  #else
  int               Res;
  //fd32_blockwrite_t Params;
/*
  Params.Size      = sizeof(fd32_blockwrite_t);
  Params.DeviceId  = V->BlkDev;
  Params.Start     = V->Buffers[NumBuf].StartingSector;
  Params.Buffer    = V->Buffers[NumBuf].Data;
  Params.NumBlocks = 1;
  Res = V->blkreq(FD32_BLOCKWRITE, &Params);*/
  Res = write_sectors(V->Buffers[NumBuf].Data,V->Buffers[NumBuf].StartingSector,1);
  if (Res < 0) return FD32_ENOMEDIUM;
  return 0;
  #endif
}
#endif


/* Performs a buffered read from the hosting block device.       */
/* If the required sector is not already buffered, flushes the   */
/* least recently used buffer and uses it to load in the sector. */
/* Puts the buffer number in NumBuf.                             */
/* Returns zero on success, or a negative error code on failure. */
/* Called by fat??_read_entry and fat??_write_entry in fat??.c,  */
/* fat_read and fat_write in readwrit.c.                         */

/* Performs a buffered read from the hosting block device.       */
/* If the required sector is not already buffered, flushes the   */
/* least recently used buffer and uses it to load in the sector. */
/* Puts the buffer number in NumBuf.                             */
/* Returns zero on success, or a negative error code on failure. */
/* Called by fat??_read_entry and fat??_write_entry in fat??.c,  */
/* fat_read and fat_write in readwrit.c.         */


int fat_readbuf2(DWORD Sector,int access)
{
  int              Res;
  int              i;
  int              spb;
  int              ActualBuf;
  int n;
 
  if ((ActualBuf = search_for_buffer(Sector)) == -1)
  {//1
    spb=SECSPERBLOCK;
    if((ROUNDSEC(Sector)+spb)>get_totalblocks()) 
	{
      spb=get_totalblocks()-ROUNDSEC(Sector);
    }
    V->BufferMiss++;
	
    if(access!=0) n=0;
	else
	n=find_least_recently_used();
	n=(n/SECSPERBLOCK)*SECSPERBLOCK;
	ActualBuf=n+Sector-ROUNDSEC(Sector);
	if(ActualBuf<0) {
      return FD32_EGENERAL;
	}
     // flush the buffers to be  reasigned
	 #ifdef FATWRITE
	 /*for(i=0;i<SECSPERBLOCK;i++) 
		{//2
		Res = flush_buffer(n+i);
        if (Res < 0) return Res;
		}//2*/
     Res = flush_multi_buffer(n,SECSPERBLOCK);
     if (Res < 0) return Res;
	#endif

    Res = read_sectors(V->Buffers[n].Data/*tempbuffer*/,ROUNDSEC(Sector),spb);
   
    if (Res < 0) {
      return FD32_ENOMEDIUM;
    }
V->BufferAccess++;
    for(i=0;i<SECSPERBLOCK;i++) 
		{
		//V->BufferAccess++;
		//V->Buffers[n+i].LastAccess = V->BufferAccess;
      if(i<spb) {
		  
		V->Buffers[n+i].LastAccess = V->BufferAccess;
		   // error en buffer
        V->Buffers[n+i].StartingSector = ROUNDSEC(Sector)+i;
        V->Buffers[n+i].Flags = BUSED;
//        memcpy(V->Buffers[NumBuf[i]].Data, &tempbuffer[i*V->Bpb.BPB_BytsPerSec], V->Bpb.BPB_BytsPerSec);
          } else V->Buffers[n+i].Flags=0;
     }
   
  } //1
  else
  {
    V->BufferHit++;
	V->BufferAccess++;
	V->Buffers[ActualBuf].LastAccess =V->BufferAccess;

  }
  
  return ActualBuf;
}
int fat_readbuf(DWORD Sector)
{
return fat_readbuf2(Sector,0);
}

#if 0

int fat_readbuf2(DWORD Sector)
{
  int              Res;
  int              NumBuf[MAXSECSPERBLOCK];
  //int              RealLastAccess[MAXSECSPERBLOCK];
  int              i;
  int              spb;
  int              ActualBuf;
  //fd32_blockread_t Params;
  if ((ActualBuf = search_for_buffer(Sector)) == -1)
  {
    spb=SECSPERBLOCK;
    if((ROUNDSEC(Sector)+spb)>get_totalblocks()) {
      spb=get_totalblocks()-ROUNDSEC(Sector);
    }
    V->BufferMiss++;
    for(i=0;i<spb;i++) {
      if((ROUNDSEC(Sector)+i)==Sector) ActualBuf=i;
      if(search_for_buffer(ROUNDSEC(Sector)+i)!=-1) {
        NumBuf[i]=-1;
      } else {
        NumBuf[i] = find_least_recently_used();
        V->Buffers[NumBuf[i]].LastAccess = ++V->BufferAccess;
        #ifdef FATWRITE
        Res = flush_buffer(NumBuf[i]);
        if (Res < 0) return Res;
        #endif
      }
    }
    if(ActualBuf==-1) {
      return FD32_EGENERAL;
    }
    //printf(" Sector=%d spb=%d SECSPERBLOCK=%d ActualBuf=%d NumBuf[ActualBuf]=%d ROUNDSEC(Sector)=%d bps=%d BSIZE=%d...",
      //Sector, spb, SECSPERBLOCK, ActualBuf, NumBuf[ActualBuf], ROUNDSEC(Sector), V->Bpb.BPB_BytsPerSec, BSIZE);

    
    /*
    Params.Size      = sizeof(fd32_blockread_t);
    Params.DeviceId  = V->BlkDev;
    Params.Start     = Sector;
    Params.Buffer    = V->Buffers[NumBuf].Data;
    Params.NumBlocks = 1;
    Res = V->blkreq(FD32_BLOCKREAD, &Params);*/
    Res = read_sectors(tempbuffer,ROUNDSEC(Sector),spb);
    //Res = read_sectors(V->Buffers[NumBuf].Data,Sector,1);
    if (Res < 0) {
      return FD32_ENOMEDIUM;
    }
    for(i=0;i<spb;i++) {
      if(NumBuf[i] != -1) {
        V->Buffers[NumBuf[i]].StartingSector = ROUNDSEC(Sector)+i;
        V->Buffers[NumBuf[i]].Flags |= BUSED;
        memcpy(V->Buffers[NumBuf[i]].Data, &tempbuffer[i*V->Bpb.BPB_BytsPerSec], V->Bpb.BPB_BytsPerSec);
      }
    }
    ActualBuf=NumBuf[ActualBuf];
  }
  else
  {
    V->BufferHit++;
  }
  V->Buffers[ActualBuf].LastAccess = ++V->BufferAccess;

  return ActualBuf;
}
#endif