
#include "aica.h"

/****************** Timer *******************************************/

void aica_init();
void aica_play(int ch, unsigned long smpptr, int mode, int loopst, int loopend,
		int freq, int vol, int pan, int loopflag);
void aica_stop(int ch);

extern volatile int timer;

void timer_wait(int jiffies) {
	int fin = timer + jiffies;
	while (timer <= fin)
		;
}

/****************** Main Program ************************************/

volatile unsigned long *start  = (volatile unsigned long*)0x10000;
volatile unsigned long *quit  = (volatile unsigned long*)0x10010;
volatile unsigned long *position  = (volatile unsigned long*)0x10014;

int arm_main() {

	unsigned long stop_sound;
	
	/* Initialize the AICA part of the SPU */
	aica_init();

	/* Observe channel 0 */
	SNDREG8(0x280d) = 0;

	*quit = 0;
	*start = 0;

	while (!*start) {
		timer_wait (10);
	}

	aica_play (0, 0x11000, SM_16BIT, 0, (735 * 4), 44100, 0xaf, 128, 1);

	while (1) {

		*position = SNDREG32(0x2814);

		stop_sound = *quit;

		if (stop_sound) {
			aica_stop (0);
			*quit = 0;
		}

		timer_wait (10);
	
	}

	return 0;

}






