/*
** nester - NES emulator
** Copyright (C) 2000  Darren Ranalli
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful, 
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
** Library General Public License for more details.  To obtain a 
** copy of the GNU Library General Public License, write to the Free 
** Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
** Any permitted reproduction of these routines, in whole or in part,
** must bear this legend.
*/

/* 
** NesterDC by Ken Friece
** Any changes that I made to the original source, by Darrin Ranalli, are 
** marked with in the following way:
** KF DD/MM/YYYY <description of the change> 
*/

#ifndef SETTINGS_H_
#define SETTINGS_H_

#include "libc.h" // KF 05/31/2001 added include
#include "stdlib.h" // KF 05/31/2001 added include
//#include <stdlib.h> // KF 05/31/2001 commented out line
//#include <string.h> // KF 05/31/2001 commented out line

#include "debug.h"
#include "NES_settings.h"
#include "recent.h"
#include "version.h"

const int _MAX_PATH = 50; // KF 05/31/2001 added _MAX_PATH

class settings_t
{
public:
  NES_settings nes;
  recent_list recent_ROMs;
  char OpenPath[_MAX_PATH];
  char* version;

  boolean Save();
  boolean Load();

  settings_t()
  {
    version = NESTER_VERSION;
    strcpy(OpenPath, ".");
  }
};

extern settings_t NESTER_settings;

// THESE MUST BE DEFINED PER OS
//extern boolean OSD_LoadSettings(class settings_t& settings); // KF 05/31/2001 commented out
//extern boolean OSD_SaveSettings(class settings_t& settings); // KF 05/31/2001 commented out
 
#endif
