/*
** nester - NES emulator
** Copyright (C) 2000  Darren Ranalli
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful, 
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
** Library General Public License for more details.  To obtain a 
** copy of the GNU Library General Public License, write to the Free 
** Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
** Any permitted reproduction of these routines, in whole or in part,
** must bear this legend.
*/

/* 
** NesterDC by Ken Friece
** Any changes that I made to the original source, by Darrin Ranalli, are 
** marked with in the following way:
** KF DD/MM/YYYY <description of the change> 
*/

#ifndef RECENT_H_
#define RECENT_H_

#include "libc.h" // KF 05/31/2001 added include
#include "stdlib.h" // KF 05/31/2001 added include
//#include <stdlib.h> // KF 05/31/2001 commented out include

const int _MAX_PATH_2 = 50; // KF 05/31/2001 added _MAX_PATH_2

class recent_list
{
public:
  enum {
    MAX_ENTRIES = 10,
    ENTRY_LEN   = _MAX_PATH_2 // KF 05/31/2001 changed _MAX_PATH to _MAX_PATH_2
  };

  recent_list();
  ~recent_list();

  int get_num_entries() const;
  void clear();

  int get_max_entry_len() const { return ENTRY_LEN-1; }
  int get_max_entries() const { return MAX_ENTRIES; }

  const char* get_entry(int index) const;
  void add_entry(const char* filename);
  void remove_entry(int index);

protected:
  char entries[MAX_ENTRIES][ENTRY_LEN];
  int num_entries;

private:
};

#endif
