/*
** nester - NES emulator
** Copyright (C) 2000  Darren Ranalli
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful, 
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
** Library General Public License for more details.  To obtain a 
** copy of the GNU Library General Public License, write to the Free 
** Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
** Any permitted reproduction of these routines, in whole or in part,
** must bear this legend.
*/

/* 
** NesterDC by Ken Friece
** Any changes that I made to the original source, by Darrin Ranalli, are 
** marked with in the following way:
** KF DD/MM/YYYY <description of the change> 
*/

#ifndef _NULL_SOUND_MGR_H_
#define _NULL_SOUND_MGR_H_

#include "sound_mgr.h"

class null_sound_mgr : public sound_mgr
{
public:
	null_sound_mgr() : sound_mgr(11025,3) {} // KF 05/31/2001 change inputs to sound_mgr
  ~null_sound_mgr() {}

  void reset() {}  

  // lock down for a period of inactivity
  void freeze() {}
  void thaw() {}

  void clear_buffer() {}

  boolean lock(sound_buf_pos which, void** buf, uint32* buf_len) { return FALSE; }
  void unlock() {}

  int get_buffer_len()  { return 0; }

  // returns SOUND_BUF_LOW or SOUND_BUF_HIGH
  sound_buf_pos get_currently_playing_half() { return SOUND_BUF_LOW; }

  boolean IsNull() { return FALSE; } // KF 05/31/2001 return FALSE instead of TRUE
};

#endif
