/*
** nester - NES emulator
** Copyright (C) 2000  Darren Ranalli
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful, 
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
** Library General Public License for more details.  To obtain a 
** copy of the GNU Library General Public License, write to the Free 
** Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
** Any permitted reproduction of these routines, in whole or in part,
** must bear this legend.
*/

/* 
** NesterDC by Ken Friece
** Any changes that I made to the original source are 
** marked with in the following way:
** KF DD/MM/YYYY <description of the change> 
*/

#ifndef NES_SETTINGS_H_
#define NES_SETTINGS_H_

#include "types.h"

//#include "OSD_NES_graphics_settings.h" // KF 06/03/2001 commented out line
//#include "OSD_ButtonSettings.h" // KF 06/03/2001 commented out line

class NES_preferences_settings
{
public:
  boolean run_in_background;
  boolean speed_throttling;
  boolean auto_frameskip;
  enum NES_PRIORITY { PRI_NORMAL=0, PRI_HIGH=1, PRI_REALTIME=2 };
  NES_PRIORITY priority;

  void SetDefaults()
  {
    run_in_background = FALSE;
    speed_throttling = TRUE;
    auto_frameskip = TRUE;
    priority = PRI_HIGH;
  }

  NES_preferences_settings()
  {
    SetDefaults();
  }
};

class NES_graphics_settings
{
public:
  boolean black_and_white;
  boolean show_more_than_8_sprites;
  boolean show_all_scanlines;
  boolean draw_overscan;
  boolean fullscreen_on_load;
  boolean fullscreen_scaling;
  boolean calculate_palette;
  uint8 tint;
  uint8 hue;
  //OSD_NES_graphics_settings osd; // KF 06/03/2001 commented out line

  void reset_palette()
  {
    tint = 0x86;
    hue  = 0x9d;
  }

  void SetDefaults()
  {
    black_and_white = FALSE;
    show_more_than_8_sprites = FALSE;
    show_all_scanlines = FALSE;
    draw_overscan = FALSE;
    fullscreen_on_load = FALSE;
    fullscreen_scaling = FALSE;
    calculate_palette = FALSE;
    reset_palette();
    //osd.Init(); // KF 06/03/2001 commented out line
  }

  NES_graphics_settings()
  {
    SetDefaults();
  }
};

class NES_sound_settings
{
public:
  uint32 enabled; // KF 06/03/2001 changed type from boolean to uint32
  uint32 sample_rate;
  uint32 sample_size;

  uint32 rectangle1_enabled; // KF 06/03/2001 changed type from boolean to uint32
  uint32 rectangle2_enabled; // KF 06/03/2001 changed type from boolean to uint32
  uint32 triangle_enabled; // KF 06/03/2001 changed type from boolean to uint32
  uint32 noise_enabled; // KF 06/03/2001 changed type from boolean to uint32
  uint32 dpcm_enabled; // KF 06/03/2001 changed type from boolean to uint32
  uint32 external_enabled; // KF 06/03/2001 changed type from boolean to uint32

  enum { LENGTH_MIN = 1, LENGTH_MAX = 10 };
  uint32 buffer_len;

  enum filter_type_t { FILTER_NONE, FILTER_LOWPASS, FILTER_LOWPASS_WEIGHTED };
  filter_type_t filter_type;

  void SetDefaults()
  {
    enabled = TRUE;
    sample_rate = 44100;
    sample_size = 8;
    buffer_len = 3;

    filter_type = FILTER_LOWPASS_WEIGHTED;

    rectangle1_enabled = TRUE;
    rectangle2_enabled = TRUE;
    triangle_enabled = TRUE;
    noise_enabled = TRUE;
    dpcm_enabled = TRUE;
    external_enabled = TRUE;
  }

  NES_sound_settings()
  {
    SetDefaults();
  }
};

class NES_controller_input_settings
{
public:
  //OSD_ButtonSettings btnUp; // KF 06/03/2001 commented out line
//	OSD_ButtonSettings btnDown; // KF 06/03/2001 commented out line
//	OSD_ButtonSettings btnLeft; // KF 06/03/2001 commented out line
//	OSD_ButtonSettings btnRight; // KF 06/03/2001 commented out line
//	OSD_ButtonSettings btnSelect; // KF 06/03/2001 commented out line
//	OSD_ButtonSettings btnStart; // KF 06/03/2001 commented out line
//	OSD_ButtonSettings btnB; // KF 06/03/2001 commented out line
//	OSD_ButtonSettings btnA; // KF 06/03/2001 commented out line

  // OS-specific
 // void OSD_SetDefaults(int num); // 0 == first player // KF 06/03/2001 commented out line

  void Clear()
  {
  //  btnUp.Clear(); // KF 06/03/2001 commented out line
  //  btnDown.Clear(); // KF 06/03/2001 commented out line
  //  btnLeft.Clear(); // KF 06/03/2001 commented out line
  //  btnRight.Clear(); // KF 06/03/2001 commented out line
  //  btnSelect.Clear(); // KF 06/03/2001 commented out line
  //  btnStart.Clear(); // KF 06/03/2001 commented out line
  //  btnB.Clear(); // KF 06/03/2001 commented out line
  //  btnA.Clear(); // KF 06/03/2001 commented out line
  }

  NES_controller_input_settings(int num)
  {
    Clear();
//    OSD_SetDefaults(num); // KF 06/03/2001 commented out line
  }
};

class NES_input_settings
{
public:
  NES_controller_input_settings player1;
  NES_controller_input_settings player2;

  void SetDefaults()
  {
    player1.Clear();
    player2.Clear();
  //  player1.OSD_SetDefaults(0); // KF 06/03/2001 commented out line
  //  player2.OSD_SetDefaults(1); // KF 06/03/2001 commented out line
  }

  NES_input_settings() : player1(0), player2(1)
  {
  }
};

class NES_settings
{
public:
  NES_preferences_settings  preferences;
  NES_graphics_settings     graphics;
  NES_sound_settings        sound;
  NES_input_settings        input;

  NES_settings() : preferences(), graphics(), sound(), input()
  {
  }
};

#endif
