/*
** nester - NES emulator
** Copyright (C) 2000  Darren Ranalli
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful, 
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
** Library General Public License for more details.  To obtain a 
** copy of the GNU Library General Public License, write to the Free 
** Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
** Any permitted reproduction of these routines, in whole or in part,
** must bear this legend.
*/

/* 
** NesterDC by Ken Friece
** Any changes that I made to the original source, by Darrin Ranalli, are 
** marked with in the following way:
** KF DD/MM/YYYY <description of the change> 
*/

#ifndef _EMULATOR_H_
#define _EMULATOR_H_

#include "stdlib.h" // KF 05/31/2001 added include
#include "libc.h" // KF 05/31/2001 added include
//#include <stdio.h> // KF 05/31/2001 commented out include
#include "types.h"
#include "screen_mgr.h"
#include "sound_mgr.h"
#include "controller.h"

class emulator
{
public:
  emulator(const char* ROM_name = (const char *)NULL) {}; // KF 05/31/2001 type cast null
  virtual ~emulator() {};

  virtual const char* getROMname() = 0; // returns ROM name without extension
  virtual const char* getROMpath() = 0;

  virtual boolean loadState(const char* fn) = 0;
  virtual boolean saveState(const char* fn) = 0;

//  virtual boolean emulate_frame(boolean draw) = 0; // KF 05/31/2001 commented out routine
  virtual void emulate_frame(uint8) = 0; // KF 05/31/2001 changed input parameter, see above
  virtual void emulate_frame_skip(uint8) = 0; // KF 05/31/2001 added routine

  virtual void reset() = 0;

  virtual void set_pad1(controller* c) {}
  virtual void set_pad2(controller* c) {}

  virtual void input_settings_changed() {}

  // sound
  virtual void enable_sound(boolean enable) {};
  virtual boolean sound_enabled() { return FALSE; };
  virtual boolean set_sample_rate(int sample_rate) { return FALSE; };
  virtual int get_sample_rate() { return 0; };

  // freeze() is called when the emulator should
  // shut down for a period of inactivity;
  virtual void freeze() = 0;
  // thaw() signals the end of the inactive period
  virtual void thaw()   = 0;

  virtual boolean frozen() = 0;

protected:
private:
};

#endif
