/*
** NesterDC - NES emulator for Dreamcast
** Ken Friece
** These routines were heavily influenced by 
** the vmu example that comes with libdream.
** A lot of great vmu info can be found here:
** http://mc.pp.se/dc/sw.html
*/

#ifndef _VMU_H
#define _VMU_H

// The dirent_vmu and file_hdr_vmu types came from 
// vmuload01.0 (file dciwrap.c) by Dan Potter
// Original code can be found on this site:
// http://dcdev.allusion.net/softprj/
 
/* VMU Directory Entry */
typedef struct {
	uint8	filetype;	/* 0x00 = no file; 0x33 = data; 0xcc = a game */
	uint8	copyprotect;	/* 0x00 = copyable; 0xff = copy protected */
	uint16	firstblk;	/* location of the first block in the file */
	char	filename[12];	/* there is no null terminator */
	uint8	cent;		/* these are all file creation date stuff, in BCD format */
	uint8	year;
	uint8	month;
	uint8	day;
	uint8	hour;
	uint8	min;
	uint8	sec;
	uint8	dow;		/* day of week (0 = monday, etc) */
	uint16	filesize;	/* size of the file in blocks */
	uint16	hdroff;		/* offset of header, in blocks from start of file */
	char	dummys[4];	/* unused */
} dirent_vmu;

/* ROM menu header */
typedef struct {
	char	desc_short[16];
	char	desc_long[32];
	char	app_id[16];
	uint16	icon_cnt;
	uint16	eyecatch_type;
	uint16	crc;
	uint32	file_bytes;
	char	reserved[20];
	uint16	palette[16];
	uint8	icon_bitmap[32*32/8];
} file_hdr_vmu;

typedef struct {
	uint8	cont_scheme;
	uint8	frame_skip;
	uint8	sound_on;
	uint8	player_2;
	uint8	save;
} user_settings;

extern user_settings settings;

uint16 calcCRC(const unsigned char *buf, int size);

uint16 get_next_block_from_fat (uint16 block_number);

uint16 check_vmu_for_game (const char* game_name);

void update_fat (uint8 *free_mem, uint8 blocks_left);

void upload_vmu_data (uint8 *vmu_file, uint8 *free_mem, uint8 blocks_left);

void upload_data_by_block (uint8 *vmu_file, uint16 block_number, uint8 blocks_left);

void update_vmu_dir (uint16 block, const char *filename, uint8 blocks);

void do_crc (uint8 *buffer, uint16 bytes);

uint8 check_free_blocks (uint8 *free_mem);

uint16 find_first_free_block (uint8 *fat_table);

void create_dir_vmu (dirent_vmu *dir_entry, const char *rom_name, uint16 first_free_block, uint8 blocks);

void create_vmu_header(uint8 *header, const char *rom_name, const char *desc_long, uint16 filesize);

void vmu_icon_draw(const char *vmu_icon, uint8 vmu);

void check_user_settings(uint8 vmu_mem1);

void save_user_settings(uint8 vmu_mem1);

#endif
