#ifndef _STDLIB_H
#define _STDLIB_H

#include <stdarg.h>
//#include "libc.h"
#include "dream.h"
//#include "cdrom.h"

#ifndef __LIBC_H
#define __LIBC_H

#define true (1)
#define false (0)

#ifndef NULL
#define NULL ((void*)0)
#endif
#define size_t unsigned int
#endif

// A blank atexit() function to let you call your main, main()
void atexit();

void free (void *);

unsigned long simple_strtoul(const char *cp,char **endp,unsigned int base);

/*static int skip_atoi(const char **s);

static char * number(char * str, long num, int base, int size, int precision
	,int type);*/

int vsprintf(char *buf, const char *fmt, va_list args);

int sprintf(char * buf, const char *fmt, ...);
// strings

void *malloc(unsigned int size);

//char * ___strtok = (char *)NULL;

char * strcpy(char * dest,const char *src);

char * strncpy(char * dest,const char *src,size_t count);

char * strcat(char * dest, const char * src);

char * strncat(char *dest, const char *src, size_t count);

int strcmp(const char * cs,const char * ct);

int strncmp(const char * cs,const char * ct,size_t count);

char * strchr(const char * s, int c);

char * strrchr(const char * s, int c);

size_t strlen(const char * s);

size_t strnlen(const char * s, size_t count);

size_t strspn(const char *s, const char *accept);

char * strpbrk(const char * cs,const char * ct);

char * strtok(char * s,const char * ct);

void * memset(void * s,int c,size_t count);

void * memset16(void * s,uint16 c,size_t count);

void * memset32(void * s,uint32 c,size_t count);

char * bcopy(const char * src, char * dest, int count);

void * memcpy(void * dest,const void *src,size_t count);

void * memmove(void * dest,const void *src,size_t count);

int memcmp(const void * cs,const void * ct,size_t count);

/*
 * find the first occurrence of byte 'c', or 1 past the area if none
 */
void * memscan(void * addr, int c, size_t size);

char * strstr(const char * s1,const char * s2);

typedef int FILE;

enum SEEKS {seek_set, seek_cur, seek_end};

FILE* fopen (const char * filename, const char * mode);

size_t fwrite ( const void * buffer, size_t size, size_t count, FILE * stream );

long int fseek ( FILE * stream , long offset , int origin );

int  fclose (FILE * stream);

long int ftell ( FILE * stream );

int  fread (void * buffer, size_t size, size_t count, FILE * stream);

void dc_print (char * stri);

void print_uint32 (uint32 val);

void print_num (uint32 val, uint32 xval, uint32 yval);

void dc_print_opcode (uint8 opcode);

void dc_sleep (uint32 time);

#endif
