/*
** NesterDC - NES emulator for Dreamcast
** Copyright (C) 2001  Ken Friece
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful, 
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
** Library General Public License for more details.  To obtain a 
** copy of the GNU Library General Public License, write to the Free 
** Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
** Any permitted reproduction of these routines, in whole or in part,
** must bear this legend.
*/

#include "shapes.h"

void drawbox(int xpos, int ypos, int width, int height, unsigned short red, unsigned short green, unsigned short blue) {

	for (int y = ypos; y < (ypos + height); y++) {
		for (int x = xpos; x < (xpos + width); x++) {
			vram_s[y * 320 + x] = ((red >> 3) << 11)
								| ((green >> 2) << 5)
								| ((blue >> 3) << 0);
		}
	}
}

void draw_circle (int xcenter, int ycenter, int radius, int color) {
		
	float distance;
	int x_dist, y_dist;
	int start_x = xcenter - radius - 1;
	int start_y = ycenter - radius - 1;
	int end_x = xcenter + radius + 1;
	int end_y = xcenter + radius + 1;

	for (int y = start_y; y < end_y; y++) {
		y_dist = ycenter - y;
		
		for (int x = start_x; x < end_x; x++) {	
			x_dist = xcenter - x;
			
			distance = (float)(sqrt((x_dist * x_dist) + (y_dist * y_dist)));

			if (distance < (float)radius) {
				vram_s[y * 320 + x] = color;
			}
		}
	}
}

void draw_black_outline (int width) {

	for (int y = 0; y < width; y++) {		
		for (int x = 0; x < 320; x++) {
			vram_s[y * 320 + x] = 0;
			vram_s[(240 - y) * 320 + x] = 0;
		}
	}

	for (int x = 0; x < width; x++) {
		for (int y = 0; y < 240; y++) {
			vram_s[y * 320 + x] = 0;
			vram_s[y * 320 + (320-x)] = 0;
		}
	}

}

void draw_fade (unsigned short red, unsigned short green, unsigned short blue, int what_color, int outside_in) {

	float val = 256.0 / 160.0;
	unsigned short color;
	
	for (int y = 0; y < 240; y++) {
		for (int x = 0; x < 320; x++) {
			if (x < 160) {
				if (outside_in == 1) {
					color = (int)(0.0 + (val * x));
				}
				else {
					color = (int)(255.0 - (val * x));
				}
			}
			else {				
				if (outside_in == 1) {
					color = (int)(255.0 - (val * (x-160))); 
				}
				else {
					color = (int)(0.0 + (val * (x-160)));
				}
			}
			if (what_color == 1) {
				color = ((color >> 3) << 11) | ((green >> 2) << 5) | ((blue >> 3) << 0);
			}
			else if (what_color == 2) {
				color = ((red >> 3) << 11) | ((color >> 2) << 5) | ((blue >> 3) << 0);
			}
			else {
				color = ((red >> 3) << 11) | ((green >> 2) << 5) | ((color >> 3) << 0);
			}
			vram_s[y * 320 + x] = color;
		}
	}
}