/*
 * image.c -- funcs to use with GIMP C-Source dumps.
 *
 * (C)2000 Jordan DeLong & Dan Potter
 *
 * Adapted by Dan Potter to load PCXs from disk instead of using
 * source dumps.
 *
 * For copying information, please see main.c
 */

/*
** NesterDC - NES emulator for Dreamcast
** Ken Friece
** This routine is from ghetto pong. It is covered 
** under the same license as libdream. Please see
** /libdream/COPYING for more details
*/

#include "dream.h"
#include "image.h"
#include "stdlib.h"

char *load_misc(char *fn) {
	int	fd, num_bytes;
	char	*rv;

	/* Open the file (or die trying!! =) */
	fd = cd_open(fn, O_RDONLY);
	if (fd < 0) {
//		dc_serial_printf("Couldn't open misc file %s\r\n", fn);
		return (char *)NULL;
	}

	/* Assess the size of the file and make a temp buffer; thankfully
	   this old crufty hack still works =) */
	cd_lseek(fd, 0, SEEK_END);
	num_bytes = cd_tell(fd);
	cd_lseek(fd, 0, SEEK_SET);
//	dc_serial_printf("%s: loading %d bytes\r\n", fn, num_bytes);

	/* Wastes memory right now: but we have 8 megs to blow, so whassaaa.. */
	rv = (char*)malloc(num_bytes);

	/* Load the PCX file */
	cd_read(fd, rv, num_bytes);
	cd_close(fd);

	return rv;
}

