/*
** nester - NES emulator
** Copyright (C) 2000  Darren Ranalli
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful, 
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
** Library General Public License for more details.  To obtain a 
** copy of the GNU Library General Public License, write to the Free 
** Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
** Any permitted reproduction of these routines, in whole or in part,
** must bear this legend.
*/

/* 
** NesterDC by Ken Friece
** Any changes that I made to the original source, by Darrin Ranalli, are 
** marked with in the following way:
** KF DD/MM/YYYY <description of the change> 
**
** I renamed this class from win32_NES_screen_mgr to dc_NES_screen_mgr.
** win32 in a class name doesn't make much sense on the Dreamcast.
*/

#ifndef _DC_NES_SCREEN_MGR_H_
#define _DC_NES_SCREEN_MGR_H_

//#include <windows.h> // KF 06/03/2001 commented include
//#include <windowsx.h> // KF 06/03/2001 commented include

#include "types.h"
#include "NES_screen_mgr.h"
#include "stdlib.h"
//#include "dc_NES_screen_mgr.h" // KF 06/03/2001 commented include
//#include "win32_fullscreen_NES_screen_mgr.h" // KF 06/03/2001 commented include

// This class hides the details of win32 screen management and
// windowed/fullscreen management. It allocates a windowed or
// fullscreen manager, and passes messages to it.

class dc_NES_screen_mgr : public NES_screen_mgr
{
public:
  dc_NES_screen_mgr(/*HWND window_handle*/); // KF 06/03/2001 changed class name
  ~dc_NES_screen_mgr(); // KF 06/03/2001 changed class name

  void setParentNES(NES* parent)
  {
    NES_screen_mgr::setParentNES(parent); if(screen) screen->setParentNES(parent);
  }

  boolean lock(pixmap& p);
  boolean unlock();

  void blt();
  void flip();

  void clear(PIXEL color);

  boolean set_palette(const uint8 pal[256][3]);
  boolean get_palette(uint8 pal[256][3]);
  boolean set_palette_section(uint8 start, uint8 len, const uint8 pal[][3]);
  boolean get_palette_section(uint8 start, uint8 len, uint8 pal[][3]);

  void assert_palette();

  boolean toggle_fullscreen();
  boolean is_fullscreen() { return fullscreen; }

protected:
//  HWND wnd_handle; // KF 06/03/2001 commented windows code
  boolean fullscreen;
  NES_screen_mgr* screen; // ptr windowed/fullscreen screen manager

  boolean GoWindowed();
  boolean GoFullscreen();

private:
};

#endif
