/*
** nester - NES emulator
** Copyright (C) 2000  Darren Ranalli
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful, 
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
** Library General Public License for more details.  To obtain a 
** copy of the GNU Library General Public License, write to the Free 
** Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
** Any permitted reproduction of these routines, in whole or in part,
** must bear this legend.
*/

/* 
** NesterDC by Ken Friece
** Any changes that I made to the original source, by Darrin Ranalli, are 
** marked with in the following way:
** KF DD/MM/YYYY <description of the change> 
**
** I renamed this class from win32_NES_screen_mgr to dc_NES_screen_mgr.
** win32 in a class name doesn't make much sense on the Dreamcast.
*/

//#include <ddraw.h>  // directdraw // KF 06/03/2001 commented include
#include "dc_NES_screen_mgr.h" // KF 06/03/2001 changed class name
//#include "win32_GUID.h" // KF 06/03/2001 commented include

dc_NES_screen_mgr::dc_NES_screen_mgr(/*HWND window_handle*/) // KF 06/03/2001 changed class name
{
  //wnd_handle = window_handle; // KF 06/03/2001 commented out code
  screen     = (NES_screen_mgr *)NULL; // KF 06/03/2001 type cast NULL
  fullscreen = FALSE; 

 // if(!GoWindowed()) // KF 06/03/2001 commented out code
 // {
 //   throw "Error initializing win32 windowed screen manager";
 // }
}

dc_NES_screen_mgr::~dc_NES_screen_mgr() // KF 06/03/2001 changed class name
{
  if(screen)
    delete screen;
}

boolean dc_NES_screen_mgr::lock(pixmap& p) // KF 06/03/2001 changed class name
{
  return screen->lock(p);
}

boolean dc_NES_screen_mgr::unlock() // KF 06/03/2001 changed class name
{
  return screen->unlock();
}

void dc_NES_screen_mgr::blt() // KF 06/03/2001 changed class name
{
  screen->blt();
}

void dc_NES_screen_mgr::flip() // KF 06/03/2001 changed class name
{
  screen->flip();
}

void dc_NES_screen_mgr::clear(PIXEL color) // KF 06/03/2001 changed class name
{
  screen->clear(color);
}

boolean dc_NES_screen_mgr::set_palette(const uint8 pal[256][3]) // KF 06/03/2001 changed class name
{
  return screen->set_palette(pal);
}

boolean dc_NES_screen_mgr::get_palette(uint8 pal[256][3]) // KF 06/03/2001 changed class name
{
  return screen->get_palette(pal);
}

boolean dc_NES_screen_mgr::set_palette_section(uint8 start, uint8 len, const uint8 pal[][3]) // KF 06/03/2001 changed class name
{
  return screen->set_palette_section(start, len, pal);
}

boolean dc_NES_screen_mgr::get_palette_section(uint8 start, uint8 len, uint8 pal[][3]) // KF 06/03/2001 changed class name
{
  return screen->get_palette_section(start, len, pal);
}

void dc_NES_screen_mgr::assert_palette() // KF 06/03/2001 changed class name
{
  set_NES_palette();
  screen->assert_palette();
}

boolean dc_NES_screen_mgr::toggle_fullscreen() // KF 06/03/2001 changed class name
{
	if(fullscreen) {
	}
  //  return GoWindowed(); // KF 06/03/2001 commented line
	else {
	}
  //  return GoFullscreen(); // KF 06/03/2001 commented line
}

boolean dc_NES_screen_mgr::GoWindowed() // KF 06/03/2001 changed class name
{
  NES_screen_mgr* sm;

  try {
  //  sm = new win32_windowed_NES_screen_mgr(wnd_handle);// KF 06/03/2001 commented line
  } catch(const char* IFDEBUG(s)) {
  //  LOG(s << endl); // KF 06/03/2001 commented line
    return FALSE;
  } catch(...) {
    return FALSE;
  }

  if(screen)
    delete screen;
  screen = sm;

  screen->setParentNES(parent_NES);

  assert_palette();

  fullscreen = FALSE;
  return TRUE;
}

boolean dc_NES_screen_mgr::GoFullscreen() // KF 06/03/2001 changed class name
{
  NES_screen_mgr* sm;

  try {
 //   sm = new win32_fullscreen_NES_screen_mgr(wnd_handle, // KF 06/03/2001 commented line
  //                                           GetGUIDPtr(&NESTER_settings.nes.graphics.osd.device_GUID),
  //                                           NESTER_settings.nes.graphics.fullscreen_scaling);
  } catch(const char* IFDEBUG(s)) {
  //  LOG(s << endl); // KF 06/03/2001 commented line
    return FALSE;
  } catch(...) {
    return FALSE;
  }

  if(screen)
    delete screen;
  screen = sm;

  screen->setParentNES(parent_NES);

  assert_palette();

  fullscreen = TRUE;
  return TRUE;
}
