/*
** NesterDC - NES emulator for Dreamcast
** Copyright (C) 2001  Ken Friece
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful, 
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
** Library General Public License for more details.  To obtain a 
** copy of the GNU Library General Public License, write to the Free 
** Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
** Any permitted reproduction of these routines, in whole or in part,
** must bear this legend.
*/

#include "bitmap.h"
#include "dream.h"
#include "stdlib.h"

void load_bmp (char * pic_name, uint8 *pic_buffer) {

	file_header bmfh;
	info_header bmih;

	unsigned char *pic_ptr = pic_buffer;

	int fp;
	//fp = fopen ("credits.bmp", "r");

	fp = cd_open (pic_name, O_RDONLY);
    
    if(fp < 0) {
	  dc_print ("Error opening picture file");
	  return;
	}

	if (cd_read (fp, (void *)&bmfh, 14) != 14) {
		dc_print ("Error reading file header");
		return;
	}
	if (cd_read (fp, (void *)&bmih, 40) != 40) {
		dc_print ("Error reading info header");
		return;
	}

	if (cd_read (fp, pic_buffer, 240*320*3) != (240*320*3)) {
		dc_print ("Error reading picture data");
		return;
	}

	cd_close (fp);

}

void display_bmp (uint8 *pic_buffer) {

	unsigned short *vram = vram_s + (320*239);
	unsigned char *pic_ptr = pic_buffer;

	uint16 r, g, b;

	for (int i=0; i<240; i++) {

		for (int j=0; j<320; j++) {

			b = (uint16)(*pic_ptr++ * 32) / 256;
			g = (uint16)(*pic_ptr++ * 64) / 256;
			r = (uint16)(*pic_ptr++ * 32) / 256;
			
			*vram++ = (r << 11) | (g << 5) | (b << 0);

		}

		vram -= 640;
	}

}