﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;

namespace NitroExplorer {
    public partial class frmMain : Form {
        private NitroClass ROM;
        private Dictionary<int,TreeNode> DirHolder;

        public frmMain() {
            InitializeComponent();
            ROM = new NitroClass();
            ROM.ROMIsReady += new NitroClass.ROMIsReadyD(ROM_ROMIsReady);
            ROM.DirReady += new NitroClass.DirReadyD(ROM_DirReady);
            ROM.FileReady += new NitroClass.FileReadyD(ROM_FileReady);
        }

        private void ROM_ROMIsReady(long TimeTakenMS) {
            Single TimeTakenHax = Convert.ToSingle(TimeTakenMS);
            TimeTakenHax /= 1000;
            toolStripStatusLabel1.Text = "ROM loaded. Time taken: " + TimeTakenHax.ToString("F2") + " seconds.";
            DirHolder[61440].Expand();
        }

        private void ROM_DirReady(int DirID, int ParentID, string DirName, bool IsRoot) {
            if (IsRoot) {
                DirHolder[61440] = tvFiles.Nodes.Add("61440", "Root [" + openFileDialog1.FileName.Substring(openFileDialog1.FileName.LastIndexOf('\\') + 1) + "]", 0, 0);
                DirHolder[61440].Tag = "61440";
            } else {
                DirHolder[DirID] = DirHolder[ParentID].Nodes.Add(DirID.ToString(), DirName, 0, 0);
                DirHolder[DirID].Tag = DirID.ToString();
            }
        }

        private void ROM_FileReady(int FileID, int ParentID, string FileName) {
            DirHolder[ParentID].Nodes.Add(FileID.ToString(), FileName, 2, 2).Tag = FileID.ToString();
        }

        private void aboutButton_Click(object sender, EventArgs e) {
            frmAbout AboutForm = new frmAbout();
            AboutForm.ShowDialog();
            //AboutForm.Dispose();
            this.Activate();
        }

        private void openROMButton_Click(object sender, EventArgs e) {
            if (openFileDialog1.ShowDialog() == DialogResult.OK) {
                toolStripStatusLabel1.Text = "Loading ROM...";
                tvFiles.Nodes.Clear();
                DirHolder = new Dictionary<int,TreeNode>();
                ROM.LoadROM(openFileDialog1.FileName);
                extractButton.Enabled = false;
                reinsertButton.Enabled = false;
            }
        }

        private void tvFiles_AfterSelect(object sender, TreeViewEventArgs e) {
            ushort FSObjId = Convert.ToUInt16(e.Node.Tag);
            string StatusMsg;
            if (FSObjId >= 61440) {
                StatusMsg = "Directory: " + e.Node.Text + " - ID " + e.Node.Tag;
                extractButton.Enabled = false;
                reinsertButton.Enabled = false;
            } else {
                StatusMsg = "Offset: 0x" + ROM.FileOffsets[FSObjId].ToString("X") + " - Size: " + ROM.FileSizes[FSObjId].ToString() + " bytes - ID " + e.Node.Tag;
                extractButton.Enabled = true;
                reinsertButton.Enabled = true;
            }
            toolStripStatusLabel1.Text = StatusMsg;
        }

        private void tvFiles_AfterCollapse(object sender, TreeViewEventArgs e) {
            e.Node.ImageIndex = 0;
            e.Node.SelectedImageIndex = 0;
        }

        private void tvFiles_AfterExpand(object sender, TreeViewEventArgs e) {
            e.Node.ImageIndex = 1;
            e.Node.SelectedImageIndex = 1;
        }

        private void extractButton_Click(object sender, EventArgs e) {
            ushort FSObjID = Convert.ToUInt16(tvFiles.SelectedNode.Tag);
            string FileName = ROM.FileNames[FSObjID];
            saveFileDialog1.FileName = FileName;
            if (saveFileDialog1.ShowDialog() == DialogResult.OK) {
                string DestFileName = saveFileDialog1.FileName;
                ExtractFile(FSObjID, DestFileName);
            }
        }

        private void reinsertButton_Click(object sender, EventArgs e) {
            ushort FSObjID = Convert.ToUInt16(tvFiles.SelectedNode.Tag);
            string FileName = ROM.FileNames[FSObjID];
            openFileDialog2.FileName = FileName;
            if (openFileDialog2.ShowDialog() == DialogResult.OK) {
                string SrcFileName = openFileDialog2.FileName;
                ReplaceFile(FSObjID, SrcFileName);
            }
        }

        /* Extract a File */
        private void ExtractFile(ushort FileID, string DestFileName) {
            byte[] TempFile = ROM.ExtractFile(FileID);
            FileStream wfs = new FileStream(DestFileName, FileMode.Create, FileAccess.Write, FileShare.None);
            wfs.Write(TempFile, 0, TempFile.GetLength(0));
            wfs.Dispose();
            toolStripStatusLabel1.Text = "File '" + ROM.FileNames[FileID] + "' extracted successfully.";
        }

        /* Replace a File */
        private void ReplaceFile(ushort FileID, string SrcFileName) {
            FileStream rfs = new FileStream(SrcFileName, FileMode.Open, FileAccess.Read, FileShare.Read);
            byte[] TempFile = new byte[rfs.Length];
            rfs.Read(TempFile, 0, (int)rfs.Length);
            rfs.Dispose();
            ROM.ReplaceFile(FileID, TempFile);
            toolStripStatusLabel1.Text = "File '" + ROM.FileNames[FileID] + "' replaced successfully.";
        }
    }
}
