#include "stdafx.h"
#include "VGMColl.h"
#include "VGMSeq.h"
#include "VGMInstrSet.h"
#include "VGMSampColl.h"
#include "VGMSamp.h"
#include "VGMRgn.h"
#include "Root.h"

#include <math.h>

DECLARE_MENU(VGMColl)

VGMColl::VGMColl(wstring theName)
: VGMItem(),
  name(theName),
  seq(NULL)
{
}

VGMColl::~VGMColl(void)
{
}

void VGMColl::RemoveFileAssocs()
{
	if (seq)
		seq->RemoveCollAssoc(this);
	for (UINT i=0; i<instrsets.size(); i++)
		instrsets[i]->RemoveCollAssoc(this);
	for (UINT i=0; i<sampcolls.size(); i++)
		sampcolls[i]->RemoveCollAssoc(this);
}

const wstring* VGMColl::GetName(void) const
{
	return &name;
}

void VGMColl::SetName(const wstring* newName)
{
	name = *newName;
}

VGMSeq* VGMColl::GetSeq(void)
{
	return seq;
}

void VGMColl::UseSeq(VGMSeq* theSeq)
{
	theSeq->AddCollAssoc(this);
	if (seq && (theSeq != seq))	//if we associated with a previous sequence
		seq->RemoveCollAssoc(this);
	seq = theSeq;
}

void VGMColl::AddInstrSet(VGMInstrSet* theInstrSet)
{
	theInstrSet->AddCollAssoc(this);
	instrsets.push_back(theInstrSet);
}

void VGMColl::AddSampColl(VGMSampColl* theSampColl)
{
	theSampColl->AddCollAssoc(this);
	sampcolls.push_back(theSampColl);
}


bool VGMColl::Load()
{
	if(!LoadMain())
		return false;
	pRoot->AddVGMColl(this);
	return true;
}

void VGMColl::UnpackSampColl(DLSFile& dls, VGMSampColl* sampColl, vector<VGMSamp*>& finalSamps)
{
	int nSamples = sampColl->samples.size();
	for (int i=0; i<nSamples; i++)
	{
		VGMSamp* samp = sampColl->samples[i];

		ULONG bufSize;
		if (samp->ulUncompressedSize)
			bufSize = samp->ulUncompressedSize;
		else
			bufSize = ceil((double)samp->dataLength * samp->GetCompressionRatio());
		//bool bOddBufSize = bufSize % 2;
		//if (bOddBufSize)				//if the buffer size is odd, we must align it to be even for the RIFF format
		//	bufSize++;
		BYTE* uncompSampBuf = new BYTE[bufSize];	//create a new memory space for the uncompressed wave
		samp->ConvertToStdWave(uncompSampBuf);			//and uncompress into that space
		//if (bOddBufSize)
		//	uncompSampBuf[bufSize] = 0;		//set the last (should be unused) byte to 0;

		USHORT blockAlign = samp->bps / 8*samp->channels;
		dls.AddWave(1, samp->channels, samp->rate, samp->rate*blockAlign, blockAlign,
			samp->bps, bufSize, uncompSampBuf, wstring2string(samp->name));
		finalSamps.push_back(samp);
	}
}


void VGMColl::CreateDLSFile(DLSFile& dls)
{
	PreDLSMainCreation(dls);
	MainDLSCreation(dls);
	PostDLSMainCreation(dls);
}

void VGMColl::MainDLSCreation(DLSFile& dls)
{
	//DLSFile* dls = new DLSFile();
	vector<VGMSamp*> finalSamps;
	//we have to collect the finalSampColls in case sampcolls is empty but there are multiple instrSets with
	//embedded sampcolls
	vector<VGMSampColl*> finalSampColls;	

	if (!instrsets.size() /*|| !sampcolls.size()*/ || !seq)
		return;

	// if there are independent SampColl(s) in the collection
	if (sampcolls.size())
	{
		for (UINT sam = 0; sam<sampcolls.size(); sam++)
		{
			finalSampColls.push_back(sampcolls[sam]);
			UnpackSampColl(dls, sampcolls[sam], finalSamps);
		}
	}
	// otherwise, the SampColl(s) are children of the InstrSet(s)
	else
	{
		for (UINT i=0; i<instrsets.size(); i++)
		{
			finalSampColls.push_back(instrsets[i]->sampColl);
			UnpackSampColl(dls, instrsets[i]->sampColl, finalSamps);
		}
	}


	for (UINT inst = 0; inst<instrsets.size(); inst++)
	{
		VGMInstrSet* set = instrsets[inst];
		UINT nInstrs = set->aInstrs.size();
		for (UINT i=0; i<nInstrs; i++)
		{
			VGMInstr* vgminstr = set->aInstrs[i];
			UINT nRgns = vgminstr->aRgns.size();
			if (nRgns == 0)								//do not write an instrument if it has no regions
				continue;
			DLSInstr* newInstr = dls.AddInstr(vgminstr->bank, vgminstr->instrNum);
			for (UINT j=0; j<nRgns; j++)
			{
				VGMRgn* vgmrgn = vgminstr->aRgns[j];
//				if (vgmrgn->sampNum+1 > sampColl->samples.size())	//does thereferenced sample exist?
//					continue;

				// Determine the SampColl associated with this rgn.  If there's an explicit pointer to it, use that.
				VGMSampColl* sampColl = vgmrgn->sampCollPtr;
				if (!sampColl)
				{
					// If rgn is of an InstrSet with an embedded SampColl, use that SampColl.
					if ( ((VGMInstrSet*)vgmrgn->vgmfile)->sampColl )
						sampColl = ((VGMInstrSet*)vgmrgn->vgmfile)->sampColl;

					// If that does not exist, assume the first SampColl
					else
						sampColl = finalSampColls[0];
				}
				
				// Determine the sample number within the rgn's associated SampColl
				int realSampNum;
				// If a sample offset is provided, then find the sample number based on this offset.
				// see sampOffset declaration in header file for more info.
				if (vgmrgn->sampOffset != -1)
				{
					bool bFoundIt = false;
					for (UINT s=0; s<sampColl->samples.size(); s++) {							//for every sample
						if (vgmrgn->sampOffset  == sampColl->samples[s]->dwOffset - sampColl->dwOffset - sampColl->sampDataOffset)
						{
							realSampNum = s;

							//samples[m]->loop.loopStart = parInstrSet->aInstrs[i]->aRgns[k]->loop.loopStart;
							//samples[m]->loop.loopLength = (samples[m]->dataLength) - (parInstrSet->aInstrs[i]->aRgns[k]->loop.loopStart); //[aInstrs[i]->aRegions[k]->sample_num]->dwUncompSize/2) - ((aInstrs[i]->aRegions[k]->loop_point*28)/16); //to end of sample
							bFoundIt = true;
							break;
						}
					}
					if (!bFoundIt)
					{
						Alert(L"Could not match rgn with sampOffset %X to a sample with that offset.\n  (InstrSet %d, Instr %d, Rgn %d)",
							vgmrgn->sampOffset, inst, i, j);
						realSampNum = 0;
					}
				}
				// Otherwise, the sample number should be explicitly defined in the rgn.
				else
					realSampNum = vgmrgn->sampNum;


				// Determine the sampCollNum (index into our finalSampColls vector)
				int sampCollNum;
				for (UINT i=0; i < finalSampColls.size(); i++)
				{
					if (finalSampColls[i] == sampColl)
						sampCollNum = i;
				}
				//   now we add the number of samples from the preceding SampColls to the value to get the real sampNum
				//   in the final DLS file.
				for (int k=0; k < sampCollNum; k++)
					realSampNum += finalSampColls[k]->samples.size();	

						
				// For collections with multiple SampColls
				// If a SampColl ptr is given, find the SampColl and adjust the sample number of the region
				// to compensate for all preceding SampColl samples.
				//if (vgmrgn->sampCollNum == -1)	//if a sampCollPtr is defined
				//{
				//	// find the sampColl's index in samplecolls (the sampCollNum, effectively)
				//	for (UINT i=0; i < finalSampColls.size(); i++)
				//	{
				//		if (finalSampColls[i] == sampColl)
				//			vgmrgn->sampCollNum = i;
				//	}
				//}
				//if (vgmrgn->sampCollNum != -1)		//if a sampCollNum is defined
				//{									//then sampNum represents the sample number in the specific sample collection
				//	for (int k=0; k < vgmrgn->sampCollNum; k++)
				//		realSampNum += finalSampColls[k]->samples.size();	//so now we add all previous sample collection samples to the value to get the real (absolute) sampNum
				//}
				

				DLSRgn* newRgn = newInstr->AddRgn();
				newRgn->SetRanges(vgmrgn->keyLow, vgmrgn->keyHigh,
								  vgmrgn->velLow, vgmrgn->velHigh);
				newRgn->SetWaveLinkInfo(0, 0, 1, realSampNum);

				//if (realSampNum >= finalSamps.size())
				//	realSampNum = finalSamps.size()-1;
				assert(realSampNum < finalSamps.size());
				VGMSamp* samp = finalSamps[realSampNum];//sampColl->samples[vgmrgn->sampNum];
				DLSWsmp* newWsmp = newRgn->AddWsmp();

				// This is a really loopy way of determining the loop information, pardon the pun.  However, it works.
				// There might be a way to simplify this, but I don't want to test out whether another method breaks anything just yet
				// Use the sample's loopStatus to determine if a loop occurs.  If it does, see if the sample provides loop info
				// (gathered during ADPCM > PCM conversion.  If the sample doesn't provide loop offset info, then use the region's
				// loop info.
				if (samp->bPSXLoopInfoPrioritizing)
				{
					if (samp->loop.loopStatus != -1)
					{
						if (samp->loop.loopStart != 0 || samp->loop.loopLength != 0)
							newWsmp->SetLoopInfo(samp->loop, samp);
						else
						{
							vgmrgn->loop.loopStatus = samp->loop.loopStatus;
							newWsmp->SetLoopInfo(vgmrgn->loop, samp);
						}
					}
					else throw;
				}
				// The normal method: First, we check if the rgn has loop info defined. 
				// If it doesn't, then use the sample's loop info.
				else if (vgmrgn->loop.loopStatus == -1)
				{
					if (samp->loop.loopStatus != -1)
						newWsmp->SetLoopInfo(samp->loop, samp);
					else throw;
				}
				else
					newWsmp->SetLoopInfo(vgmrgn->loop, samp);

				BYTE realUnityKey;
				if (vgmrgn->unityKey == -1)
					realUnityKey = samp->unityKey;
				else
					realUnityKey = vgmrgn->unityKey;
				if (realUnityKey == -1)
					realUnityKey = 0x3C;

				short realFineTune;
				if (vgmrgn->fineTune == 0)
					realFineTune = samp->fineTune;
				else
					realFineTune = vgmrgn->fineTune;

				long realAttenuation;
				if (vgmrgn->attenuation == 0)
					realAttenuation = samp->attenuation;
				else
					realAttenuation = vgmrgn->attenuation;

				
				//attack_time = (long)ceil((log(timeInSecs)/log((double)2)) * 1200 * 65536);
				
				if (vgmrgn->release_time < .001)
				vgmrgn->release_time = .001;
				if (vgmrgn->decay_time < .001)
					vgmrgn->decay_time = .001;
				if (vgmrgn->attack_time < .001)
					vgmrgn->attack_time = .001;
				
				long convAttack = (long)ceil((log(vgmrgn->attack_time)/log((double)2)) * 1200 * 65536);
				long convDecay = (long)ceil((log(vgmrgn->decay_time)/log((double)2)) * 1200 * 65536);
				long convSustainLev;
				if (vgmrgn->sustain_level == -1)
					convSustainLev = 0x03e80000;		//sustain at full if no sustain level provided
				else if (vgmrgn->bSustainInPctVol)
				{
					//double dbVal = 20 * log10( vgmrgn->sustain_level * vgmrgn->sustain_level); //see page 14 dls1 specs.  for a standard midi volume change, decibel attenuation = 20*log(127^2/X^2)
					//pretty sure the following is a correct.
					
					//double dbVal = 20 * log10( vgmrgn->sustain_level); //see page 14 dls1 specs.  for a standard midi volume change, decibel attenuation = 20*log(127^2/X^2)
					//convSustainLev = ((96.0+dbVal)/96.0)*0x03e80000;		//the DLS envelope is a range from 0 to -96db. 

					double attenInDB = 20*log10((1.0/vgmrgn->sustain_level));
					convSustainLev = ((96.0-attenInDB)/96.0)*0x03e80000;		//the DLS envelope is a range from 0 to -96db. 
					int j = 0;
				}
				else if (vgmrgn->bSustainInDecibel)
					convSustainLev = ((96.0+vgmrgn->sustain_level)/96.0)*0x03e80000;		//the DLS envelope is a range from 0 to -96db. 
				else
					throw;
					//convSustainLev = (long)(vgmrgn->sustain_level*0x03e80000);
				long convRelease = (long)ceil((log(vgmrgn->release_time)/log((double)2)) * 1200 * 65536);


				long pan = 0;
				//if (vgmrgn->bPanIn10thPctUnits)
				//	pan = vgmrgn->pan;
				//if (vgmrgn->pan != 0)	//by default pan is a double value between -1.0 and 1.0 (abs left and right)
				//	pan = (long)ceil((vgmrgn->pan*0x40) * 516031.49606299212598425196850394);
				if (vgmrgn->pan != 0) //by default pan is a double value between -1.0 and 1.0 (abs left and right)
					pan = (long)((vgmrgn->pan) * 32768000);

				DLSArt* newArt = newRgn->AddArt();
				newArt->AddPan(pan);
				newArt->AddADSR(convAttack, 0, convDecay, convSustainLev, convRelease, 0);

				newWsmp->SetPitchInfo(realUnityKey, realFineTune, realAttenuation);
			}
		}
	}
	//dls.SaveDLSFile(name.c_str());
}


bool VGMColl::OnSaveAll()
{
	wstring dirpath = pRoot->UI_GetSaveDirPath();
	if (dirpath.length() != 0)
	{
		DLSFile dlsfile;
		wstring filepath = dirpath + L"\\" + this->name + L".dls";
		CreateDLSFile(dlsfile);
		if (!dlsfile.SaveDLSFile(filepath.c_str()))
			Alert(L"Failed to save DLS file.");
		filepath = dirpath + L"\\" + this->name + L".mid";
		if (!this->seq->SaveAsMidi(filepath.c_str()))
			Alert(L"Failed to save MIDI file.");
	}
	return true;
}
