--[[

libProgressBar 1.1 par Aurel2108

Depuis la 1.0 :

- Commentaires sur la lib
- Ajout d'un cadre noir autour de la barre

Depuis la 1.0b :

- Ajout de Numerics Up Down dans l'exemple (merci  la lib que Quent42340)

Depuis la 1.0c :

- Possibilit de choisir le sens de la barre ^^ 

]]--

-- * NUD = Numeric Up Down

dofile ("libProgressBar.lua") -- On inclus la libProgressBar
dofile ("libNumericUpDown.LUA") -- On inclus la libNUD que Quent42340 (juste pour l'exemple)

-- J'initialise les NUD

NumericUpDown.init (1, 5, 65, 50, 15, 90, 0, 100, 1) 
NumericUpDown.init (2, 5, 105, 50, 15, 60, 0, 200, 2) 

-- Les valeurs des barres

val = 90
val2 = 60

-- On initialise les barres de progression
--[[

initProgressBar(id, genre, sens, longueur, hauteur, couleur de fond, couleur de dessus)

Genres : 1 = pourcentage, 2 = pixels
Sens : 

1 = gauche -> droite
2 = droite -> gauche
3 = haut -> bas
4 = bas -> haut

]]--

initProgressBar(1, 1, 4, 20, 100, Color.new(31, 0, 0), Color.new(0, 31, 0))
initProgressBar(2, 2, 2, 200, 20, Color.new(31, 0, 0), Color.new(0, 31, 0))

while not Keys.newPress.Start do

Controls.read() -- On actualises les contrles

-- On actualise la valeur des barres suivant celle des NUD

val = NumericUpDown.value (1)
val2 = NumericUpDown.value (2)

startDrawing() -- On dmarre l'affichage

-- On rend l'cran du bas blanc et l'cran du haut jaune

screen.drawFillRect(SCREEN_UP, 0, 0, 256, 192, c_jaune)
screen.drawFillRect(SCREEN_DOWN, 0, 0, 256, 192, c_blanc)

-- On affiche les barres 
--[[

drawProgressBar(id, cran, x, y, valeur / pourcentage)

--]]

drawProgressBar(1, SCREEN_DOWN, 210, 5, val)
drawProgressBar(2, SCREEN_DOWN, 5, 35, val2)

-- On affiche les NUD

NumericUpDown.draw (1)
NumericUpDown.draw (2)

-- Quelques conditions

if val > 100 then

val = 100

end

if val < 0 then

val = 0

end

if val2 > 200 then

val2 = 200

end

if val2 < 0 then

val2 = 0 

end

-- Un Peu de Texte

screen.print(SCREEN_UP, 5, 5, "Barre 1 : "..val.." %", c_bleu)
screen.print(SCREEN_UP, 5, 15, "Barre 2 : "..val2.." / 200", c_bleu)

stopDrawing() -- Fin de l'affichage

end

-- On supprime les barres

delProgressBar(1)
delProgressBar(2)

-- On supprime les NUD

NumericUpDown.clear(1)
NumericUpDown.clear(2)
