dofile ("libColor.lua")
dofile ("StylusBox.lua")

NumericUpDown = {}

ncx, ncy = 0, 0

function NumericUpDown.init (nupdwn, x, y, larg, haut, val, valMin, valMax, step)
  local nup = tostring (nupdwn)
  
  _G[nup] = {}
  _G[nup].x = x
  _G[nup].y = y
  _G[nup].larg = larg
  _G[nup].haut = haut
  _G[nup].x2 = _G[nup].x+_G[nup].larg
  _G[nup].y2 = _G[nup].y+_G[nup].haut
  _G[nup].val = val
  _G[nup].valMin = valMin
  _G[nup].valMax = valMax
  _G[nup].step = step
  _G[nup].tmr = Timer.new ()
  _G[nup].upx = _G[nup].x2+1
  _G[nup].upy = _G[nup].y
  _G[nup].upx2 = _G[nup].x2+1+math.floor (_G[nup].larg/4)
  _G[nup].upy2 = _G[nup].y+math.floor (_G[nup].haut/2)
  _G[nup].up = newBox (_G[nup].upx, _G[nup].upy, _G[nup].upx2, _G[nup].upy2)
  _G[nup].uptxtx = (_G[nup].upx+(_G[nup].upx2-_G[nup].upx)/2)-4
  _G[nup].uptxty = (_G[nup].upy+(_G[nup].upy2-_G[nup].upy)/2)-3
  _G[nup].downx = _G[nup].x2+1
  _G[nup].downy = _G[nup].y2-math.floor (_G[nup].haut/2)
  _G[nup].downx2 = _G[nup].x2+1+math.floor (_G[nup].larg/4)
  _G[nup].downy2 = _G[nup].y2
  _G[nup].down = newBox (_G[nup].downx, _G[nup].downy, _G[nup].downx2, _G[nup].downy2)
  _G[nup].downtxtx = (_G[nup].downx+(_G[nup].downx2-_G[nup].downx)/2)-4
  _G[nup].downtxty = (_G[nup].downy+(_G[nup].downy2-_G[nup].downy)/2)-3
  _G[nup].is = false
end

function NumericUpDown.draw (nupdwn)
  local nup = tostring (nupdwn)
  
  if Stylus.held then
    ncx = Stylus.X
    ncy = Stylus.Y
  end
  
  _G[nup].txt = tostring (_G[nup].val)
  _G[nup].txtx = (_G[nup].x2-(string.len (_G[nup].txt)*6))-3
  _G[nup].txty = (_G[nup].y+_G[nup].haut/2)-3
  
  screen.drawRect (SCREEN_DOWN, _G[nup].x-1, _G[nup].y-1, _G[nup].x2+1, _G[nup].y2+1, c_noir)
  screen.drawFillRect (SCREEN_DOWN, _G[nup].x+1, _G[nup].y, _G[nup].x2-1, _G[nup].y2, c_blanc)
  screen.drawFillRect (SCREEN_DOWN, _G[nup].upx, _G[nup].upy, _G[nup].upx2, _G[nup].upy2, c_gris)
  screen.drawFillRect (SCREEN_DOWN, _G[nup].downx, _G[nup].downy, _G[nup].downx2, _G[nup].downy2, c_gris)
  screen.drawRect (SCREEN_DOWN, _G[nup].upx-1, _G[nup].upy-1, _G[nup].upx2+1, _G[nup].upy2+1, c_noir)
  screen.drawRect (SCREEN_DOWN, _G[nup].downx-1, _G[nup].downy-1, _G[nup].downx2+1, _G[nup].downy2+1, c_noir)
  screen.print (SCREEN_DOWN, _G[nup].txtx, _G[nup].txty, _G[nup].txt, c_noir)
  screen.print (SCREEN_DOWN, _G[nup].uptxtx, _G[nup].uptxty, "+", c_noir)
  screen.print (SCREEN_DOWN, _G[nup].downtxtx, _G[nup].downtxty, "-", c_noir)
  if Stylus.heldinBox (_G[nup].up, ncx, ncy) then
    _G[nup].tmr:start ()
    if _G[nup].tmr:time () == 0 and not _G[nup].is then
      _G[nup].val = _G[nup].val+_G[nup].step
    end
    if _G[nup].tmr:time () >= 1000 then
      _G[nup].val = _G[nup].val+_G[nup].step
      _G[nup].is = true
      _G[nup].tmr:reset ()
    end
  else
  end
  if Stylus.heldinBox (_G[nup].down, ncx, ncy) then
    _G[nup].tmr:start ()
    if _G[nup].tmr:time () == 0 and not _G[nup].is then
      _G[nup].val = _G[nup].val-_G[nup].step
    end
    if _G[nup].tmr:time () >= 1000 then
      _G[nup].val = _G[nup].val-_G[nup].step
      _G[nup].is = true
      _G[nup].tmr:reset ()
    end
  else
  end
  if Stylus.released then
    _G[nup].tmr:stop ()
    _G[nup].tmr:reset ()
    _G[nup].is = false
  end
  if _G[nup].val >= _G[nup].valMax then
    _G[nup].val = _G[nup].valMax
  elseif _G[nup].val <= _G[nup].valMin then
    _G[nup].val = _G[nup].valMin
  end
end

function NumericUpDown.value (nupdwn)
  local nup = tostring (nupdwn)
  
  return _G[nup].val
end

function NumericUpDown.valueMax (nupdwn)
  local nup = tostring (nupdwn)
  
  return _G[nup].valMax
end

function NumericUpDown.valueMin (nupdwn)
  local nup = tostring (nupdwn)
  
  return _G[nup].valMin
end

function NumericUpDown.step (nupdwn)
  local nup = tostring (nupdwn)
  
  return _G[nup].step
end

function NumericUpDown.clear (nupdwn)
  local nup = tostring (nupdwn)
  
  _G[nup] = nil
  
  ncx, ncy = nil, nil
end

