/*
 * Decompiled with CFR 0.152.
 */
package org.opensource.jhextool.logic;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class Padder {
    public static void pad(File f, long byteMax) throws IOException {
        FileInputStream fis = new FileInputStream(f);
        FileOutputStream fos = new FileOutputStream(f + ".pad");
        int readByte = fis.read();
        int byteCount = 0;
        while ((long)byteCount < byteMax) {
            if (readByte != -1) {
                fos.write(readByte);
            } else {
                fos.write(0);
            }
            readByte = fis.read();
            ++byteCount;
        }
        fis.close();
        fos.close();
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            File f = new File(args[0]);
            if (f.exists()) {
                try {
                    int kbyte = 128;
                    try {
                        if (args.length > 1) {
                            kbyte = Integer.parseInt(args[1]);
                        }
                    }
                    catch (NumberFormatException e) {
                        System.err.println("Invalid byte count.");
                    }
                    if (f.length() > (long)(kbyte * 1024)) {
                        System.out.println("Warning: the specified size is smaller than the current file size. The file will be trimmed.");
                    }
                    Padder.pad(f, kbyte * 1024);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                System.err.println("File not found: " + f);
            }
        }
    }
}

