/*
 * Decompiled with CFR 0.152.
 */
package org.opensource.jhextool.logic;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;

public class Dumper {
    public static final String LINEFEED = System.getProperty("line.separator");

    public static String byteToHex(int b) {
        StringBuilder hex = new StringBuilder();
        int div = b / 16;
        int mod = b % 16;
        hex.append(Dumper.digitToHex(div));
        hex.append(Dumper.digitToHex(mod));
        return hex.toString();
    }

    public static String digitToHex(int digit) {
        StringBuilder hex = new StringBuilder();
        if (digit < 16) {
            switch (digit) {
                case 10: {
                    hex.append("A");
                    break;
                }
                case 11: {
                    hex.append("B");
                    break;
                }
                case 12: {
                    hex.append("C");
                    break;
                }
                case 13: {
                    hex.append("D");
                    break;
                }
                case 14: {
                    hex.append("E");
                    break;
                }
                case 15: {
                    hex.append("F");
                    break;
                }
                default: {
                    hex.append(digit);
                }
            }
        }
        return hex.toString();
    }

    public static File dump(File f) throws IOException {
        return Dumper.dump(f, 16);
    }

    public static File dump(File f, int interval) throws IOException {
        return Dumper.dump(f, 16, 0);
    }

    public static File dump(File f, int interval, int shift) throws IOException {
        return Dumper.dump(f, 16, shift, 0, 0);
    }

    public static File dump(File f, int interval, int shift, int start, int length) throws IOException {
        File dumpFile = new File(String.valueOf(f.getName()) + ".dump");
        FileInputStream is = new FileInputStream(f);
        FileWriter os = new FileWriter(dumpFile);
        int offset = 0;
        int read = is.read();
        while (read != -1 && offset < start) {
            is.read();
            ++offset;
        }
        if (length == 0) {
            --length;
        }
        while (read != -1 && length != 0) {
            System.out.println(length);
            if (offset % interval == 0) {
                os.write(String.valueOf(Dumper.offsetToHex(offset + shift)) + " ");
            }
            --length;
            os.write(String.valueOf(Dumper.byteToHex(read)) + (++offset % interval == 0 ? LINEFEED : " "));
            read = is.read();
        }
        is.close();
        os.close();
        return dumpFile;
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            String[] stringArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                File f = new File(s);
                if (f.exists()) {
                    try {
                        Dumper.dump(f);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                } else {
                    System.err.println("File not found: " + f);
                }
                ++n2;
            }
        }
    }

    public static String offsetToHex(int offset) {
        StringBuilder hex = new StringBuilder();
        int o = offset;
        while (o != 0) {
            hex.append(Dumper.digitToHex(o % 16));
            o /= 16;
        }
        while (hex.length() < 8) {
            hex.append(0);
        }
        hex.reverse();
        return hex.toString();
    }
}

