/*
 * Decompiled with CFR 0.152.
 */
package org.opensource.jhextool.gui.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.opensource.jhextool.gui.JHexToolFrame;
import org.opensource.jhextool.logic.Padder;
import org.opensource.jhextool.util.NoFileOpenedException;

public class PadPanel
extends JPanel {
    protected final JHexToolFrame root;
    protected final JPanel centerPanel = new JPanel();
    protected final JLabel padLabel = new JLabel("File size");
    protected final JTextField padField = new JTextField("0", 8);
    private final Object[] sizes = new Object[]{"Byte", "KiB", "MiB", "GiB"};
    protected final JComboBox padBox = new JComboBox<Object>(this.sizes);
    protected final JButton processButton = new JButton("Pad");

    public PadPanel(JHexToolFrame root) {
        this.setLayout(new BorderLayout());
        this.root = root;
        this.centerPanel.setBorder(BorderFactory.createTitledBorder("Padder Options"));
        this.centerPanel.add(this.padLabel);
        this.centerPanel.add(this.padField);
        this.centerPanel.add(this.padBox);
        this.processButton.addActionListener(new PadAction(this));
        this.add((Component)this.centerPanel, "Center");
        this.add((Component)this.processButton, "South");
    }

    public class PadAction
    implements ActionListener {
        private Component parent;

        public PadAction(Component parent) {
            this.parent = parent;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                File f = PadPanel.this.root.getFile();
                long pad = Long.parseLong(PadPanel.this.padField.getText());
                long mul = 1L;
                if (PadPanel.this.padBox.getSelectedItem().equals("KiB")) {
                    mul = 1024L;
                } else if (PadPanel.this.padBox.getSelectedItem().equals("MiB")) {
                    mul = 0x100000L;
                } else if (PadPanel.this.padBox.getSelectedItem().equals("GiB")) {
                    mul = 0x40000000L;
                }
                if (f.length() > (pad *= mul)) {
                    JOptionPane.showMessageDialog(this.parent, "The asserted file size is smaller than the original file.\nThe resulting file may not work correctly.", "Warning", 2);
                }
                Padder.pad(f, pad);
            }
            catch (NoFileOpenedException e1) {
                JOptionPane.showMessageDialog(this.parent, "No file opened.", "", 2);
            }
            catch (NumberFormatException e1) {
                JOptionPane.showMessageDialog(this.parent, "Invalid input.", "", 2);
            }
            catch (IOException e1) {
                JOptionPane.showMessageDialog(this.parent, "I/O error.", "", 0);
            }
        }
    }
}

