/*
 * Decompiled with CFR 0.152.
 */
package org.opensource.jhextool.gui.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.opensource.jhextool.gui.JBaseComboBox;
import org.opensource.jhextool.gui.JHexToolFrame;
import org.opensource.jhextool.logic.Dumper;
import org.opensource.jhextool.util.NoFileOpenedException;

public class DumpPanel
extends JPanel {
    protected final JHexToolFrame root;
    protected final JPanel centerPanel = new JPanel();
    protected final JLabel intervalLabel = new JLabel("Bytes per line ");
    protected final JTextField intervalField = new JTextField("16", 2);
    protected final JLabel shiftLabel = new JLabel("Offset shift");
    protected final JBaseComboBox shiftBase = new JBaseComboBox();
    protected final JTextField shiftField = new JTextField("0", 8);
    protected final JLabel startLabel = new JLabel("Start Index");
    protected final JBaseComboBox startBase = new JBaseComboBox();
    protected final JTextField startField = new JTextField("0", 8);
    protected final JLabel lengthLabel = new JLabel("Dump Length");
    protected final JBaseComboBox lengthBase = new JBaseComboBox();
    protected final JTextField lengthField = new JTextField("0", 8);
    private final Object[] sizes = new Object[]{"Byte", "KiB", "MiB", "GiB"};
    protected final JComboBox dumpBox = new JComboBox<Object>(this.sizes);
    protected final JButton processButton = new JButton("Dump");

    public DumpPanel(JHexToolFrame root) {
        this.setLayout(new BorderLayout());
        this.root = root;
        this.centerPanel.setBorder(BorderFactory.createTitledBorder("Dumper Options"));
        GridBagConstraints gbc = new GridBagConstraints();
        this.centerPanel.setLayout(new GridBagLayout());
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        this.centerPanel.add((Component)this.intervalLabel, gbc);
        ++gbc.gridx;
        this.centerPanel.add((Component)this.intervalField, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        this.centerPanel.add((Component)this.shiftLabel, gbc);
        ++gbc.gridx;
        this.centerPanel.add((Component)this.shiftField, gbc);
        ++gbc.gridx;
        this.centerPanel.add((Component)this.shiftBase, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        this.centerPanel.add((Component)this.startLabel, gbc);
        ++gbc.gridx;
        this.centerPanel.add((Component)this.startField, gbc);
        ++gbc.gridx;
        this.centerPanel.add((Component)this.startBase, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        this.centerPanel.add((Component)this.lengthLabel, gbc);
        ++gbc.gridx;
        this.centerPanel.add((Component)this.lengthField, gbc);
        ++gbc.gridx;
        this.centerPanel.add((Component)this.lengthBase, gbc);
        this.intervalField.setToolTipText("Number of Bytes to display per line");
        this.shiftField.setToolTipText("Number that is distracted from the printed offset");
        this.startField.setToolTipText("Offset in file where to start dumping");
        this.lengthField.setToolTipText("Number of Bytes to dump, 0 = until EOF is reached");
        this.processButton.addActionListener(new DumpAction(this));
        this.add((Component)this.centerPanel, "Center");
        this.add((Component)this.processButton, "South");
    }

    public class DumpAction
    implements ActionListener {
        private Component parent;

        public DumpAction(Component parent) {
            this.parent = parent;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                File f = DumpPanel.this.root.getFile();
                int interval = Integer.parseInt(DumpPanel.this.intervalField.getText());
                int shift = Integer.parseInt(DumpPanel.this.shiftField.getText(), DumpPanel.this.shiftBase.getBase());
                int start = Integer.parseInt(DumpPanel.this.startField.getText(), DumpPanel.this.startBase.getBase());
                int length = Integer.parseInt(DumpPanel.this.lengthField.getText(), DumpPanel.this.lengthBase.getBase());
                System.out.println("Dumping [interval=" + interval + ", shift=" + shift + ", start=" + start + ", length=" + length + "]");
                Dumper.dump(f, interval, shift, start, length);
            }
            catch (NoFileOpenedException e1) {
                JOptionPane.showMessageDialog(this.parent, "No file opened.", "", 2);
            }
            catch (NumberFormatException e1) {
                JOptionPane.showMessageDialog(this.parent, "Invalid input.", "", 2);
            }
            catch (IOException e1) {
                JOptionPane.showMessageDialog(this.parent, "I/O error.", "", 0);
            }
        }
    }
}

