/*
 * Decompiled with CFR 0.152.
 */
package org.opensource.jhextool.gui;

import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class JHyperLink
extends JLabel {
    private String uri;
    private String elementText;

    public JHyperLink() {
        this((String)null);
    }

    public JHyperLink(String uri) {
        this(uri, uri);
    }

    public JHyperLink(final String uri, String elementText) {
        super("<html><a href=\"" + uri + "\">" + elementText + "</a></html>");
        this.uri = uri;
        this.elementText = elementText;
        this.addMouseListener(new MouseAdapter(){
            private Desktop desktop = Desktop.getDesktop();

            @Override
            public void mouseClicked(MouseEvent arg0) {
                if (uri != null && this.desktop.isSupported(Desktop.Action.BROWSE)) {
                    try {
                        this.desktop.browse(new URI(uri));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    catch (URISyntaxException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        this.setCursor(new Cursor(12));
        this.setToolTipText("Click to open " + this.getElementText());
    }

    public String getElementText() {
        return this.elementText;
    }

    public String getURI() {
        return this.uri;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.add(new JHyperLink("http://en.wikipedia.org/wiki/Hello_World", "Hello World"));
        frame.pack();
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }
}

