/*
 * Decompiled with CFR 0.152.
 */
package org.opensource.jhextool.gui;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.opensource.jhextool.gui.JHyperLink;
import org.opensource.jhextool.gui.panel.DumpPanel;
import org.opensource.jhextool.gui.panel.PadPanel;
import org.opensource.jhextool.util.NoFileOpenedException;

public class JHexToolFrame
extends JFrame {
    public static final String APP_NAME = "JHexTool";
    public static final String APP_VERSION = "2.0";
    private File file;
    private String lastDir;
    protected final JMenuBar menuBar = new JMenuBar();
    protected final JMenu fileMenu = new JMenu("File");
    protected final JMenu helpMenu = new JMenu("Help");
    protected final JMenuItem openItem = new JMenuItem("Open");
    protected final JMenuItem exitItem = new JMenuItem("Exit");
    protected final JMenuItem aboutItem = new JMenuItem("About");
    protected final JTabbedPane tabPane = new JTabbedPane();
    protected final PadPanel padPanel = new PadPanel(this);
    protected final DumpPanel dumpPanel = new DumpPanel(this);

    public JHexToolFrame(String[] args) {
        super(APP_NAME);
        this.openItem.addActionListener(new OpenAction(this));
        this.exitItem.addActionListener(new ExitAction());
        this.aboutItem.addActionListener(new AboutAction(this));
        this.fileMenu.add(this.openItem);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.exitItem);
        this.helpMenu.add(this.aboutItem);
        this.menuBar.add(this.fileMenu);
        this.menuBar.add(this.helpMenu);
        this.setJMenuBar(this.menuBar);
        this.tabPane.add((Component)this.padPanel, "Padder");
        this.tabPane.add((Component)this.dumpPanel, "Dumper");
        this.add(this.tabPane);
        this.setDefaultCloseOperation(3);
        this.setResizable(false);
        this.pack();
        if (args != null && args.length > 0) {
            File f = new File(args[0]);
            if (f.exists()) {
                this.file = f;
            } else {
                System.err.println("File not found: " + f);
            }
        }
    }

    public File getFile() throws NoFileOpenedException {
        if (this.file == null) {
            throw new NoFileOpenedException();
        }
        return this.file;
    }

    public class AboutAction
    implements ActionListener {
        private final Component parent;

        public AboutAction(Component parent) {
            this.parent = parent;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            JPanel aboutPanel = new JPanel();
            aboutPanel.setLayout(new GridLayout(2, 1));
            aboutPanel.add(new JLabel("Version 2.0"));
            aboutPanel.add(new JHyperLink("mailto:unmacaque@gmail.com", "unmacaque@gmail.com"));
            JOptionPane.showMessageDialog(this.parent, aboutPanel, "About JHexTool", 1);
        }
    }

    public class ExitAction
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent arg0) {
            System.exit(0);
        }
    }

    public class OpenAction
    implements ActionListener {
        private final Component parent;

        public OpenAction(Component parent) {
            this.parent = parent;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            JFileChooser openDialog = new JFileChooser(JHexToolFrame.this.lastDir);
            int choice = openDialog.showOpenDialog(this.parent);
            if (choice == 0) {
                File f = openDialog.getSelectedFile();
                JHexToolFrame.this.lastDir = f.getParent();
                JHexToolFrame.this.file = f;
            }
        }
    }
}

