#include <stdio.h>
#include <stdlib.h>

#ifndef WIN32
#include <sys/stat.h>
int filelength(int fd){ //constant phrase
	struct stat st;
	fstat(fd,&st);
	return st.st_size;
}
#endif

unsigned int read32(const void *p){
	const unsigned char *x=(const unsigned char*)p;
	return x[0]|(x[1]<<8)|(x[2]<<16)|(x[3]<<24);
}

void write32(void *p, const unsigned int n){
	unsigned char *x=(unsigned char*)p;
	x[0]=n&0xff,x[1]=(n>>8)&0xff,x[2]=(n>>16)&0xff,x[3]=(n>>24)&0xff;
}

int main(int argc, char **argv){
	FILE *f;
	unsigned char *p,*q;
	int size;
	int arm9body,arm9mem,arm9size;
	int arm7body,arm7mem,arm7size;
	unsigned int xcrc=0,crcoffset=-1,flag=0;

	puts("MoonShell GUID Patch in C\n");
	if(!(f=fopen(argv[1],"rb+"))){printf("Cannot open %s\n",argv[1]);return 1;}
	size=filelength(fileno(f));
	if(!(p=malloc(size))){printf("Cannot allocate %d bytes\n",size);return 1;}
	fread(p,1,size,f);
	rewind(f);

///
	printf("arm9body=0x%08x\n",arm9body=read32(p+0x20));
	printf("arm9memstart=0x%08x\n",arm9mem=read32(p+0x28));
	printf("arm9memend=0x%08x\n",arm9mem+(arm9size=read32(p+0x2c)));

	for(q=p+arm9body;q<p+arm9body+arm9size;q+=4){
		if(read32(q)==0x44495547){ //skip GUID
			if(read32(q+4)==0x47554944)crcoffset=q+8-p;
			q+=20;
		}
		else if(read32(q)==0xbf8da5ed)q+=32*1024-4; //skip DLDI
		else xcrc=(xcrc<<1|xcrc>>31)^read32(q);

	}
	printf("xcrc=0x%08x\n",xcrc);
	printf("crcoffset=0x%08x\n",crcoffset);
	if(~crcoffset){
		write32(p+crcoffset,xcrc);
		write32(p+crcoffset+4,arm9mem);
		write32(p+crcoffset+8,arm9mem+arm9size);
		flag=1;
		puts("ARM9: Patched successfully");	
	}else{
		puts("ARM9: GUIDDIUG not found");
	}

///
	xcrc=0,crcoffset=-1;
	printf("arm7body=0x%08x\n",arm7body=read32(p+0x30));
	printf("arm7memstart=0x%08x\n",arm7mem=read32(p+0x38));
	printf("arm7memend=0x%08x\n",arm7mem+(arm7size=read32(p+0x3c)));

	for(q=p+arm7body;q<p+arm7body+arm7size;q+=4){
		if(read32(q)==0x44495547){ //skip GUID
			if(read32(q+4)==0x47554944)crcoffset=q+8-p;
			q+=20;
		}
		else if(read32(q)==0xbf8da5ed)q+=32*1024-4; //skip DLDI
		else xcrc=(xcrc<<1|xcrc>>31)^read32(q);

	}
	printf("xcrc=0x%08x\n",xcrc);
	printf("crcoffset=0x%08x\n",crcoffset);
	if(~crcoffset){
		write32(p+crcoffset,xcrc);
		write32(p+crcoffset+4,arm7mem);
		write32(p+crcoffset+8,arm7mem+arm7size);
		flag=1;
		puts("ARM7: Patched successfully");	
	}else{
		puts("ARM7: GUIDDIUG not found");
	}

	if(flag)fwrite(p,1,size,f);
	free(p);fclose(f);
	return 0;
}
