#include <stdio.h>
#include <string.h>
#include <stdlib.h>

int main(int argc, char **argv){
  unsigned char *ys;
  unsigned size,ext;
  FILE *f;
  int flag=0;

  //startup
  printf("fatpatch - modified yspatch\n");
  if(argc<2){printf("specify path for nds\n");return 1;}
  ext=strlen(argv[1]);
  if(ext<4||argv[1][ext-4]!='.'){printf("file has to have extention such as .nds or .dat\n");return 1;}
  ext-=3;

  //read
  f=fopen(argv[1],"rb");
  if(!f){printf("cannot open nds\n");return 2;}
  fseek(f,0,SEEK_END);
  size=ftell(f);
  fseek(f,0,SEEK_SET);
  if(size>0x2000000){printf("too big\n");fclose(f);return 3;}
  ys=(unsigned char*)malloc(size);
  if(!ys){printf("cannot alloc memory\n");fclose(f);return 4;}
  fread(ys,1,size,f);
  fclose(f);

  //patch
  printf("Trying ARM...\n");{
    int i=0x200,p=0;
    for(;i<size-100;i+=4){
      if(
        ((
          ys[i+ 3]==0xe3&&ys[i+ 2]==0x50&&ys[i+ 1]==0x00&&ys[i   ]==0x01 && // cmp r0,#0x1
          ys[i+ 7]==0x9a&&ys[i+ 6]==0x00&&ys[i+ 5]==0x00&&ys[i+ 4]==0x02    // bls +0x10 (skip 3)
        )||(
          ys[i+ 3]==0xe3&&ys[i+ 2]==0x50&&ys[i+ 1]==0x00&&ys[i   ]==0x02 && // cmp r0,#0x2
          ys[i+ 7]==0x3a&&ys[i+ 6]==0x00&&ys[i+ 5]==0x00&&ys[i+ 4]==0x02    // bcc +0x10 (skip 3)
        ))&&
        ys[i+11]==0xe5&&                                                  // ldr ...
        ys[i+15]==0xe1&&ys[i+14]==0x50&&ys[i+13]==0x00&&                  // cmp r0,r?
        (ys[i+19]&0xf0)==0x30                                             // ldmccia(38) / bcc(3a) (return)
      ){
        if(flag){printf("multiple hits (patch error)\n");free(ys);return -1;}flag=1;
        p=i+19;
      }
    }
if(p){
    printf("Patched 0x%08X\n",p);
    //if(ys[p]!=0x0a){printf("incorrect detection (patch error)\n");free(ys);return -1;}
    ys[p]=0x90|(ys[p]&0x0f); //ldmlsia / bls (return)
}
  }

  printf("Trying Thumb...\n");{
    int i=0x200,p=0;
    for(;i<size-100;i+=2){
      if(
        ys[i+ 1]==0x28&&ys[i   ]==0x01 && // cmp r0,#0x1
        ys[i+ 3]==0xd9&&ys[i+ 2]==0x02 && // bcc +0x10 (skip 3)
                                          // ldr ...
        ys[i+ 7]==0x42&&ys[i+ 6]==0x98 && // cmp r0,r3
        ys[i+ 9]==0xd3                 && // bcc (return)
        ys[i+11]==0xf7&&ys[i+10]==0xff    // bl (long)
      ){
        if(flag){printf("multiple hits (patch error)\n");free(ys);return -1;}flag=1;
        p=i+9;
      }
    }
if(p){
    printf("Patched 0x%08X\n",p);
    //if(ys[p]!=0x0a){printf("incorrect detection (patch error)\n");free(ys);return -1;}
    ys[p]=0xd9; //bls (return)
}
  }

  if(!flag){printf("no hits or already patched\n");free(ys);return -1;}

  //write
  {
    char *n=(char*)malloc(strlen(argv[1])+1);
    strcpy(n,argv[1]);
    n[ext]='b';n[ext+1]='a';n[ext+2]='k';
    rename(argv[1],n);
    free(n);
  }
  f=fopen(argv[1],"wb");
  fwrite(ys,1,size,f);
  fclose(f);
  free(ys);
  printf("patch OK\n");
  return 0;
}
