/*
 * Decompiled with CFR 0.152.
 */
package util.struct.graphics;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import util.gui.panels.CTableModel;
import util.struct.CBank;
import util.struct.CBankItem;
import util.struct.graphics.CAnim;
import util.struct.graphics.CGraphic;
import util.struct.graphics.CMap;
import util.struct.graphics.CPalette;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMapBank
extends CBank {
    private int width;
    private int height;

    public CMapBank(int width, int height) {
        this.width = width;
        this.height = height;
    }

    @Override
    public CTableModel getModel() {
        CTableModel model = super.getModel();
        model.addRow("Tiles", this.getItemCount(), false);
        return model;
    }

    public ArrayList<CMap> getTiles() {
        ArrayList<CMap> items = new ArrayList<CMap>();
        for (CBankItem item : this.getItems()) {
            items.add((CMap)item);
        }
        return items;
    }

    @Override
    public CMap get(int index) {
        return (CMap)super.get(index);
    }

    @Override
    public CAnim getSelected() {
        return (CAnim)super.getSelected();
    }

    public BufferedImage getBuffer(CPalette palette, CGraphic graphic, boolean alpha) {
        BufferedImage image = new BufferedImage(this.width, this.height, 2);
        for (int y = 0; y < this.height / 8; ++y) {
            for (int x = 0; x < this.width / 8; ++x) {
                CMap map = this.get(y * (this.width / 8) + x);
                BufferedImage tileImage = map.getBuffer(palette, graphic, alpha);
                image.getGraphics().drawImage(tileImage, x * 8, y * 8, null);
            }
        }
        return image;
    }
}

