/*
 * Decompiled with CFR 0.152.
 */
package util.struct.graphics;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import util.Common;
import util.struct.CBank;
import util.struct.graphics.CPalette;

public class CImage
extends CBank {
    public static final int ERROR_PALETTE = -16711936;
    public static final int ERROR_IMAGE = -16776961;
    public static final int PAL4 = 2;
    public static final int PAL16 = 4;
    public static final int PAL256 = 8;
    public static final int DIRECT16 = 16;
    public static final int A3I5 = 30;
    public static final int A5I3 = 31;
    public static final int DS4X4 = 32;
    private int formatId;
    private byte[] data = new byte[0];
    private Dimension size = new Dimension(0, 0);
    private Dimension tiled = null;
    private static int[][] shiftList = new int[][]{{0, 0}, {1, 255}, {3, 85}, {7, 36}, {15, 17}, {31, 8}, {63, 4}, {127, 2}, {255, 1}};

    public CImage(byte[] data, int formatId) {
        this.formatId = formatId;
        this.data = data;
        CImageFormat format = CImage.getFormat(formatId);
        if (format.isTiled()) {
            this.tiled = format.getTileSize();
        }
    }

    public CImageFormat getFormat() {
        return CImage.getFormat(this.formatId);
    }

    public void setSize(int width, int height) {
        this.size = new Dimension(width, height);
    }

    public Dimension getSize() {
        return this.size;
    }

    public void setTileSize(int width, int height) {
        this.tiled = new Dimension(width, height);
    }

    public Dimension getTileSize() {
        if (this.tiled != null) {
            return this.tiled;
        }
        return new Dimension(0, 0);
    }

    public boolean isTiled() {
        return this.tiled != null;
    }

    public int[] getPixels(CPalette palette, boolean alpha) {
        CImageFormat format = CImage.getFormat(this.formatId);
        int[] pixels = new int[]{};
        switch (this.formatId) {
            case 2: 
            case 4: 
            case 8: {
                Common.error("Image Format: " + format);
                pixels = this.getPaletted(palette, format, alpha);
                break;
            }
            case 30: {
                Common.error("Image Format: " + format);
                pixels = this.getTranslucent(palette, format, 5, 3, alpha);
                break;
            }
            case 31: {
                Common.error("Image Format: " + format);
                pixels = this.getTranslucent(palette, format, 3, 5, alpha);
                break;
            }
            case 32: {
                pixels = this.getDSCompressed(palette, alpha);
                break;
            }
            default: {
                Common.error("Unknown Image Format: " + format);
            }
        }
        return pixels;
    }

    public int[] getTranslucent(CPalette palette, CImageFormat format, int palWidth, int alphaWidth, boolean alpha) {
        int[] pixels = Common.getInts(this.data, format.getDepth());
        int[] colors = palette.getColors();
        for (int i = 0; i < pixels.length; ++i) {
            int value = pixels[i];
            int index = value & shiftList[palWidth][0];
            int alphaValue = (value >> palWidth & shiftList[alphaWidth][0]) * shiftList[alphaWidth][1];
            int pixel = -16711936;
            if (index < colors.length) {
                pixel = colors[index];
            }
            if (!alpha) {
                alphaValue = 255;
            }
            pixel &= 0xFFFFFF;
            pixels[i] = pixel |= alphaValue << 24;
        }
        return pixels;
    }

    public BufferedImage getImage(CPalette palette, boolean alpha) {
        BufferedImage image = new BufferedImage(this.size.width, this.size.height, 2);
        int[] pixels = this.getPixels(palette, alpha);
        if (this.isTiled()) {
            int twidth = image.getWidth() / this.getTileSize().width;
            int tweight = image.getHeight() / this.getTileSize().height;
            int c = 0;
            for (int ty = 0; ty < tweight; ++ty) {
                for (int tx = 0; tx < twidth; ++tx) {
                    for (int y = 0; y < this.getTileSize().height; ++y) {
                        for (int x = 0; x < this.getTileSize().width; ++x) {
                            int index = c++;
                            int pixel = -16776961;
                            if (index < pixels.length) {
                                pixel = pixels[index];
                            }
                            image.setRGB(tx * this.getTileSize().width + x, ty * this.getTileSize().height + y, pixel);
                        }
                    }
                }
            }
        } else {
            for (int y = 0; y < image.getHeight(); ++y) {
                for (int x = 0; x < image.getWidth(); ++x) {
                    int pixel = -16776961;
                    int index = y * image.getWidth() + x;
                    if (index < pixels.length) {
                        pixel = pixels[index];
                    }
                    image.setRGB(x, y, pixel);
                }
            }
        }
        return image;
    }

    private int[] getPaletted(CPalette palette, CImageFormat format, boolean alpha) {
        int[] pixels = Common.getInts(this.data, format.getDepth());
        int[] colors = palette.getColors();
        for (int i = 0; i < pixels.length; ++i) {
            int color = -16711936;
            int index = pixels[i];
            if (index < colors.length) {
                color = colors[index];
            }
            if (index == 0 && alpha) {
                color &= 0xFFFFFF;
            }
            pixels[i] = color;
        }
        return pixels;
    }

    private int[] getDSCompressed(CPalette palette, boolean alpha) {
        int[] pixels = new int[this.size.width * this.size.height];
        int[] colors = palette.getColors();
        int tileWidth = this.size.width / 4;
        int tileHeight = this.size.height / 4;
        int c = 0;
        for (int ty = 0; ty < tileHeight; ++ty) {
            for (int tx = 0; tx < tileWidth; ++tx) {
                int blockIndex = (ty * tileWidth + tx) * 4;
                int blockData = Common.getInt(this.data, blockIndex, 4);
                int blockInfo = Common.getInt(this.data, this.data.length / 3 * 2 + blockIndex / 2, 2);
                int palOffset = (blockInfo & 0x3FFF) << 1;
                int mode = blockInfo >> 14 & 3;
                for (int y = 0; y < 4; ++y) {
                    for (int x = 0; x < 4; ++x) {
                        int shift = (y * 4 + x) * 2;
                        int texel = blockData >> shift & 3;
                        int index = c++;
                        int color0 = -16711936;
                        int color1 = -16711936;
                        int color2 = -16711936;
                        int color3 = -16711936;
                        if (palOffset + 1 < colors.length) {
                            color0 = colors[palOffset];
                            color1 = colors[palOffset + 1];
                        }
                        if (palOffset + 3 < colors.length) {
                            color2 = colors[palOffset + 2];
                            color3 = colors[palOffset + 3];
                        }
                        int color = -16711936;
                        int trans = 0;
                        if (!alpha) {
                            trans = -16777216;
                        }
                        block0 : switch (texel) {
                            case 0: {
                                color = color0;
                                break;
                            }
                            case 1: {
                                color = color1;
                                break;
                            }
                            case 2: {
                                switch (mode) {
                                    case 0: 
                                    case 2: {
                                        color = color2;
                                        break;
                                    }
                                    case 1: {
                                        color = (color0 + color1) / 2;
                                        break;
                                    }
                                    case 3: {
                                        color = (color0 * 5 + color1 * 3) / 8;
                                    }
                                }
                                break;
                            }
                            case 3: {
                                switch (mode) {
                                    case 0: 
                                    case 1: {
                                        color = trans;
                                        break block0;
                                    }
                                    case 2: {
                                        color = color3;
                                        break block0;
                                    }
                                    case 3: {
                                        color = (color0 * 3 + color1 * 5) / 8;
                                    }
                                }
                            }
                        }
                        pixels[index] = color;
                    }
                }
            }
        }
        return pixels;
    }

    public static CImageFormat getFormat(int formatId) {
        CImageFormat format = new CImageFormat("8-Bit Direct", 0, 8);
        switch (formatId) {
            case 2: {
                format = new CImageFormat("4-Color Palette", formatId, 2);
                break;
            }
            case 4: {
                format = new CImageFormat("16-Color Palette", formatId, 4);
                break;
            }
            case 8: {
                format = new CImageFormat("256-Color Palette", formatId, 8);
                break;
            }
            case 16: {
                format = new CImageFormat("16-Bit Direct", formatId, 16);
                break;
            }
            case 30: {
                format = new CImageFormat("A3I5 Translucent", formatId, 8);
                break;
            }
            case 31: {
                format = new CImageFormat("A5I3 Translucent", formatId, 8);
                break;
            }
            case 32: {
                format = new CImageFormat("4x4-Texel Compressed", formatId, 2, new Dimension(4, 4));
            }
        }
        return format;
    }

    public static class CImageFormat {
        private String name;
        private int id;
        private int bitDepth;
        private Dimension tiled;

        public CImageFormat(String name, int id, int bitDepth) {
            this.name = name;
            this.id = id;
            this.bitDepth = bitDepth;
        }

        public CImageFormat(String name, int id, int bitDepth, Dimension tiled) {
            this(name, id, bitDepth);
            this.tiled = tiled;
        }

        public String toString() {
            return this.getName() + " (" + this.getDepth() + "-bit)";
        }

        public String getName() {
            return this.name;
        }

        public int getId() {
            return this.id;
        }

        public int getDepth() {
            return this.bitDepth;
        }

        public Dimension getTileSize() {
            return this.tiled;
        }

        public boolean isTiled() {
            return this.tiled != null;
        }
    }
}

