/*
 * Decompiled with CFR 0.152.
 */
package util.struct.formats;

import java.nio.ByteBuffer;
import util.Common;
import util.struct.DPalette;
import util.struct.DPath;
import util.struct.graphics.CPalette;

public class RiffPalette
extends DPalette {
    public RiffPalette(DPath path) {
        super(path);
    }

    public void open() {
        byte[] data = this.getPath().read();
        String magic = Common.getString(data, 0, 4);
        int fileSize = Common.getInt(data, 4, 4);
        String type = Common.getString(data, 8, 8);
        int chunkSize = Common.getInt(data, 16, 4);
        int version = Common.getInt(data, 20, 2);
        int colorCount = Common.getInt(data, 22, 2);
        this.add(new CPalette(Common.getBytes(data, 24, chunkSize - 4), CPalette.XBGR8888));
    }

    public void save(DPalette data) {
        Common.msg("Save as Riff Palette: " + data);
        ByteBuffer buffer = ByteBuffer.allocate(0);
        for (CPalette pal : data.getPalettes()) {
            buffer = ByteBuffer.allocate(buffer.capacity() + pal.getColorCount() * 4);
            for (int color : pal.getColors()) {
                color = CPalette.encodeColor(color, CPalette.XBGR8888);
                buffer.put(Common.getBytes(color, 4));
            }
        }
        this.getPath().empty();
        this.getPath().write("RIFF".getBytes());
        this.getPath().write(Common.getBytes(buffer.capacity() + 20, 4));
        this.getPath().write("PAL data".getBytes());
        this.getPath().write(Common.getBytes(buffer.capacity() + 4, 4));
        this.getPath().write(Common.getBytes(768, 2));
        this.getPath().write(Common.getBytes(buffer.capacity() / 4, 2));
        this.getPath().write(buffer.array());
    }
}

