/*
 * Decompiled with CFR 0.152.
 */
package util.struct.formats;

import util.Common;
import util.struct.DMap;
import util.struct.DPath;
import util.struct.formats.Nitro;
import util.struct.graphics.CMap;
import util.struct.graphics.CMapBank;

public class NitroNscr
extends DMap {
    public NitroNscr(DPath path) {
        super(path);
    }

    public void open() {
        Nitro blocks = new Nitro(this.getPath());
        byte[] data = blocks.getBlockData("NRCS");
        String magic = Common.getString(data, 0, 4);
        int size = Common.getInt(data, 4, 4);
        int width = Common.getInt(data, 8, 2);
        int height = Common.getInt(data, 10, 2);
        int unknown = Common.getInt(data, 12, 4);
        int dataSize = Common.getInt(data, 16, 4);
        if (unknown != 0) {
            Common.error("NSCR: Unknown = " + unknown);
        }
        if (dataSize != data.length - 20) {
            Common.error("NCGR: Mismatch Data Size " + (data.length - 20) + " != " + dataSize);
        }
        this.parseScreen(new CMapBank(width, height), Common.getBytes(data, 20, dataSize));
    }

    private void parseScreen(CMapBank map, byte[] data) {
        for (int i = 0; i < data.length / 2; ++i) {
            int value = Common.getInt(data, i * 2, 2);
            int tile = value & 0x3FF;
            boolean flipx = (value & 0x400) != 0;
            boolean flipy = (value & 0x800) != 0;
            int palette = value >> 12 & 0xF;
            map.add(new CMap(tile * 64, flipx, flipy, palette));
        }
        this.add(map);
    }
}

