/*
 * Decompiled with CFR 0.152.
 */
package util.struct.formats;

import java.nio.ByteBuffer;
import util.Common;
import util.struct.DPalette;
import util.struct.DPath;
import util.struct.formats.Nitro;
import util.struct.formats.NitroBlock;
import util.struct.graphics.CPalette;

public class NitroNclr
extends DPalette {
    private static final String FIELD_UNKNOWN = "Unknown";

    public NitroNclr(DPath path) {
        super(path);
    }

    public void open() {
        Nitro blocks = new Nitro(this.getPath());
        for (NitroBlock block : blocks.getBlocks()) {
            String magic = block.getMagic();
            if (!magic.equals("TTLP")) continue;
            this.readPLTT(this.getPath().read(block.getOffset(), block.getSize()));
        }
    }

    private void readPLTT(byte[] data) {
        int bitDepth = Common.getInt(data, 8, 2);
        int unknown = Common.getInt(data, 10, 2);
        int padding = Common.getInt(data, 12, 4);
        int dataSize = Common.getInt(data, 16, 4);
        int palSize = Common.getInt(data, 20, 4);
        this.getModel().addRow(FIELD_UNKNOWN, unknown);
        if (dataSize != data.length - 24) {
            Common.error("NCLR: Data Size does not match Block Size: " + dataSize + " > " + (data.length - 24));
            dataSize = data.length - 24;
        }
        if (unknown != 0) {
            Common.error("NCLR: Unknown value != 0 but " + unknown);
        }
        if (padding != 0) {
            Common.error("NCLR: Padding != 0 but " + padding);
        }
        if (palSize != 16) {
            Common.error("NCLR: Palette Size != 16 but " + palSize);
        }
        bitDepth = bitDepth == 4 ? 8 : 4;
        this.add(new CPalette(Common.getBytes(data, 24, dataSize), CPalette.BGR555, bitDepth));
    }

    public void save(DPalette data) {
        Common.msg("Save as Nitro Palette: " + data);
        ByteBuffer buffer = ByteBuffer.allocate(0);
        CPalette pal = data.get(0);
        buffer = ByteBuffer.allocate(buffer.capacity() + pal.getColorCount() * 2);
        for (int color : pal.getColors()) {
            color = CPalette.encodeColor(color, CPalette.BGR555);
            buffer.put(Common.getBytes(color, 2));
        }
        int depth = pal.getDepth();
        depth = depth == 4 ? 3 : 4;
        int unknown = (Integer)data.getModel().getRow(FIELD_UNKNOWN, 0);
        this.getPath().empty();
        this.getPath().write("RLCN".getBytes());
        this.getPath().write(Common.getBytes(16842495, 4));
        this.getPath().write(Common.getBytes(buffer.capacity() + 40, 4));
        this.getPath().write(Common.getBytes(16, 2));
        this.getPath().write(Common.getBytes(1, 2));
        this.getPath().write("TTLP".getBytes());
        this.getPath().write(Common.getBytes(buffer.capacity() + 24, 4));
        this.getPath().write(Common.getBytes(depth, 2));
        this.getPath().write(Common.getBytes(unknown, 2));
        this.getPath().write(Common.getBytes(0, 4));
        this.getPath().write(Common.getBytes(buffer.capacity(), 4));
        this.getPath().write(Common.getBytes(16, 4));
        this.getPath().write(buffer.array());
    }
}

