/*
 * Decompiled with CFR 0.152.
 */
package util.struct.formats;

import java.awt.Dimension;
import util.Common;
import util.struct.DGraphic;
import util.struct.DPath;
import util.struct.formats.Nitro;
import util.struct.graphics.CGraphic;

public class NitroNcgr
extends DGraphic {
    public NitroNcgr(DPath path) {
        super(path);
    }

    public void open() {
        Nitro blocks = new Nitro(this.getPath());
        byte[] data = blocks.getBlockData("RAHC");
        String charMagic = Common.getString(data, 0, 4);
        int charSize = Common.getInt(data, 4, 4);
        int tileHeight = Common.getInt(data, 8, 2);
        int tileWidth = Common.getInt(data, 10, 2);
        int bitDepth = Common.getInt(data, 12, 4);
        int gridY = Common.getInt(data, 16, 2);
        int gridX = Common.getInt(data, 18, 2);
        int tiled = Common.getInt(data, 20, 1);
        int partitioned = Common.getInt(data, 21, 1);
        int unknown2 = Common.getInt(data, 22, 2);
        int dataSize = Common.getInt(data, 24, 4);
        int constant = Common.getInt(data, 28, 4);
        int[] pixels = Common.getInts(Common.getBytes(data, 32, dataSize), Nitro.getDepth(bitDepth));
        this.getModel().addRow("Tile Width", tileWidth, false);
        this.getModel().addRow("Tile Height", tileHeight, false);
        this.getModel().addRow("Bit Depth", bitDepth, false);
        this.getModel().addRow("Grid X", gridX, false);
        this.getModel().addRow("Grid Y", gridY, false);
        this.getModel().addRow("Tiled", tiled == 0, false);
        this.getModel().addRow("Partitioned", partitioned == 1, false);
        this.getModel().addRow("Unknown2", unknown2, false);
        this.getModel().addRow("Constant", constant, false);
        if (dataSize != data.length - 32) {
            Common.error("NCGR: Mismatch Data Size " + (data.length - 32) + " != " + dataSize);
        }
        if (gridX != 0) {
            Common.error("NCGR: ?X = " + gridX + " | ?Y = " + gridY);
        }
        int width = tileWidth * 8;
        int height = tileHeight * 8;
        if (tileWidth == 65535) {
            width = 64;
            height = (int)Math.ceil((double)pixels.length / (double)width);
        }
        Dimension tileSize = new Dimension(8, 8);
        Dimension size = new Dimension(width, height);
        CGraphic image = new CGraphic(pixels, Nitro.getDepth(bitDepth), size, tiled, partitioned, tileSize);
        this.add(image);
        Dimension cpos = this.readCPOS(blocks);
    }

    private Dimension readCPOS(Nitro nitro) {
        Dimension cpos = new Dimension(0, 0);
        byte[] data = nitro.getBlockData("SOPC");
        if (data != null) {
            int unknown = Common.getInt(data, 8, 4);
            int width = Common.getInt(data, 12, 2);
            int height = Common.getInt(data, 14, 2);
            cpos = new Dimension(width, height);
            this.getModel().addRow("CPOS ??", unknown, false);
            this.getModel().addRow("CPOS Width", width, false);
            this.getModel().addRow("CPOS Height", height, false);
        }
        return cpos;
    }
}

