/*
 * Decompiled with CFR 0.152.
 */
package util.struct.formats;

import java.util.ArrayList;
import util.Common;
import util.struct.DAnim;
import util.struct.DFormat;
import util.struct.DPath;
import util.struct.formats.Nitro;
import util.struct.graphics.CAnim;
import util.struct.graphics.CAnimBank;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NitroNanr
extends DAnim {
    public NitroNanr(DPath path) {
        super(path);
    }

    @Override
    public void open() {
        Nitro blocks = new Nitro(this.getPath());
        for (CAnimBank bank : NitroNanr.readAnimBank(blocks, this)) {
            this.add(bank);
        }
        this.getModel().addRow("Labels", blocks.getLabels().size(), false);
        blocks.readUEXT(this);
    }

    public static ArrayList<CAnimBank> readAnimBank(Nitro blocks, DFormat format) {
        byte[] data = blocks.getBlockData("KNBA");
        ArrayList<String> labels = blocks.getLabels();
        String magic = Common.getString(data, 0, 4);
        int sectionSize = Common.getInt(data, 4, 4);
        int bankCount = Common.getInt(data, 8, 2);
        int frameTotal = Common.getInt(data, 10, 2);
        int constant = Common.getInt(data, 12, 4);
        int headerOffset = Common.getInt(data, 16, 4);
        int dataOffset = Common.getInt(data, 20, 4);
        int padding = Common.getInt(data, 24, 4);
        int padding2 = Common.getInt(data, 28, 4);
        Common.msg("# Banks: " + bankCount);
        Common.msg("# Frames: " + frameTotal);
        Common.msg("Constant: 0x" + Common.getHex(constant, 1));
        Common.msg("Header Offset: " + Common.getHex(headerOffset, 2));
        Common.msg("Data Offset: " + Common.getHex(dataOffset, 2));
        Common.msg("Padding: " + padding);
        Common.line();
        format.getModel().addRow("Banks", bankCount, false);
        format.getModel().addRow("Frames", frameTotal, false);
        format.getModel().addRow("Constant", constant, false);
        format.getModel().addRow("Padding ??", padding, false);
        format.getModel().addRow("Padding ??", padding2, false);
        ArrayList<CAnimBank> banks = new ArrayList<CAnimBank>();
        for (int i = 0; i < bankCount; ++i) {
            int jump = 32 + i * 16;
            int frameCount = Common.getInt(data, jump, 4);
            int bankType = Common.getInt(data, jump + 4, 2);
            int unknown2 = Common.getInt(data, jump + 6, 2);
            int unknown3 = Common.getInt(data, jump + 8, 4);
            int frameOffset = Common.getInt(data, jump + 12, 4);
            CAnimBank bank = new CAnimBank();
            if (i < labels.size()) {
                bank.setName(labels.get(i));
            }
            int bankWidth = 0;
            switch (bankType) {
                case 0: {
                    bankWidth = 4;
                    break;
                }
                case 1: {
                    bankWidth = 16;
                    break;
                }
                case 2: {
                    bankWidth = 8;
                }
            }
            Common.msg("Bank #" + Common.padNum(i, 2) + " | Frames: " + Common.padLeft(frameCount, 2) + " | Type: " + bankType + " | Unknown2: " + unknown2 + " | Unknown3: " + unknown3 + " | Frame Offset: " + Common.getHex(frameOffset, 2) + " | Name: " + bank.getName());
            for (int j = 0; j < frameCount; ++j) {
                jump = 8 + headerOffset + frameOffset + j * 8;
                int subOffset = Common.getInt(data, jump, 4);
                int frameWidth = Common.getInt(data, jump + 4, 2);
                int constant2 = Common.getInt(data, jump + 6, 2);
                int dataJump = 8 + dataOffset + subOffset;
                int cellOffset = Common.getInt(data, dataJump, 2);
                Common.msg("  Frame #" + Common.padNum(j, 2) + " | Offset: " + Common.getHex(jump, 2) + " | Length: " + frameWidth + " | Constant: 0x" + Common.getHex(constant2, 2) + " | Cell Id: " + cellOffset + " | Data: " + Common.getHex(data, dataJump, bankWidth));
                CAnim frame = new CAnim();
                frame.setCellOffset(cellOffset);
                frame.setLength((int)Math.round((double)frameWidth / 60.0 * 1000.0));
                if (bankType == 1) {
                    Common.getFixed(data, dataJump + 2, "1.3.12");
                }
                if (bankType == 2) {
                    // empty if block
                }
                bank.add(frame);
            }
            Common.line();
            banks.add(bank);
        }
        return banks;
    }
}

